/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutGroupingConfigurationResponse extends ApplicationSignalsResponse implements
        ToCopyableBuilder<PutGroupingConfigurationResponse.Builder, PutGroupingConfigurationResponse> {
    private static final SdkField<GroupingConfiguration> GROUPING_CONFIGURATION_FIELD = SdkField
            .<GroupingConfiguration> builder(MarshallingType.SDK_POJO).memberName("GroupingConfiguration")
            .getter(getter(PutGroupingConfigurationResponse::groupingConfiguration))
            .setter(setter(Builder::groupingConfiguration)).constructor(GroupingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupingConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUPING_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final GroupingConfiguration groupingConfiguration;

    private PutGroupingConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.groupingConfiguration = builder.groupingConfiguration;
    }

    /**
     * <p>
     * A structure containing the updated grouping configuration, including all grouping attribute definitions and the
     * timestamp when it was last updated.
     * </p>
     * 
     * @return A structure containing the updated grouping configuration, including all grouping attribute definitions
     *         and the timestamp when it was last updated.
     */
    public final GroupingConfiguration groupingConfiguration() {
        return groupingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(groupingConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutGroupingConfigurationResponse)) {
            return false;
        }
        PutGroupingConfigurationResponse other = (PutGroupingConfigurationResponse) obj;
        return Objects.equals(groupingConfiguration(), other.groupingConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutGroupingConfigurationResponse").add("GroupingConfiguration", groupingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupingConfiguration":
            return Optional.ofNullable(clazz.cast(groupingConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GroupingConfiguration", GROUPING_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutGroupingConfigurationResponse, T> g) {
        return obj -> g.apply((PutGroupingConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ApplicationSignalsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, PutGroupingConfigurationResponse> {
        /**
         * <p>
         * A structure containing the updated grouping configuration, including all grouping attribute definitions and
         * the timestamp when it was last updated.
         * </p>
         * 
         * @param groupingConfiguration
         *        A structure containing the updated grouping configuration, including all grouping attribute
         *        definitions and the timestamp when it was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupingConfiguration(GroupingConfiguration groupingConfiguration);

        /**
         * <p>
         * A structure containing the updated grouping configuration, including all grouping attribute definitions and
         * the timestamp when it was last updated.
         * </p>
         * This is a convenience method that creates an instance of the {@link GroupingConfiguration.Builder} avoiding
         * the need to create one manually via {@link GroupingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GroupingConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #groupingConfiguration(GroupingConfiguration)}.
         * 
         * @param groupingConfiguration
         *        a consumer that will call methods on {@link GroupingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupingConfiguration(GroupingConfiguration)
         */
        default Builder groupingConfiguration(Consumer<GroupingConfiguration.Builder> groupingConfiguration) {
            return groupingConfiguration(GroupingConfiguration.builder().applyMutation(groupingConfiguration).build());
        }
    }

    static final class BuilderImpl extends ApplicationSignalsResponse.BuilderImpl implements Builder {
        private GroupingConfiguration groupingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutGroupingConfigurationResponse model) {
            super(model);
            groupingConfiguration(model.groupingConfiguration);
        }

        public final GroupingConfiguration.Builder getGroupingConfiguration() {
            return groupingConfiguration != null ? groupingConfiguration.toBuilder() : null;
        }

        public final void setGroupingConfiguration(GroupingConfiguration.BuilderImpl groupingConfiguration) {
            this.groupingConfiguration = groupingConfiguration != null ? groupingConfiguration.build() : null;
        }

        @Override
        public final Builder groupingConfiguration(GroupingConfiguration groupingConfiguration) {
            this.groupingConfiguration = groupingConfiguration;
            return this;
        }

        @Override
        public PutGroupingConfigurationResponse build() {
            return new PutGroupingConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
