/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that represents a node in a dependency graph, containing information about a service, resource, or other
 * entity and its characteristics.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Node implements SdkPojo, Serializable, ToCopyableBuilder<Node.Builder, Node> {
    private static final SdkField<Map<String, String>> KEY_ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("KeyAttributes")
            .getter(getter(Node::keyAttributes))
            .setter(setter(Builder::keyAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Node::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> NODE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("NodeId")
            .getter(getter(Node::nodeId)).setter(setter(Builder::nodeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeId").build()).build();

    private static final SdkField<String> OPERATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Operation").getter(getter(Node::operation)).setter(setter(Builder::operation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operation").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Node::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Double> DURATION_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("Duration").getter(getter(Node::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Node::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ATTRIBUTES_FIELD,
            NAME_FIELD, NODE_ID_FIELD, OPERATION_FIELD, TYPE_FIELD, DURATION_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Map<String, String> keyAttributes;

    private final String name;

    private final String nodeId;

    private final String operation;

    private final String type;

    private final Double duration;

    private final String status;

    private Node(BuilderImpl builder) {
        this.keyAttributes = builder.keyAttributes;
        this.name = builder.name;
        this.nodeId = builder.nodeId;
        this.operation = builder.operation;
        this.type = builder.type;
        this.duration = builder.duration;
        this.status = builder.status;
    }

    /**
     * For responses, this returns true if the service returned a value for the KeyAttributes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasKeyAttributes() {
        return keyAttributes != null && !(keyAttributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The key attributes that identify this node, including Type, Name, and Environment information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKeyAttributes} method.
     * </p>
     * 
     * @return The key attributes that identify this node, including Type, Name, and Environment information.
     */
    public final Map<String, String> keyAttributes() {
        return keyAttributes;
    }

    /**
     * <p>
     * The name of the entity represented by this node.
     * </p>
     * 
     * @return The name of the entity represented by this node.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A unique identifier for this node within the dependency graph.
     * </p>
     * 
     * @return A unique identifier for this node within the dependency graph.
     */
    public final String nodeId() {
        return nodeId;
    }

    /**
     * <p>
     * The operation associated with this node, if applicable.
     * </p>
     * 
     * @return The operation associated with this node, if applicable.
     */
    public final String operation() {
        return operation;
    }

    /**
     * <p>
     * The type of entity represented by this node, such as <code>Service</code> or <code>Resource</code>.
     * </p>
     * 
     * @return The type of entity represented by this node, such as <code>Service</code> or <code>Resource</code>.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The duration or processing time associated with this node, if applicable.
     * </p>
     * 
     * @return The duration or processing time associated with this node, if applicable.
     */
    public final Double duration() {
        return duration;
    }

    /**
     * <p>
     * The status of the entity represented by this node.
     * </p>
     * 
     * @return The status of the entity represented by this node.
     */
    public final String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasKeyAttributes() ? keyAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(nodeId());
        hashCode = 31 * hashCode + Objects.hashCode(operation());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Node)) {
            return false;
        }
        Node other = (Node) obj;
        return hasKeyAttributes() == other.hasKeyAttributes() && Objects.equals(keyAttributes(), other.keyAttributes())
                && Objects.equals(name(), other.name()) && Objects.equals(nodeId(), other.nodeId())
                && Objects.equals(operation(), other.operation()) && Objects.equals(type(), other.type())
                && Objects.equals(duration(), other.duration()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Node").add("KeyAttributes", hasKeyAttributes() ? keyAttributes() : null).add("Name", name())
                .add("NodeId", nodeId()).add("Operation", operation()).add("Type", type()).add("Duration", duration())
                .add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyAttributes":
            return Optional.ofNullable(clazz.cast(keyAttributes()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "NodeId":
            return Optional.ofNullable(clazz.cast(nodeId()));
        case "Operation":
            return Optional.ofNullable(clazz.cast(operation()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("KeyAttributes", KEY_ATTRIBUTES_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("NodeId", NODE_ID_FIELD);
        map.put("Operation", OPERATION_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Duration", DURATION_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Node, T> g) {
        return obj -> g.apply((Node) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Node> {
        /**
         * <p>
         * The key attributes that identify this node, including Type, Name, and Environment information.
         * </p>
         * 
         * @param keyAttributes
         *        The key attributes that identify this node, including Type, Name, and Environment information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyAttributes(Map<String, String> keyAttributes);

        /**
         * <p>
         * The name of the entity represented by this node.
         * </p>
         * 
         * @param name
         *        The name of the entity represented by this node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A unique identifier for this node within the dependency graph.
         * </p>
         * 
         * @param nodeId
         *        A unique identifier for this node within the dependency graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeId(String nodeId);

        /**
         * <p>
         * The operation associated with this node, if applicable.
         * </p>
         * 
         * @param operation
         *        The operation associated with this node, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operation(String operation);

        /**
         * <p>
         * The type of entity represented by this node, such as <code>Service</code> or <code>Resource</code>.
         * </p>
         * 
         * @param type
         *        The type of entity represented by this node, such as <code>Service</code> or <code>Resource</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The duration or processing time associated with this node, if applicable.
         * </p>
         * 
         * @param duration
         *        The duration or processing time associated with this node, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Double duration);

        /**
         * <p>
         * The status of the entity represented by this node.
         * </p>
         * 
         * @param status
         *        The status of the entity represented by this node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> keyAttributes = DefaultSdkAutoConstructMap.getInstance();

        private String name;

        private String nodeId;

        private String operation;

        private String type;

        private Double duration;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(Node model) {
            keyAttributes(model.keyAttributes);
            name(model.name);
            nodeId(model.nodeId);
            operation(model.operation);
            type(model.type);
            duration(model.duration);
            status(model.status);
        }

        public final Map<String, String> getKeyAttributes() {
            if (keyAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return keyAttributes;
        }

        public final void setKeyAttributes(Map<String, String> keyAttributes) {
            this.keyAttributes = AttributesCopier.copy(keyAttributes);
        }

        @Override
        public final Builder keyAttributes(Map<String, String> keyAttributes) {
            this.keyAttributes = AttributesCopier.copy(keyAttributes);
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNodeId() {
            return nodeId;
        }

        public final void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public final Builder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public final String getOperation() {
            return operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final Double getDuration() {
            return duration;
        }

        public final void setDuration(Double duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Double duration) {
            this.duration = duration;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public Node build() {
            return new Node(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
