/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListServiceDependentsResponse extends ApplicationSignalsResponse implements
        ToCopyableBuilder<ListServiceDependentsResponse.Builder, ListServiceDependentsResponse> {
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(ListServiceDependentsResponse::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(ListServiceDependentsResponse::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<List<ServiceDependent>> SERVICE_DEPENDENTS_FIELD = SdkField
            .<List<ServiceDependent>> builder(MarshallingType.LIST)
            .memberName("ServiceDependents")
            .getter(getter(ListServiceDependentsResponse::serviceDependents))
            .setter(setter(Builder::serviceDependents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceDependents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServiceDependent> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceDependent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListServiceDependentsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD,
            END_TIME_FIELD, SERVICE_DEPENDENTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant startTime;

    private final Instant endTime;

    private final List<ServiceDependent> serviceDependents;

    private final String nextToken;

    private ListServiceDependentsResponse(BuilderImpl builder) {
        super(builder);
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.serviceDependents = builder.serviceDependents;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The start of the time period that the returned information applies to. When used in a raw HTTP Query API, it is
     * formatted as be epoch time in seconds. For example: <code>1698778057</code>
     * </p>
     * <p>
     * This displays the time that Application Signals used for the request. It might not match your request exactly,
     * because it was rounded to the nearest hour.
     * </p>
     * 
     * @return The start of the time period that the returned information applies to. When used in a raw HTTP Query API,
     *         it is formatted as be epoch time in seconds. For example: <code>1698778057</code> </p>
     *         <p>
     *         This displays the time that Application Signals used for the request. It might not match your request
     *         exactly, because it was rounded to the nearest hour.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end of the time period that the returned information applies to. When used in a raw HTTP Query API, it is
     * formatted as be epoch time in seconds. For example: <code>1698778057</code>
     * </p>
     * <p>
     * This displays the time that Application Signals used for the request. It might not match your request exactly,
     * because it was rounded to the nearest hour.
     * </p>
     * 
     * @return The end of the time period that the returned information applies to. When used in a raw HTTP Query API,
     *         it is formatted as be epoch time in seconds. For example: <code>1698778057</code> </p>
     *         <p>
     *         This displays the time that Application Signals used for the request. It might not match your request
     *         exactly, because it was rounded to the nearest hour.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the ServiceDependents property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasServiceDependents() {
        return serviceDependents != null && !(serviceDependents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array, where each object in the array contains information about one of the dependents of this service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServiceDependents} method.
     * </p>
     * 
     * @return An array, where each object in the array contains information about one of the dependents of this
     *         service.
     */
    public final List<ServiceDependent> serviceDependents() {
        return serviceDependents;
    }

    /**
     * <p>
     * Include this value in your next use of this API to get next set of service dependents.
     * </p>
     * 
     * @return Include this value in your next use of this API to get next set of service dependents.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasServiceDependents() ? serviceDependents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServiceDependentsResponse)) {
            return false;
        }
        ListServiceDependentsResponse other = (ListServiceDependentsResponse) obj;
        return Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && hasServiceDependents() == other.hasServiceDependents()
                && Objects.equals(serviceDependents(), other.serviceDependents())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListServiceDependentsResponse").add("StartTime", startTime()).add("EndTime", endTime())
                .add("ServiceDependents", hasServiceDependents() ? serviceDependents() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "ServiceDependents":
            return Optional.ofNullable(clazz.cast(serviceDependents()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("ServiceDependents", SERVICE_DEPENDENTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListServiceDependentsResponse, T> g) {
        return obj -> g.apply((ListServiceDependentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ApplicationSignalsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListServiceDependentsResponse> {
        /**
         * <p>
         * The start of the time period that the returned information applies to. When used in a raw HTTP Query API, it
         * is formatted as be epoch time in seconds. For example: <code>1698778057</code>
         * </p>
         * <p>
         * This displays the time that Application Signals used for the request. It might not match your request
         * exactly, because it was rounded to the nearest hour.
         * </p>
         * 
         * @param startTime
         *        The start of the time period that the returned information applies to. When used in a raw HTTP Query
         *        API, it is formatted as be epoch time in seconds. For example: <code>1698778057</code> </p>
         *        <p>
         *        This displays the time that Application Signals used for the request. It might not match your request
         *        exactly, because it was rounded to the nearest hour.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The end of the time period that the returned information applies to. When used in a raw HTTP Query API, it is
         * formatted as be epoch time in seconds. For example: <code>1698778057</code>
         * </p>
         * <p>
         * This displays the time that Application Signals used for the request. It might not match your request
         * exactly, because it was rounded to the nearest hour.
         * </p>
         * 
         * @param endTime
         *        The end of the time period that the returned information applies to. When used in a raw HTTP Query
         *        API, it is formatted as be epoch time in seconds. For example: <code>1698778057</code> </p>
         *        <p>
         *        This displays the time that Application Signals used for the request. It might not match your request
         *        exactly, because it was rounded to the nearest hour.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * An array, where each object in the array contains information about one of the dependents of this service.
         * </p>
         * 
         * @param serviceDependents
         *        An array, where each object in the array contains information about one of the dependents of this
         *        service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceDependents(Collection<ServiceDependent> serviceDependents);

        /**
         * <p>
         * An array, where each object in the array contains information about one of the dependents of this service.
         * </p>
         * 
         * @param serviceDependents
         *        An array, where each object in the array contains information about one of the dependents of this
         *        service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceDependents(ServiceDependent... serviceDependents);

        /**
         * <p>
         * An array, where each object in the array contains information about one of the dependents of this service.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.applicationsignals.model.ServiceDependent.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.applicationsignals.model.ServiceDependent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.applicationsignals.model.ServiceDependent.Builder#build()} is called
         * immediately and its result is passed to {@link #serviceDependents(List<ServiceDependent>)}.
         * 
         * @param serviceDependents
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.applicationsignals.model.ServiceDependent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceDependents(java.util.Collection<ServiceDependent>)
         */
        Builder serviceDependents(Consumer<ServiceDependent.Builder>... serviceDependents);

        /**
         * <p>
         * Include this value in your next use of this API to get next set of service dependents.
         * </p>
         * 
         * @param nextToken
         *        Include this value in your next use of this API to get next set of service dependents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ApplicationSignalsResponse.BuilderImpl implements Builder {
        private Instant startTime;

        private Instant endTime;

        private List<ServiceDependent> serviceDependents = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServiceDependentsResponse model) {
            super(model);
            startTime(model.startTime);
            endTime(model.endTime);
            serviceDependents(model.serviceDependents);
            nextToken(model.nextToken);
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final List<ServiceDependent.Builder> getServiceDependents() {
            List<ServiceDependent.Builder> result = ServiceDependentsCopier.copyToBuilder(this.serviceDependents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceDependents(Collection<ServiceDependent.BuilderImpl> serviceDependents) {
            this.serviceDependents = ServiceDependentsCopier.copyFromBuilder(serviceDependents);
        }

        @Override
        public final Builder serviceDependents(Collection<ServiceDependent> serviceDependents) {
            this.serviceDependents = ServiceDependentsCopier.copy(serviceDependents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceDependents(ServiceDependent... serviceDependents) {
            serviceDependents(Arrays.asList(serviceDependents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceDependents(Consumer<ServiceDependent.Builder>... serviceDependents) {
            serviceDependents(Stream.of(serviceDependents).map(c -> ServiceDependent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListServiceDependentsResponse build() {
            return new ListServiceDependentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
