/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListGroupingAttributeDefinitionsRequest extends ApplicationSignalsRequest implements
        ToCopyableBuilder<ListGroupingAttributeDefinitionsRequest.Builder, ListGroupingAttributeDefinitionsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListGroupingAttributeDefinitionsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()).build();

    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(ListGroupingAttributeDefinitionsRequest::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("AwsAccountId").build()).build();

    private static final SdkField<Boolean> INCLUDE_LINKED_ACCOUNTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeLinkedAccounts").getter(getter(ListGroupingAttributeDefinitionsRequest::includeLinkedAccounts))
            .setter(setter(Builder::includeLinkedAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("IncludeLinkedAccounts").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            AWS_ACCOUNT_ID_FIELD, INCLUDE_LINKED_ACCOUNTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final String awsAccountId;

    private final Boolean includeLinkedAccounts;

    private ListGroupingAttributeDefinitionsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.awsAccountId = builder.awsAccountId;
        this.includeLinkedAccounts = builder.includeLinkedAccounts;
    }

    /**
     * <p>
     * Include this value, if it was returned by the previous operation, to get the next set of grouping attribute
     * definitions.
     * </p>
     * 
     * @return Include this value, if it was returned by the previous operation, to get the next set of grouping
     *         attribute definitions.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The Amazon Web Services account ID to retrieve grouping attribute definitions for. Use this when accessing
     * grouping configurations from a different account in cross-account monitoring scenarios.
     * </p>
     * 
     * @return The Amazon Web Services account ID to retrieve grouping attribute definitions for. Use this when
     *         accessing grouping configurations from a different account in cross-account monitoring scenarios.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * If you are using this operation in a monitoring account, specify <code>true</code> to include grouping attributes
     * from source accounts in the returned data.
     * </p>
     * 
     * @return If you are using this operation in a monitoring account, specify <code>true</code> to include grouping
     *         attributes from source accounts in the returned data.
     */
    public final Boolean includeLinkedAccounts() {
        return includeLinkedAccounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(includeLinkedAccounts());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGroupingAttributeDefinitionsRequest)) {
            return false;
        }
        ListGroupingAttributeDefinitionsRequest other = (ListGroupingAttributeDefinitionsRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(awsAccountId(), other.awsAccountId())
                && Objects.equals(includeLinkedAccounts(), other.includeLinkedAccounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListGroupingAttributeDefinitionsRequest").add("NextToken", nextToken())
                .add("AwsAccountId", awsAccountId()).add("IncludeLinkedAccounts", includeLinkedAccounts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "IncludeLinkedAccounts":
            return Optional.ofNullable(clazz.cast(includeLinkedAccounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("IncludeLinkedAccounts", INCLUDE_LINKED_ACCOUNTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListGroupingAttributeDefinitionsRequest, T> g) {
        return obj -> g.apply((ListGroupingAttributeDefinitionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ApplicationSignalsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListGroupingAttributeDefinitionsRequest> {
        /**
         * <p>
         * Include this value, if it was returned by the previous operation, to get the next set of grouping attribute
         * definitions.
         * </p>
         * 
         * @param nextToken
         *        Include this value, if it was returned by the previous operation, to get the next set of grouping
         *        attribute definitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The Amazon Web Services account ID to retrieve grouping attribute definitions for. Use this when accessing
         * grouping configurations from a different account in cross-account monitoring scenarios.
         * </p>
         * 
         * @param awsAccountId
         *        The Amazon Web Services account ID to retrieve grouping attribute definitions for. Use this when
         *        accessing grouping configurations from a different account in cross-account monitoring scenarios.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * If you are using this operation in a monitoring account, specify <code>true</code> to include grouping
         * attributes from source accounts in the returned data.
         * </p>
         * 
         * @param includeLinkedAccounts
         *        If you are using this operation in a monitoring account, specify <code>true</code> to include grouping
         *        attributes from source accounts in the returned data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeLinkedAccounts(Boolean includeLinkedAccounts);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApplicationSignalsRequest.BuilderImpl implements Builder {
        private String nextToken;

        private String awsAccountId;

        private Boolean includeLinkedAccounts;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGroupingAttributeDefinitionsRequest model) {
            super(model);
            nextToken(model.nextToken);
            awsAccountId(model.awsAccountId);
            includeLinkedAccounts(model.includeLinkedAccounts);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final Boolean getIncludeLinkedAccounts() {
            return includeLinkedAccounts;
        }

        public final void setIncludeLinkedAccounts(Boolean includeLinkedAccounts) {
            this.includeLinkedAccounts = includeLinkedAccounts;
        }

        @Override
        public final Builder includeLinkedAccounts(Boolean includeLinkedAccounts) {
            this.includeLinkedAccounts = includeLinkedAccounts;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListGroupingAttributeDefinitionsRequest build() {
            return new ListGroupingAttributeDefinitionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
