/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class GroupingAttributeDefinitionsCopier {
    static List<GroupingAttributeDefinition> copy(
            Collection<? extends GroupingAttributeDefinition> groupingAttributeDefinitionsParam) {
        List<GroupingAttributeDefinition> list;
        if (groupingAttributeDefinitionsParam == null || groupingAttributeDefinitionsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<GroupingAttributeDefinition> modifiableList = new ArrayList<>(groupingAttributeDefinitionsParam.size());
            groupingAttributeDefinitionsParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<GroupingAttributeDefinition> copyFromBuilder(
            Collection<? extends GroupingAttributeDefinition.Builder> groupingAttributeDefinitionsParam) {
        List<GroupingAttributeDefinition> list;
        if (groupingAttributeDefinitionsParam == null || groupingAttributeDefinitionsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<GroupingAttributeDefinition> modifiableList = new ArrayList<>(groupingAttributeDefinitionsParam.size());
            groupingAttributeDefinitionsParam.forEach(entry -> {
                GroupingAttributeDefinition member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<GroupingAttributeDefinition.Builder> copyToBuilder(
            Collection<? extends GroupingAttributeDefinition> groupingAttributeDefinitionsParam) {
        List<GroupingAttributeDefinition.Builder> list;
        if (groupingAttributeDefinitionsParam == null || groupingAttributeDefinitionsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<GroupingAttributeDefinition.Builder> modifiableList = new ArrayList<>(groupingAttributeDefinitionsParam.size());
            groupingAttributeDefinitionsParam.forEach(entry -> {
                GroupingAttributeDefinition.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
