/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains identifying information for a CloudWatch Synthetics canary entity used in audit targeting.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CanaryEntity implements SdkPojo, Serializable, ToCopyableBuilder<CanaryEntity.Builder, CanaryEntity> {
    private static final SdkField<String> CANARY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CanaryName").getter(getter(CanaryEntity::canaryName)).setter(setter(Builder::canaryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CanaryName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CANARY_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String canaryName;

    private CanaryEntity(BuilderImpl builder) {
        this.canaryName = builder.canaryName;
    }

    /**
     * <p>
     * The name of the CloudWatch Synthetics canary.
     * </p>
     * 
     * @return The name of the CloudWatch Synthetics canary.
     */
    public final String canaryName() {
        return canaryName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(canaryName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CanaryEntity)) {
            return false;
        }
        CanaryEntity other = (CanaryEntity) obj;
        return Objects.equals(canaryName(), other.canaryName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CanaryEntity").add("CanaryName", canaryName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CanaryName":
            return Optional.ofNullable(clazz.cast(canaryName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CanaryName", CANARY_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CanaryEntity, T> g) {
        return obj -> g.apply((CanaryEntity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CanaryEntity> {
        /**
         * <p>
         * The name of the CloudWatch Synthetics canary.
         * </p>
         * 
         * @param canaryName
         *        The name of the CloudWatch Synthetics canary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canaryName(String canaryName);
    }

    static final class BuilderImpl implements Builder {
        private String canaryName;

        private BuilderImpl() {
        }

        private BuilderImpl(CanaryEntity model) {
            canaryName(model.canaryName);
        }

        public final String getCanaryName() {
            return canaryName;
        }

        public final void setCanaryName(String canaryName) {
            this.canaryName = canaryName;
        }

        @Override
        public final Builder canaryName(String canaryName) {
            this.canaryName = canaryName;
            return this;
        }

        @Override
        public CanaryEntity build() {
            return new CanaryEntity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
