/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that specifies the target entity for audit analysis, such as a <code>service</code>, <code>SLO</code>,
 * <code>service_operation</code>, or <code>canary</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuditTarget implements SdkPojo, Serializable, ToCopyableBuilder<AuditTarget.Builder, AuditTarget> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(AuditTarget::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<AuditTargetEntity> DATA_FIELD = SdkField.<AuditTargetEntity> builder(MarshallingType.SDK_POJO)
            .memberName("Data").getter(getter(AuditTarget::data)).setter(setter(Builder::data))
            .constructor(AuditTargetEntity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Data").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, DATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final AuditTargetEntity data;

    private AuditTarget(BuilderImpl builder) {
        this.type = builder.type;
        this.data = builder.data;
    }

    /**
     * <p>
     * The type of entity being audited, such as <code>service</code>, <code>SLO</code>, <code>service_operation</code>,
     * or <code>canary</code>.
     * </p>
     * 
     * @return The type of entity being audited, such as <code>service</code>, <code>SLO</code>,
     *         <code>service_operation</code>, or <code>canary</code>.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The specific data identifying the audit target entity.
     * </p>
     * 
     * @return The specific data identifying the audit target entity.
     */
    public final AuditTargetEntity data() {
        return data;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(data());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuditTarget)) {
            return false;
        }
        AuditTarget other = (AuditTarget) obj;
        return Objects.equals(type(), other.type()) && Objects.equals(data(), other.data());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuditTarget").add("Type", type()).add("Data", data()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "Data":
            return Optional.ofNullable(clazz.cast(data()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("Data", DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuditTarget, T> g) {
        return obj -> g.apply((AuditTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuditTarget> {
        /**
         * <p>
         * The type of entity being audited, such as <code>service</code>, <code>SLO</code>,
         * <code>service_operation</code>, or <code>canary</code>.
         * </p>
         * 
         * @param type
         *        The type of entity being audited, such as <code>service</code>, <code>SLO</code>,
         *        <code>service_operation</code>, or <code>canary</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The specific data identifying the audit target entity.
         * </p>
         * 
         * @param data
         *        The specific data identifying the audit target entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(AuditTargetEntity data);

        /**
         * <p>
         * The specific data identifying the audit target entity.
         * </p>
         * This is a convenience method that creates an instance of the {@link AuditTargetEntity.Builder} avoiding the
         * need to create one manually via {@link AuditTargetEntity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AuditTargetEntity.Builder#build()} is called immediately and its
         * result is passed to {@link #data(AuditTargetEntity)}.
         * 
         * @param data
         *        a consumer that will call methods on {@link AuditTargetEntity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #data(AuditTargetEntity)
         */
        default Builder data(Consumer<AuditTargetEntity.Builder> data) {
            return data(AuditTargetEntity.builder().applyMutation(data).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private AuditTargetEntity data;

        private BuilderImpl() {
        }

        private BuilderImpl(AuditTarget model) {
            type(model.type);
            data(model.data);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final AuditTargetEntity.Builder getData() {
            return data != null ? data.toBuilder() : null;
        }

        public final void setData(AuditTargetEntity.BuilderImpl data) {
            this.data = data != null ? data.build() : null;
        }

        @Override
        public final Builder data(AuditTargetEntity data) {
            this.data = data;
            return this;
        }

        @Override
        public AuditTarget build() {
            return new AuditTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
