/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains information about an audit finding, which represents an automated analysis result about
 * service behavior, performance issues, or potential problems identified through heuristic algorithms.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuditFinding implements SdkPojo, Serializable, ToCopyableBuilder<AuditFinding.Builder, AuditFinding> {
    private static final SdkField<Map<String, String>> KEY_ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("KeyAttributes")
            .getter(getter(AuditFinding::keyAttributes))
            .setter(setter(Builder::keyAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<AuditorResult>> AUDITOR_RESULTS_FIELD = SdkField
            .<List<AuditorResult>> builder(MarshallingType.LIST)
            .memberName("AuditorResults")
            .getter(getter(AuditFinding::auditorResults))
            .setter(setter(Builder::auditorResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuditorResults").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AuditorResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(AuditorResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> OPERATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Operation").getter(getter(AuditFinding::operation)).setter(setter(Builder::operation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operation").build()).build();

    private static final SdkField<MetricGraph> METRIC_GRAPH_FIELD = SdkField.<MetricGraph> builder(MarshallingType.SDK_POJO)
            .memberName("MetricGraph").getter(getter(AuditFinding::metricGraph)).setter(setter(Builder::metricGraph))
            .constructor(MetricGraph::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricGraph").build()).build();

    private static final SdkField<DependencyGraph> DEPENDENCY_GRAPH_FIELD = SdkField
            .<DependencyGraph> builder(MarshallingType.SDK_POJO).memberName("DependencyGraph")
            .getter(getter(AuditFinding::dependencyGraph)).setter(setter(Builder::dependencyGraph))
            .constructor(DependencyGraph::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DependencyGraph").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(AuditFinding::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ATTRIBUTES_FIELD,
            AUDITOR_RESULTS_FIELD, OPERATION_FIELD, METRIC_GRAPH_FIELD, DEPENDENCY_GRAPH_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Map<String, String> keyAttributes;

    private final List<AuditorResult> auditorResults;

    private final String operation;

    private final MetricGraph metricGraph;

    private final DependencyGraph dependencyGraph;

    private final String type;

    private AuditFinding(BuilderImpl builder) {
        this.keyAttributes = builder.keyAttributes;
        this.auditorResults = builder.auditorResults;
        this.operation = builder.operation;
        this.metricGraph = builder.metricGraph;
        this.dependencyGraph = builder.dependencyGraph;
        this.type = builder.type;
    }

    /**
     * For responses, this returns true if the service returned a value for the KeyAttributes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasKeyAttributes() {
        return keyAttributes != null && !(keyAttributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The key attributes that identify the service or entity this audit finding relates to. This is a string-to-string
     * map that includes fields like Type, Name, and Environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKeyAttributes} method.
     * </p>
     * 
     * @return The key attributes that identify the service or entity this audit finding relates to. This is a
     *         string-to-string map that includes fields like Type, Name, and Environment.
     */
    public final Map<String, String> keyAttributes() {
        return keyAttributes;
    }

    /**
     * For responses, this returns true if the service returned a value for the AuditorResults property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAuditorResults() {
        return auditorResults != null && !(auditorResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of auditor results that contain the specific findings, descriptions, and severity levels identified by
     * different auditing algorithms.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuditorResults} method.
     * </p>
     * 
     * @return An array of auditor results that contain the specific findings, descriptions, and severity levels
     *         identified by different auditing algorithms.
     */
    public final List<AuditorResult> auditorResults() {
        return auditorResults;
    }

    /**
     * <p>
     * The name of the operation associated with this audit finding, if the finding is specific to a particular service
     * operation.
     * </p>
     * 
     * @return The name of the operation associated with this audit finding, if the finding is specific to a particular
     *         service operation.
     */
    public final String operation() {
        return operation;
    }

    /**
     * <p>
     * A structure containing metric data queries and time range information that provides context for the audit finding
     * through relevant performance metrics.
     * </p>
     * 
     * @return A structure containing metric data queries and time range information that provides context for the audit
     *         finding through relevant performance metrics.
     */
    public final MetricGraph metricGraph() {
        return metricGraph;
    }

    /**
     * <p>
     * A structure containing nodes and edges that represent the dependency relationships relevant to this audit
     * finding, helping to understand the context and potential impact.
     * </p>
     * 
     * @return A structure containing nodes and edges that represent the dependency relationships relevant to this audit
     *         finding, helping to understand the context and potential impact.
     */
    public final DependencyGraph dependencyGraph() {
        return dependencyGraph;
    }

    /**
     * <p>
     * The type of audit finding.
     * </p>
     * 
     * @return The type of audit finding.
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasKeyAttributes() ? keyAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAuditorResults() ? auditorResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(operation());
        hashCode = 31 * hashCode + Objects.hashCode(metricGraph());
        hashCode = 31 * hashCode + Objects.hashCode(dependencyGraph());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuditFinding)) {
            return false;
        }
        AuditFinding other = (AuditFinding) obj;
        return hasKeyAttributes() == other.hasKeyAttributes() && Objects.equals(keyAttributes(), other.keyAttributes())
                && hasAuditorResults() == other.hasAuditorResults() && Objects.equals(auditorResults(), other.auditorResults())
                && Objects.equals(operation(), other.operation()) && Objects.equals(metricGraph(), other.metricGraph())
                && Objects.equals(dependencyGraph(), other.dependencyGraph()) && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuditFinding").add("KeyAttributes", hasKeyAttributes() ? keyAttributes() : null)
                .add("AuditorResults", hasAuditorResults() ? auditorResults() : null).add("Operation", operation())
                .add("MetricGraph", metricGraph()).add("DependencyGraph", dependencyGraph()).add("Type", type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyAttributes":
            return Optional.ofNullable(clazz.cast(keyAttributes()));
        case "AuditorResults":
            return Optional.ofNullable(clazz.cast(auditorResults()));
        case "Operation":
            return Optional.ofNullable(clazz.cast(operation()));
        case "MetricGraph":
            return Optional.ofNullable(clazz.cast(metricGraph()));
        case "DependencyGraph":
            return Optional.ofNullable(clazz.cast(dependencyGraph()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("KeyAttributes", KEY_ATTRIBUTES_FIELD);
        map.put("AuditorResults", AUDITOR_RESULTS_FIELD);
        map.put("Operation", OPERATION_FIELD);
        map.put("MetricGraph", METRIC_GRAPH_FIELD);
        map.put("DependencyGraph", DEPENDENCY_GRAPH_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuditFinding, T> g) {
        return obj -> g.apply((AuditFinding) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuditFinding> {
        /**
         * <p>
         * The key attributes that identify the service or entity this audit finding relates to. This is a
         * string-to-string map that includes fields like Type, Name, and Environment.
         * </p>
         * 
         * @param keyAttributes
         *        The key attributes that identify the service or entity this audit finding relates to. This is a
         *        string-to-string map that includes fields like Type, Name, and Environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyAttributes(Map<String, String> keyAttributes);

        /**
         * <p>
         * An array of auditor results that contain the specific findings, descriptions, and severity levels identified
         * by different auditing algorithms.
         * </p>
         * 
         * @param auditorResults
         *        An array of auditor results that contain the specific findings, descriptions, and severity levels
         *        identified by different auditing algorithms.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auditorResults(Collection<AuditorResult> auditorResults);

        /**
         * <p>
         * An array of auditor results that contain the specific findings, descriptions, and severity levels identified
         * by different auditing algorithms.
         * </p>
         * 
         * @param auditorResults
         *        An array of auditor results that contain the specific findings, descriptions, and severity levels
         *        identified by different auditing algorithms.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auditorResults(AuditorResult... auditorResults);

        /**
         * <p>
         * An array of auditor results that contain the specific findings, descriptions, and severity levels identified
         * by different auditing algorithms.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.applicationsignals.model.AuditorResult.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.applicationsignals.model.AuditorResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.applicationsignals.model.AuditorResult.Builder#build()} is called
         * immediately and its result is passed to {@link #auditorResults(List<AuditorResult>)}.
         * 
         * @param auditorResults
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.applicationsignals.model.AuditorResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #auditorResults(java.util.Collection<AuditorResult>)
         */
        Builder auditorResults(Consumer<AuditorResult.Builder>... auditorResults);

        /**
         * <p>
         * The name of the operation associated with this audit finding, if the finding is specific to a particular
         * service operation.
         * </p>
         * 
         * @param operation
         *        The name of the operation associated with this audit finding, if the finding is specific to a
         *        particular service operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operation(String operation);

        /**
         * <p>
         * A structure containing metric data queries and time range information that provides context for the audit
         * finding through relevant performance metrics.
         * </p>
         * 
         * @param metricGraph
         *        A structure containing metric data queries and time range information that provides context for the
         *        audit finding through relevant performance metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricGraph(MetricGraph metricGraph);

        /**
         * <p>
         * A structure containing metric data queries and time range information that provides context for the audit
         * finding through relevant performance metrics.
         * </p>
         * This is a convenience method that creates an instance of the {@link MetricGraph.Builder} avoiding the need to
         * create one manually via {@link MetricGraph#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MetricGraph.Builder#build()} is called immediately and its result
         * is passed to {@link #metricGraph(MetricGraph)}.
         * 
         * @param metricGraph
         *        a consumer that will call methods on {@link MetricGraph.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricGraph(MetricGraph)
         */
        default Builder metricGraph(Consumer<MetricGraph.Builder> metricGraph) {
            return metricGraph(MetricGraph.builder().applyMutation(metricGraph).build());
        }

        /**
         * <p>
         * A structure containing nodes and edges that represent the dependency relationships relevant to this audit
         * finding, helping to understand the context and potential impact.
         * </p>
         * 
         * @param dependencyGraph
         *        A structure containing nodes and edges that represent the dependency relationships relevant to this
         *        audit finding, helping to understand the context and potential impact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependencyGraph(DependencyGraph dependencyGraph);

        /**
         * <p>
         * A structure containing nodes and edges that represent the dependency relationships relevant to this audit
         * finding, helping to understand the context and potential impact.
         * </p>
         * This is a convenience method that creates an instance of the {@link DependencyGraph.Builder} avoiding the
         * need to create one manually via {@link DependencyGraph#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DependencyGraph.Builder#build()} is called immediately and its
         * result is passed to {@link #dependencyGraph(DependencyGraph)}.
         * 
         * @param dependencyGraph
         *        a consumer that will call methods on {@link DependencyGraph.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dependencyGraph(DependencyGraph)
         */
        default Builder dependencyGraph(Consumer<DependencyGraph.Builder> dependencyGraph) {
            return dependencyGraph(DependencyGraph.builder().applyMutation(dependencyGraph).build());
        }

        /**
         * <p>
         * The type of audit finding.
         * </p>
         * 
         * @param type
         *        The type of audit finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> keyAttributes = DefaultSdkAutoConstructMap.getInstance();

        private List<AuditorResult> auditorResults = DefaultSdkAutoConstructList.getInstance();

        private String operation;

        private MetricGraph metricGraph;

        private DependencyGraph dependencyGraph;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(AuditFinding model) {
            keyAttributes(model.keyAttributes);
            auditorResults(model.auditorResults);
            operation(model.operation);
            metricGraph(model.metricGraph);
            dependencyGraph(model.dependencyGraph);
            type(model.type);
        }

        public final Map<String, String> getKeyAttributes() {
            if (keyAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return keyAttributes;
        }

        public final void setKeyAttributes(Map<String, String> keyAttributes) {
            this.keyAttributes = AttributesCopier.copy(keyAttributes);
        }

        @Override
        public final Builder keyAttributes(Map<String, String> keyAttributes) {
            this.keyAttributes = AttributesCopier.copy(keyAttributes);
            return this;
        }

        public final List<AuditorResult.Builder> getAuditorResults() {
            List<AuditorResult.Builder> result = AuditorResultsCopier.copyToBuilder(this.auditorResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAuditorResults(Collection<AuditorResult.BuilderImpl> auditorResults) {
            this.auditorResults = AuditorResultsCopier.copyFromBuilder(auditorResults);
        }

        @Override
        public final Builder auditorResults(Collection<AuditorResult> auditorResults) {
            this.auditorResults = AuditorResultsCopier.copy(auditorResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder auditorResults(AuditorResult... auditorResults) {
            auditorResults(Arrays.asList(auditorResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder auditorResults(Consumer<AuditorResult.Builder>... auditorResults) {
            auditorResults(Stream.of(auditorResults).map(c -> AuditorResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getOperation() {
            return operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        public final MetricGraph.Builder getMetricGraph() {
            return metricGraph != null ? metricGraph.toBuilder() : null;
        }

        public final void setMetricGraph(MetricGraph.BuilderImpl metricGraph) {
            this.metricGraph = metricGraph != null ? metricGraph.build() : null;
        }

        @Override
        public final Builder metricGraph(MetricGraph metricGraph) {
            this.metricGraph = metricGraph;
            return this;
        }

        public final DependencyGraph.Builder getDependencyGraph() {
            return dependencyGraph != null ? dependencyGraph.toBuilder() : null;
        }

        public final void setDependencyGraph(DependencyGraph.BuilderImpl dependencyGraph) {
            this.dependencyGraph = dependencyGraph != null ? dependencyGraph.build() : null;
        }

        @Override
        public final Builder dependencyGraph(DependencyGraph dependencyGraph) {
            this.dependencyGraph = dependencyGraph;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public AuditFinding build() {
            return new AuditFinding(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
