/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationsignals.model.ApplicationSignalsResponse;
import software.amazon.awssdk.services.applicationsignals.model.AuditFinding;
import software.amazon.awssdk.services.applicationsignals.model.AuditFindingsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAuditFindingsResponse
extends ApplicationSignalsResponse
implements ToCopyableBuilder<Builder, ListAuditFindingsResponse> {
    private static final SdkField<List<AuditFinding>> AUDIT_FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AuditFindings").getter(ListAuditFindingsResponse.getter(ListAuditFindingsResponse::auditFindings)).setter(ListAuditFindingsResponse.setter(Builder::auditFindings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuditFindings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AuditFinding::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAuditFindingsResponse.getter(ListAuditFindingsResponse::nextToken)).setter(ListAuditFindingsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIT_FINDINGS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAuditFindingsResponse.memberNameToFieldInitializer();
    private final List<AuditFinding> auditFindings;
    private final String nextToken;

    private ListAuditFindingsResponse(BuilderImpl builder) {
        super(builder);
        this.auditFindings = builder.auditFindings;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAuditFindings() {
        return this.auditFindings != null && !(this.auditFindings instanceof SdkAutoConstructList);
    }

    public final List<AuditFinding> auditFindings() {
        return this.auditFindings;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuditFindings() ? this.auditFindings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAuditFindingsResponse)) {
            return false;
        }
        ListAuditFindingsResponse other = (ListAuditFindingsResponse)((Object)obj);
        return this.hasAuditFindings() == other.hasAuditFindings() && Objects.equals(this.auditFindings(), other.auditFindings()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAuditFindingsResponse").add("AuditFindings", this.hasAuditFindings() ? this.auditFindings() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuditFindings": {
                return Optional.ofNullable(clazz.cast(this.auditFindings()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AuditFindings", AUDIT_FINDINGS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAuditFindingsResponse, T> g) {
        return obj -> g.apply((ListAuditFindingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationSignalsResponse.BuilderImpl
    implements Builder {
        private List<AuditFinding> auditFindings = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAuditFindingsResponse model) {
            super(model);
            this.auditFindings(model.auditFindings);
            this.nextToken(model.nextToken);
        }

        public final List<AuditFinding.Builder> getAuditFindings() {
            List<AuditFinding.Builder> result = AuditFindingsCopier.copyToBuilder(this.auditFindings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAuditFindings(Collection<AuditFinding.BuilderImpl> auditFindings) {
            this.auditFindings = AuditFindingsCopier.copyFromBuilder(auditFindings);
        }

        @Override
        public final Builder auditFindings(Collection<AuditFinding> auditFindings) {
            this.auditFindings = AuditFindingsCopier.copy(auditFindings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder auditFindings(AuditFinding ... auditFindings) {
            this.auditFindings(Arrays.asList(auditFindings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder auditFindings(Consumer<AuditFinding.Builder> ... auditFindings) {
            this.auditFindings(Stream.of(auditFindings).map(c -> (AuditFinding)((AuditFinding.Builder)AuditFinding.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAuditFindingsResponse build() {
            return new ListAuditFindingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ApplicationSignalsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAuditFindingsResponse> {
        public Builder auditFindings(Collection<AuditFinding> var1);

        public Builder auditFindings(AuditFinding ... var1);

        public Builder auditFindings(Consumer<AuditFinding.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

