/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.applicationsignals.model.AttributeMapsCopier;
import software.amazon.awssdk.services.applicationsignals.model.AttributesCopier;
import software.amazon.awssdk.services.applicationsignals.model.MetricReference;
import software.amazon.awssdk.services.applicationsignals.model.MetricReferencesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceSummary> {
    private static final SdkField<Map<String, String>> KEY_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("KeyAttributes").getter(ServiceSummary.getter(ServiceSummary::keyAttributes)).setter(ServiceSummary.setter(Builder::keyAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<Map<String, String>>> ATTRIBUTE_MAPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttributeMaps").getter(ServiceSummary.getter(ServiceSummary::attributeMaps)).setter(ServiceSummary.setter(Builder::attributeMaps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeMaps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<List<MetricReference>> METRIC_REFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricReferences").getter(ServiceSummary.getter(ServiceSummary::metricReferences)).setter(ServiceSummary.setter(Builder::metricReferences)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricReferences").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ATTRIBUTES_FIELD, ATTRIBUTE_MAPS_FIELD, METRIC_REFERENCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServiceSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, String> keyAttributes;
    private final List<Map<String, String>> attributeMaps;
    private final List<MetricReference> metricReferences;

    private ServiceSummary(BuilderImpl builder) {
        this.keyAttributes = builder.keyAttributes;
        this.attributeMaps = builder.attributeMaps;
        this.metricReferences = builder.metricReferences;
    }

    public final boolean hasKeyAttributes() {
        return this.keyAttributes != null && !(this.keyAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> keyAttributes() {
        return this.keyAttributes;
    }

    public final boolean hasAttributeMaps() {
        return this.attributeMaps != null && !(this.attributeMaps instanceof SdkAutoConstructList);
    }

    public final List<Map<String, String>> attributeMaps() {
        return this.attributeMaps;
    }

    public final boolean hasMetricReferences() {
        return this.metricReferences != null && !(this.metricReferences instanceof SdkAutoConstructList);
    }

    public final List<MetricReference> metricReferences() {
        return this.metricReferences;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKeyAttributes() ? this.keyAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributeMaps() ? this.attributeMaps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricReferences() ? this.metricReferences() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceSummary)) {
            return false;
        }
        ServiceSummary other = (ServiceSummary)obj;
        return this.hasKeyAttributes() == other.hasKeyAttributes() && Objects.equals(this.keyAttributes(), other.keyAttributes()) && this.hasAttributeMaps() == other.hasAttributeMaps() && Objects.equals(this.attributeMaps(), other.attributeMaps()) && this.hasMetricReferences() == other.hasMetricReferences() && Objects.equals(this.metricReferences(), other.metricReferences());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceSummary").add("KeyAttributes", this.hasKeyAttributes() ? this.keyAttributes() : null).add("AttributeMaps", this.hasAttributeMaps() ? this.attributeMaps() : null).add("MetricReferences", this.hasMetricReferences() ? this.metricReferences() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyAttributes": {
                return Optional.ofNullable(clazz.cast(this.keyAttributes()));
            }
            case "AttributeMaps": {
                return Optional.ofNullable(clazz.cast(this.attributeMaps()));
            }
            case "MetricReferences": {
                return Optional.ofNullable(clazz.cast(this.metricReferences()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("KeyAttributes", KEY_ATTRIBUTES_FIELD);
        map.put("AttributeMaps", ATTRIBUTE_MAPS_FIELD);
        map.put("MetricReferences", METRIC_REFERENCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceSummary, T> g) {
        return obj -> g.apply((ServiceSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> keyAttributes = DefaultSdkAutoConstructMap.getInstance();
        private List<Map<String, String>> attributeMaps = DefaultSdkAutoConstructList.getInstance();
        private List<MetricReference> metricReferences = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceSummary model) {
            this.keyAttributes(model.keyAttributes);
            this.attributeMaps(model.attributeMaps);
            this.metricReferences(model.metricReferences);
        }

        public final Map<String, String> getKeyAttributes() {
            if (this.keyAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.keyAttributes;
        }

        public final void setKeyAttributes(Map<String, String> keyAttributes) {
            this.keyAttributes = AttributesCopier.copy(keyAttributes);
        }

        @Override
        public final Builder keyAttributes(Map<String, String> keyAttributes) {
            this.keyAttributes = AttributesCopier.copy(keyAttributes);
            return this;
        }

        public final Collection<? extends Map<String, String>> getAttributeMaps() {
            if (this.attributeMaps instanceof SdkAutoConstructList) {
                return null;
            }
            return this.attributeMaps;
        }

        public final void setAttributeMaps(Collection<? extends Map<String, String>> attributeMaps) {
            this.attributeMaps = AttributeMapsCopier.copy(attributeMaps);
        }

        @Override
        public final Builder attributeMaps(Collection<? extends Map<String, String>> attributeMaps) {
            this.attributeMaps = AttributeMapsCopier.copy(attributeMaps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeMaps(Map<String, String> ... attributeMaps) {
            this.attributeMaps(Arrays.asList(attributeMaps));
            return this;
        }

        public final List<MetricReference.Builder> getMetricReferences() {
            List<MetricReference.Builder> result = MetricReferencesCopier.copyToBuilder(this.metricReferences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricReferences(Collection<MetricReference.BuilderImpl> metricReferences) {
            this.metricReferences = MetricReferencesCopier.copyFromBuilder(metricReferences);
        }

        @Override
        public final Builder metricReferences(Collection<MetricReference> metricReferences) {
            this.metricReferences = MetricReferencesCopier.copy(metricReferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricReferences(MetricReference ... metricReferences) {
            this.metricReferences(Arrays.asList(metricReferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricReferences(Consumer<MetricReference.Builder> ... metricReferences) {
            this.metricReferences(Stream.of(metricReferences).map(c -> (MetricReference)((MetricReference.Builder)MetricReference.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ServiceSummary build() {
            return new ServiceSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceSummary> {
        public Builder keyAttributes(Map<String, String> var1);

        public Builder attributeMaps(Collection<? extends Map<String, String>> var1);

        public Builder attributeMaps(Map<String, String> ... var1);

        public Builder metricReferences(Collection<MetricReference> var1);

        public Builder metricReferences(MetricReference ... var1);

        public Builder metricReferences(Consumer<MetricReference.Builder> ... var1);
    }
}

