/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.applicationsignals.model.AttributesCopier;
import software.amazon.awssdk.services.applicationsignals.model.DependencyConfig;
import software.amazon.awssdk.services.applicationsignals.model.EvaluationType;
import software.amazon.awssdk.services.applicationsignals.model.MetricSourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceLevelObjectiveSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceLevelObjectiveSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(ServiceLevelObjectiveSummary.getter(ServiceLevelObjectiveSummary::arn)).setter(ServiceLevelObjectiveSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ServiceLevelObjectiveSummary.getter(ServiceLevelObjectiveSummary::name)).setter(ServiceLevelObjectiveSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Map<String, String>> KEY_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("KeyAttributes").getter(ServiceLevelObjectiveSummary.getter(ServiceLevelObjectiveSummary::keyAttributes)).setter(ServiceLevelObjectiveSummary.setter(Builder::keyAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> OPERATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperationName").getter(ServiceLevelObjectiveSummary.getter(ServiceLevelObjectiveSummary::operationName)).setter(ServiceLevelObjectiveSummary.setter(Builder::operationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationName").build()}).build();
    private static final SdkField<DependencyConfig> DEPENDENCY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DependencyConfig").getter(ServiceLevelObjectiveSummary.getter(ServiceLevelObjectiveSummary::dependencyConfig)).setter(ServiceLevelObjectiveSummary.setter(Builder::dependencyConfig)).constructor(DependencyConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DependencyConfig").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(ServiceLevelObjectiveSummary.getter(ServiceLevelObjectiveSummary::createdTime)).setter(ServiceLevelObjectiveSummary.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<String> EVALUATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluationType").getter(ServiceLevelObjectiveSummary.getter(ServiceLevelObjectiveSummary::evaluationTypeAsString)).setter(ServiceLevelObjectiveSummary.setter(Builder::evaluationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationType").build()}).build();
    private static final SdkField<String> METRIC_SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricSourceType").getter(ServiceLevelObjectiveSummary.getter(ServiceLevelObjectiveSummary::metricSourceTypeAsString)).setter(ServiceLevelObjectiveSummary.setter(Builder::metricSourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricSourceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, KEY_ATTRIBUTES_FIELD, OPERATION_NAME_FIELD, DEPENDENCY_CONFIG_FIELD, CREATED_TIME_FIELD, EVALUATION_TYPE_FIELD, METRIC_SOURCE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServiceLevelObjectiveSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String name;
    private final Map<String, String> keyAttributes;
    private final String operationName;
    private final DependencyConfig dependencyConfig;
    private final Instant createdTime;
    private final String evaluationType;
    private final String metricSourceType;

    private ServiceLevelObjectiveSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.keyAttributes = builder.keyAttributes;
        this.operationName = builder.operationName;
        this.dependencyConfig = builder.dependencyConfig;
        this.createdTime = builder.createdTime;
        this.evaluationType = builder.evaluationType;
        this.metricSourceType = builder.metricSourceType;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasKeyAttributes() {
        return this.keyAttributes != null && !(this.keyAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> keyAttributes() {
        return this.keyAttributes;
    }

    public final String operationName() {
        return this.operationName;
    }

    public final DependencyConfig dependencyConfig() {
        return this.dependencyConfig;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final EvaluationType evaluationType() {
        return EvaluationType.fromValue(this.evaluationType);
    }

    public final String evaluationTypeAsString() {
        return this.evaluationType;
    }

    public final MetricSourceType metricSourceType() {
        return MetricSourceType.fromValue(this.metricSourceType);
    }

    public final String metricSourceTypeAsString() {
        return this.metricSourceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKeyAttributes() ? this.keyAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.operationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dependencyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricSourceTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceLevelObjectiveSummary)) {
            return false;
        }
        ServiceLevelObjectiveSummary other = (ServiceLevelObjectiveSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && this.hasKeyAttributes() == other.hasKeyAttributes() && Objects.equals(this.keyAttributes(), other.keyAttributes()) && Objects.equals(this.operationName(), other.operationName()) && Objects.equals(this.dependencyConfig(), other.dependencyConfig()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.evaluationTypeAsString(), other.evaluationTypeAsString()) && Objects.equals(this.metricSourceTypeAsString(), other.metricSourceTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceLevelObjectiveSummary").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("KeyAttributes", this.hasKeyAttributes() ? this.keyAttributes() : null).add("OperationName", (Object)this.operationName()).add("DependencyConfig", (Object)this.dependencyConfig()).add("CreatedTime", (Object)this.createdTime()).add("EvaluationType", (Object)this.evaluationTypeAsString()).add("MetricSourceType", (Object)this.metricSourceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "KeyAttributes": {
                return Optional.ofNullable(clazz.cast(this.keyAttributes()));
            }
            case "OperationName": {
                return Optional.ofNullable(clazz.cast(this.operationName()));
            }
            case "DependencyConfig": {
                return Optional.ofNullable(clazz.cast(this.dependencyConfig()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "EvaluationType": {
                return Optional.ofNullable(clazz.cast(this.evaluationTypeAsString()));
            }
            case "MetricSourceType": {
                return Optional.ofNullable(clazz.cast(this.metricSourceTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("KeyAttributes", KEY_ATTRIBUTES_FIELD);
        map.put("OperationName", OPERATION_NAME_FIELD);
        map.put("DependencyConfig", DEPENDENCY_CONFIG_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("EvaluationType", EVALUATION_TYPE_FIELD);
        map.put("MetricSourceType", METRIC_SOURCE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceLevelObjectiveSummary, T> g) {
        return obj -> g.apply((ServiceLevelObjectiveSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private Map<String, String> keyAttributes = DefaultSdkAutoConstructMap.getInstance();
        private String operationName;
        private DependencyConfig dependencyConfig;
        private Instant createdTime;
        private String evaluationType;
        private String metricSourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceLevelObjectiveSummary model) {
            this.arn(model.arn);
            this.name(model.name);
            this.keyAttributes(model.keyAttributes);
            this.operationName(model.operationName);
            this.dependencyConfig(model.dependencyConfig);
            this.createdTime(model.createdTime);
            this.evaluationType(model.evaluationType);
            this.metricSourceType(model.metricSourceType);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, String> getKeyAttributes() {
            if (this.keyAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.keyAttributes;
        }

        public final void setKeyAttributes(Map<String, String> keyAttributes) {
            this.keyAttributes = AttributesCopier.copy(keyAttributes);
        }

        @Override
        public final Builder keyAttributes(Map<String, String> keyAttributes) {
            this.keyAttributes = AttributesCopier.copy(keyAttributes);
            return this;
        }

        public final String getOperationName() {
            return this.operationName;
        }

        public final void setOperationName(String operationName) {
            this.operationName = operationName;
        }

        @Override
        public final Builder operationName(String operationName) {
            this.operationName = operationName;
            return this;
        }

        public final DependencyConfig.Builder getDependencyConfig() {
            return this.dependencyConfig != null ? this.dependencyConfig.toBuilder() : null;
        }

        public final void setDependencyConfig(DependencyConfig.BuilderImpl dependencyConfig) {
            this.dependencyConfig = dependencyConfig != null ? dependencyConfig.build() : null;
        }

        @Override
        public final Builder dependencyConfig(DependencyConfig dependencyConfig) {
            this.dependencyConfig = dependencyConfig;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getEvaluationType() {
            return this.evaluationType;
        }

        public final void setEvaluationType(String evaluationType) {
            this.evaluationType = evaluationType;
        }

        @Override
        public final Builder evaluationType(String evaluationType) {
            this.evaluationType = evaluationType;
            return this;
        }

        @Override
        public final Builder evaluationType(EvaluationType evaluationType) {
            this.evaluationType(evaluationType == null ? null : evaluationType.toString());
            return this;
        }

        public final String getMetricSourceType() {
            return this.metricSourceType;
        }

        public final void setMetricSourceType(String metricSourceType) {
            this.metricSourceType = metricSourceType;
        }

        @Override
        public final Builder metricSourceType(String metricSourceType) {
            this.metricSourceType = metricSourceType;
            return this;
        }

        @Override
        public final Builder metricSourceType(MetricSourceType metricSourceType) {
            this.metricSourceType(metricSourceType == null ? null : metricSourceType.toString());
            return this;
        }

        public ServiceLevelObjectiveSummary build() {
            return new ServiceLevelObjectiveSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceLevelObjectiveSummary> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder keyAttributes(Map<String, String> var1);

        public Builder operationName(String var1);

        public Builder dependencyConfig(DependencyConfig var1);

        default public Builder dependencyConfig(Consumer<DependencyConfig.Builder> dependencyConfig) {
            return this.dependencyConfig((DependencyConfig)((DependencyConfig.Builder)DependencyConfig.builder().applyMutation(dependencyConfig)).build());
        }

        public Builder createdTime(Instant var1);

        public Builder evaluationType(String var1);

        public Builder evaluationType(EvaluationType var1);

        public Builder metricSourceType(String var1);

        public Builder metricSourceType(MetricSourceType var1);
    }
}

