/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.applicationsignals.model.AttributesCopier;
import software.amazon.awssdk.services.applicationsignals.model.MetricReference;
import software.amazon.awssdk.services.applicationsignals.model.MetricReferencesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceDependent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceDependent> {
    private static final SdkField<String> OPERATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperationName").getter(ServiceDependent.getter(ServiceDependent::operationName)).setter(ServiceDependent.setter(Builder::operationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationName").build()}).build();
    private static final SdkField<Map<String, String>> DEPENDENT_KEY_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("DependentKeyAttributes").getter(ServiceDependent.getter(ServiceDependent::dependentKeyAttributes)).setter(ServiceDependent.setter(Builder::dependentKeyAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DependentKeyAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> DEPENDENT_OPERATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DependentOperationName").getter(ServiceDependent.getter(ServiceDependent::dependentOperationName)).setter(ServiceDependent.setter(Builder::dependentOperationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DependentOperationName").build()}).build();
    private static final SdkField<List<MetricReference>> METRIC_REFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricReferences").getter(ServiceDependent.getter(ServiceDependent::metricReferences)).setter(ServiceDependent.setter(Builder::metricReferences)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricReferences").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATION_NAME_FIELD, DEPENDENT_KEY_ATTRIBUTES_FIELD, DEPENDENT_OPERATION_NAME_FIELD, METRIC_REFERENCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServiceDependent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String operationName;
    private final Map<String, String> dependentKeyAttributes;
    private final String dependentOperationName;
    private final List<MetricReference> metricReferences;

    private ServiceDependent(BuilderImpl builder) {
        this.operationName = builder.operationName;
        this.dependentKeyAttributes = builder.dependentKeyAttributes;
        this.dependentOperationName = builder.dependentOperationName;
        this.metricReferences = builder.metricReferences;
    }

    public final String operationName() {
        return this.operationName;
    }

    public final boolean hasDependentKeyAttributes() {
        return this.dependentKeyAttributes != null && !(this.dependentKeyAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> dependentKeyAttributes() {
        return this.dependentKeyAttributes;
    }

    public final String dependentOperationName() {
        return this.dependentOperationName;
    }

    public final boolean hasMetricReferences() {
        return this.metricReferences != null && !(this.metricReferences instanceof SdkAutoConstructList);
    }

    public final List<MetricReference> metricReferences() {
        return this.metricReferences;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.operationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDependentKeyAttributes() ? this.dependentKeyAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dependentOperationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricReferences() ? this.metricReferences() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceDependent)) {
            return false;
        }
        ServiceDependent other = (ServiceDependent)obj;
        return Objects.equals(this.operationName(), other.operationName()) && this.hasDependentKeyAttributes() == other.hasDependentKeyAttributes() && Objects.equals(this.dependentKeyAttributes(), other.dependentKeyAttributes()) && Objects.equals(this.dependentOperationName(), other.dependentOperationName()) && this.hasMetricReferences() == other.hasMetricReferences() && Objects.equals(this.metricReferences(), other.metricReferences());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceDependent").add("OperationName", (Object)this.operationName()).add("DependentKeyAttributes", this.hasDependentKeyAttributes() ? this.dependentKeyAttributes() : null).add("DependentOperationName", (Object)this.dependentOperationName()).add("MetricReferences", this.hasMetricReferences() ? this.metricReferences() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OperationName": {
                return Optional.ofNullable(clazz.cast(this.operationName()));
            }
            case "DependentKeyAttributes": {
                return Optional.ofNullable(clazz.cast(this.dependentKeyAttributes()));
            }
            case "DependentOperationName": {
                return Optional.ofNullable(clazz.cast(this.dependentOperationName()));
            }
            case "MetricReferences": {
                return Optional.ofNullable(clazz.cast(this.metricReferences()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OperationName", OPERATION_NAME_FIELD);
        map.put("DependentKeyAttributes", DEPENDENT_KEY_ATTRIBUTES_FIELD);
        map.put("DependentOperationName", DEPENDENT_OPERATION_NAME_FIELD);
        map.put("MetricReferences", METRIC_REFERENCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceDependent, T> g) {
        return obj -> g.apply((ServiceDependent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String operationName;
        private Map<String, String> dependentKeyAttributes = DefaultSdkAutoConstructMap.getInstance();
        private String dependentOperationName;
        private List<MetricReference> metricReferences = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceDependent model) {
            this.operationName(model.operationName);
            this.dependentKeyAttributes(model.dependentKeyAttributes);
            this.dependentOperationName(model.dependentOperationName);
            this.metricReferences(model.metricReferences);
        }

        public final String getOperationName() {
            return this.operationName;
        }

        public final void setOperationName(String operationName) {
            this.operationName = operationName;
        }

        @Override
        public final Builder operationName(String operationName) {
            this.operationName = operationName;
            return this;
        }

        public final Map<String, String> getDependentKeyAttributes() {
            if (this.dependentKeyAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.dependentKeyAttributes;
        }

        public final void setDependentKeyAttributes(Map<String, String> dependentKeyAttributes) {
            this.dependentKeyAttributes = AttributesCopier.copy(dependentKeyAttributes);
        }

        @Override
        public final Builder dependentKeyAttributes(Map<String, String> dependentKeyAttributes) {
            this.dependentKeyAttributes = AttributesCopier.copy(dependentKeyAttributes);
            return this;
        }

        public final String getDependentOperationName() {
            return this.dependentOperationName;
        }

        public final void setDependentOperationName(String dependentOperationName) {
            this.dependentOperationName = dependentOperationName;
        }

        @Override
        public final Builder dependentOperationName(String dependentOperationName) {
            this.dependentOperationName = dependentOperationName;
            return this;
        }

        public final List<MetricReference.Builder> getMetricReferences() {
            List<MetricReference.Builder> result = MetricReferencesCopier.copyToBuilder(this.metricReferences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricReferences(Collection<MetricReference.BuilderImpl> metricReferences) {
            this.metricReferences = MetricReferencesCopier.copyFromBuilder(metricReferences);
        }

        @Override
        public final Builder metricReferences(Collection<MetricReference> metricReferences) {
            this.metricReferences = MetricReferencesCopier.copy(metricReferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricReferences(MetricReference ... metricReferences) {
            this.metricReferences(Arrays.asList(metricReferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricReferences(Consumer<MetricReference.Builder> ... metricReferences) {
            this.metricReferences(Stream.of(metricReferences).map(c -> (MetricReference)((MetricReference.Builder)MetricReference.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ServiceDependent build() {
            return new ServiceDependent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceDependent> {
        public Builder operationName(String var1);

        public Builder dependentKeyAttributes(Map<String, String> var1);

        public Builder dependentOperationName(String var1);

        public Builder metricReferences(Collection<MetricReference> var1);

        public Builder metricReferences(MetricReference ... var1);

        public Builder metricReferences(Consumer<MetricReference.Builder> ... var1);
    }
}

