/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MetricSourceType {
    SERVICE_OPERATION("ServiceOperation"),
    CLOUD_WATCH_METRIC("CloudWatchMetric"),
    SERVICE_DEPENDENCY("ServiceDependency"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MetricSourceType> VALUE_MAP;
    private final String value;

    private MetricSourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MetricSourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MetricSourceType> knownValues() {
        EnumSet<MetricSourceType> knownValues = EnumSet.allOf(MetricSourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MetricSourceType.class, MetricSourceType::toString);
    }
}

