/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationinsights.model.ApplicationComponent;
import software.amazon.awssdk.services.applicationinsights.model.ApplicationInsightsResponse;
import software.amazon.awssdk.services.applicationinsights.model.ResourceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeComponentResponse
extends ApplicationInsightsResponse
implements ToCopyableBuilder<Builder, DescribeComponentResponse> {
    private static final SdkField<ApplicationComponent> APPLICATION_COMPONENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApplicationComponent").getter(DescribeComponentResponse.getter(DescribeComponentResponse::applicationComponent)).setter(DescribeComponentResponse.setter(Builder::applicationComponent)).constructor(ApplicationComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationComponent").build()}).build();
    private static final SdkField<List<String>> RESOURCE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceList").getter(DescribeComponentResponse.getter(DescribeComponentResponse::resourceList)).setter(DescribeComponentResponse.setter(Builder::resourceList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_COMPONENT_FIELD, RESOURCE_LIST_FIELD));
    private final ApplicationComponent applicationComponent;
    private final List<String> resourceList;

    private DescribeComponentResponse(BuilderImpl builder) {
        super(builder);
        this.applicationComponent = builder.applicationComponent;
        this.resourceList = builder.resourceList;
    }

    public final ApplicationComponent applicationComponent() {
        return this.applicationComponent;
    }

    public final boolean hasResourceList() {
        return this.resourceList != null && !(this.resourceList instanceof SdkAutoConstructList);
    }

    public final List<String> resourceList() {
        return this.resourceList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationComponent());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceList() ? this.resourceList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeComponentResponse)) {
            return false;
        }
        DescribeComponentResponse other = (DescribeComponentResponse)((Object)obj);
        return Objects.equals(this.applicationComponent(), other.applicationComponent()) && this.hasResourceList() == other.hasResourceList() && Objects.equals(this.resourceList(), other.resourceList());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeComponentResponse").add("ApplicationComponent", (Object)this.applicationComponent()).add("ResourceList", this.hasResourceList() ? this.resourceList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationComponent": {
                return Optional.ofNullable(clazz.cast(this.applicationComponent()));
            }
            case "ResourceList": {
                return Optional.ofNullable(clazz.cast(this.resourceList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeComponentResponse, T> g) {
        return obj -> g.apply((DescribeComponentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationInsightsResponse.BuilderImpl
    implements Builder {
        private ApplicationComponent applicationComponent;
        private List<String> resourceList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeComponentResponse model) {
            super(model);
            this.applicationComponent(model.applicationComponent);
            this.resourceList(model.resourceList);
        }

        public final ApplicationComponent.Builder getApplicationComponent() {
            return this.applicationComponent != null ? this.applicationComponent.toBuilder() : null;
        }

        public final void setApplicationComponent(ApplicationComponent.BuilderImpl applicationComponent) {
            this.applicationComponent = applicationComponent != null ? applicationComponent.build() : null;
        }

        @Override
        public final Builder applicationComponent(ApplicationComponent applicationComponent) {
            this.applicationComponent = applicationComponent;
            return this;
        }

        public final Collection<String> getResourceList() {
            if (this.resourceList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceList;
        }

        public final void setResourceList(Collection<String> resourceList) {
            this.resourceList = ResourceListCopier.copy(resourceList);
        }

        @Override
        public final Builder resourceList(Collection<String> resourceList) {
            this.resourceList = ResourceListCopier.copy(resourceList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceList(String ... resourceList) {
            this.resourceList(Arrays.asList(resourceList));
            return this;
        }

        @Override
        public DescribeComponentResponse build() {
            return new DescribeComponentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApplicationInsightsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeComponentResponse> {
        public Builder applicationComponent(ApplicationComponent var1);

        default public Builder applicationComponent(Consumer<ApplicationComponent.Builder> applicationComponent) {
            return this.applicationComponent((ApplicationComponent)((ApplicationComponent.Builder)ApplicationComponent.builder().applyMutation(applicationComponent)).build());
        }

        public Builder resourceList(Collection<String> var1);

        public Builder resourceList(String ... var1);
    }
}

