/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.applicationinsights.ApplicationInsightsAsyncClient;
import software.amazon.awssdk.services.applicationinsights.internal.UserAgentUtils;
import software.amazon.awssdk.services.applicationinsights.model.ListComponentsRequest;
import software.amazon.awssdk.services.applicationinsights.model.ListComponentsResponse;

public class ListComponentsPublisher
implements SdkPublisher<ListComponentsResponse> {
    private final ApplicationInsightsAsyncClient client;
    private final ListComponentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListComponentsPublisher(ApplicationInsightsAsyncClient client, ListComponentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListComponentsPublisher(ApplicationInsightsAsyncClient client, ListComponentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListComponentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListComponentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListComponentsResponseFetcher
    implements AsyncPageFetcher<ListComponentsResponse> {
        private ListComponentsResponseFetcher() {
        }

        public boolean hasNextPage(ListComponentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListComponentsResponse> nextPage(ListComponentsResponse previousPage) {
            if (previousPage == null) {
                return ListComponentsPublisher.this.client.listComponents(ListComponentsPublisher.this.firstRequest);
            }
            return ListComponentsPublisher.this.client.listComponents((ListComponentsRequest)((Object)ListComponentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

