/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationinsights.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that defines the log patterns that belongs to a <code>LogPatternSet</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LogPattern implements SdkPojo, Serializable, ToCopyableBuilder<LogPattern.Builder, LogPattern> {
    private static final SdkField<String> PATTERN_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LogPattern::patternSetName)).setter(setter(Builder::patternSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatternSetName").build()).build();

    private static final SdkField<String> PATTERN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LogPattern::patternName)).setter(setter(Builder::patternName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatternName").build()).build();

    private static final SdkField<String> PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LogPattern::pattern)).setter(setter(Builder::pattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pattern").build()).build();

    private static final SdkField<Integer> RANK_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(LogPattern::rank)).setter(setter(Builder::rank))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rank").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATTERN_SET_NAME_FIELD,
            PATTERN_NAME_FIELD, PATTERN_FIELD, RANK_FIELD));

    private static final long serialVersionUID = 1L;

    private final String patternSetName;

    private final String patternName;

    private final String pattern;

    private final Integer rank;

    private LogPattern(BuilderImpl builder) {
        this.patternSetName = builder.patternSetName;
        this.patternName = builder.patternName;
        this.pattern = builder.pattern;
        this.rank = builder.rank;
    }

    /**
     * <p>
     * The name of the log pattern. A log pattern name can contains at many as 30 characters, and it cannot be empty.
     * The characters can be Unicode letters, digits or one of the following symbols: period, dash, underscore.
     * </p>
     * 
     * @return The name of the log pattern. A log pattern name can contains at many as 30 characters, and it cannot be
     *         empty. The characters can be Unicode letters, digits or one of the following symbols: period, dash,
     *         underscore.
     */
    public String patternSetName() {
        return patternSetName;
    }

    /**
     * <p>
     * The name of the log pattern. A log pattern name can contains at many as 50 characters, and it cannot be empty.
     * The characters can be Unicode letters, digits or one of the following symbols: period, dash, underscore.
     * </p>
     * 
     * @return The name of the log pattern. A log pattern name can contains at many as 50 characters, and it cannot be
     *         empty. The characters can be Unicode letters, digits or one of the following symbols: period, dash,
     *         underscore.
     */
    public String patternName() {
        return patternName;
    }

    /**
     * <p>
     * A regular expression that defines the log pattern. A log pattern can contains at many as 50 characters, and it
     * cannot be empty.
     * </p>
     * 
     * @return A regular expression that defines the log pattern. A log pattern can contains at many as 50 characters,
     *         and it cannot be empty.
     */
    public String pattern() {
        return pattern;
    }

    /**
     * <p>
     * Rank of the log pattern.
     * </p>
     * 
     * @return Rank of the log pattern.
     */
    public Integer rank() {
        return rank;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(patternSetName());
        hashCode = 31 * hashCode + Objects.hashCode(patternName());
        hashCode = 31 * hashCode + Objects.hashCode(pattern());
        hashCode = 31 * hashCode + Objects.hashCode(rank());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogPattern)) {
            return false;
        }
        LogPattern other = (LogPattern) obj;
        return Objects.equals(patternSetName(), other.patternSetName()) && Objects.equals(patternName(), other.patternName())
                && Objects.equals(pattern(), other.pattern()) && Objects.equals(rank(), other.rank());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LogPattern").add("PatternSetName", patternSetName()).add("PatternName", patternName())
                .add("Pattern", pattern()).add("Rank", rank()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PatternSetName":
            return Optional.ofNullable(clazz.cast(patternSetName()));
        case "PatternName":
            return Optional.ofNullable(clazz.cast(patternName()));
        case "Pattern":
            return Optional.ofNullable(clazz.cast(pattern()));
        case "Rank":
            return Optional.ofNullable(clazz.cast(rank()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LogPattern, T> g) {
        return obj -> g.apply((LogPattern) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LogPattern> {
        /**
         * <p>
         * The name of the log pattern. A log pattern name can contains at many as 30 characters, and it cannot be
         * empty. The characters can be Unicode letters, digits or one of the following symbols: period, dash,
         * underscore.
         * </p>
         * 
         * @param patternSetName
         *        The name of the log pattern. A log pattern name can contains at many as 30 characters, and it cannot
         *        be empty. The characters can be Unicode letters, digits or one of the following symbols: period, dash,
         *        underscore.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patternSetName(String patternSetName);

        /**
         * <p>
         * The name of the log pattern. A log pattern name can contains at many as 50 characters, and it cannot be
         * empty. The characters can be Unicode letters, digits or one of the following symbols: period, dash,
         * underscore.
         * </p>
         * 
         * @param patternName
         *        The name of the log pattern. A log pattern name can contains at many as 50 characters, and it cannot
         *        be empty. The characters can be Unicode letters, digits or one of the following symbols: period, dash,
         *        underscore.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patternName(String patternName);

        /**
         * <p>
         * A regular expression that defines the log pattern. A log pattern can contains at many as 50 characters, and
         * it cannot be empty.
         * </p>
         * 
         * @param pattern
         *        A regular expression that defines the log pattern. A log pattern can contains at many as 50
         *        characters, and it cannot be empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pattern(String pattern);

        /**
         * <p>
         * Rank of the log pattern.
         * </p>
         * 
         * @param rank
         *        Rank of the log pattern.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rank(Integer rank);
    }

    static final class BuilderImpl implements Builder {
        private String patternSetName;

        private String patternName;

        private String pattern;

        private Integer rank;

        private BuilderImpl() {
        }

        private BuilderImpl(LogPattern model) {
            patternSetName(model.patternSetName);
            patternName(model.patternName);
            pattern(model.pattern);
            rank(model.rank);
        }

        public final String getPatternSetName() {
            return patternSetName;
        }

        @Override
        public final Builder patternSetName(String patternSetName) {
            this.patternSetName = patternSetName;
            return this;
        }

        public final void setPatternSetName(String patternSetName) {
            this.patternSetName = patternSetName;
        }

        public final String getPatternName() {
            return patternName;
        }

        @Override
        public final Builder patternName(String patternName) {
            this.patternName = patternName;
            return this;
        }

        public final void setPatternName(String patternName) {
            this.patternName = patternName;
        }

        public final String getPattern() {
            return pattern;
        }

        @Override
        public final Builder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public final void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public final Integer getRank() {
            return rank;
        }

        @Override
        public final Builder rank(Integer rank) {
            this.rank = rank;
            return this;
        }

        public final void setRank(Integer rank) {
            this.rank = rank;
        }

        @Override
        public LogPattern build() {
            return new LogPattern(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
