/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLogPatternRequest extends ApplicationInsightsRequest implements
        ToCopyableBuilder<DescribeLogPatternRequest.Builder, DescribeLogPatternRequest> {
    private static final SdkField<String> RESOURCE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeLogPatternRequest::resourceGroupName)).setter(setter(Builder::resourceGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceGroupName").build()).build();

    private static final SdkField<String> PATTERN_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeLogPatternRequest::patternSetName)).setter(setter(Builder::patternSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatternSetName").build()).build();

    private static final SdkField<String> PATTERN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeLogPatternRequest::patternName)).setter(setter(Builder::patternName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatternName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_GROUP_NAME_FIELD,
            PATTERN_SET_NAME_FIELD, PATTERN_NAME_FIELD));

    private final String resourceGroupName;

    private final String patternSetName;

    private final String patternName;

    private DescribeLogPatternRequest(BuilderImpl builder) {
        super(builder);
        this.resourceGroupName = builder.resourceGroupName;
        this.patternSetName = builder.patternSetName;
        this.patternName = builder.patternName;
    }

    /**
     * <p>
     * The name of the resource group.
     * </p>
     * 
     * @return The name of the resource group.
     */
    public String resourceGroupName() {
        return resourceGroupName;
    }

    /**
     * <p>
     * The name of the log pattern set.
     * </p>
     * 
     * @return The name of the log pattern set.
     */
    public String patternSetName() {
        return patternSetName;
    }

    /**
     * <p>
     * The name of the log pattern.
     * </p>
     * 
     * @return The name of the log pattern.
     */
    public String patternName() {
        return patternName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(patternSetName());
        hashCode = 31 * hashCode + Objects.hashCode(patternName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLogPatternRequest)) {
            return false;
        }
        DescribeLogPatternRequest other = (DescribeLogPatternRequest) obj;
        return Objects.equals(resourceGroupName(), other.resourceGroupName())
                && Objects.equals(patternSetName(), other.patternSetName()) && Objects.equals(patternName(), other.patternName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeLogPatternRequest").add("ResourceGroupName", resourceGroupName())
                .add("PatternSetName", patternSetName()).add("PatternName", patternName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceGroupName":
            return Optional.ofNullable(clazz.cast(resourceGroupName()));
        case "PatternSetName":
            return Optional.ofNullable(clazz.cast(patternSetName()));
        case "PatternName":
            return Optional.ofNullable(clazz.cast(patternName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLogPatternRequest, T> g) {
        return obj -> g.apply((DescribeLogPatternRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationInsightsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeLogPatternRequest> {
        /**
         * <p>
         * The name of the resource group.
         * </p>
         * 
         * @param resourceGroupName
         *        The name of the resource group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceGroupName(String resourceGroupName);

        /**
         * <p>
         * The name of the log pattern set.
         * </p>
         * 
         * @param patternSetName
         *        The name of the log pattern set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patternSetName(String patternSetName);

        /**
         * <p>
         * The name of the log pattern.
         * </p>
         * 
         * @param patternName
         *        The name of the log pattern.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patternName(String patternName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApplicationInsightsRequest.BuilderImpl implements Builder {
        private String resourceGroupName;

        private String patternSetName;

        private String patternName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLogPatternRequest model) {
            super(model);
            resourceGroupName(model.resourceGroupName);
            patternSetName(model.patternSetName);
            patternName(model.patternName);
        }

        public final String getResourceGroupName() {
            return resourceGroupName;
        }

        @Override
        public final Builder resourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
            return this;
        }

        public final void setResourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
        }

        public final String getPatternSetName() {
            return patternSetName;
        }

        @Override
        public final Builder patternSetName(String patternSetName) {
            this.patternSetName = patternSetName;
            return this;
        }

        public final void setPatternSetName(String patternSetName) {
            this.patternSetName = patternSetName;
        }

        public final String getPatternName() {
            return patternName;
        }

        @Override
        public final Builder patternName(String patternName) {
            this.patternName = patternName;
            return this;
        }

        public final void setPatternName(String patternName) {
            this.patternName = patternName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeLogPatternRequest build() {
            return new DescribeLogPatternRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
