/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeComponentResponse extends ApplicationInsightsResponse implements
        ToCopyableBuilder<DescribeComponentResponse.Builder, DescribeComponentResponse> {
    private static final SdkField<ApplicationComponent> APPLICATION_COMPONENT_FIELD = SdkField
            .<ApplicationComponent> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeComponentResponse::applicationComponent)).setter(setter(Builder::applicationComponent))
            .constructor(ApplicationComponent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationComponent").build())
            .build();

    private static final SdkField<List<String>> RESOURCE_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeComponentResponse::resourceList))
            .setter(setter(Builder::resourceList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_COMPONENT_FIELD,
            RESOURCE_LIST_FIELD));

    private final ApplicationComponent applicationComponent;

    private final List<String> resourceList;

    private DescribeComponentResponse(BuilderImpl builder) {
        super(builder);
        this.applicationComponent = builder.applicationComponent;
        this.resourceList = builder.resourceList;
    }

    /**
     * Returns the value of the ApplicationComponent property for this object.
     * 
     * @return The value of the ApplicationComponent property for this object.
     */
    public ApplicationComponent applicationComponent() {
        return applicationComponent;
    }

    /**
     * Returns true if the ResourceList property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasResourceList() {
        return resourceList != null && !(resourceList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of resource ARNs that belong to the component.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of resource ARNs that belong to the component.
     */
    public List<String> resourceList() {
        return resourceList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationComponent());
        hashCode = 31 * hashCode + Objects.hashCode(resourceList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeComponentResponse)) {
            return false;
        }
        DescribeComponentResponse other = (DescribeComponentResponse) obj;
        return Objects.equals(applicationComponent(), other.applicationComponent())
                && Objects.equals(resourceList(), other.resourceList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeComponentResponse").add("ApplicationComponent", applicationComponent())
                .add("ResourceList", resourceList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationComponent":
            return Optional.ofNullable(clazz.cast(applicationComponent()));
        case "ResourceList":
            return Optional.ofNullable(clazz.cast(resourceList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeComponentResponse, T> g) {
        return obj -> g.apply((DescribeComponentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationInsightsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeComponentResponse> {
        /**
         * Sets the value of the ApplicationComponent property for this object.
         *
         * @param applicationComponent
         *        The new value for the ApplicationComponent property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationComponent(ApplicationComponent applicationComponent);

        /**
         * Sets the value of the ApplicationComponent property for this object.
         *
         * This is a convenience that creates an instance of the {@link ApplicationComponent.Builder} avoiding the need
         * to create one manually via {@link ApplicationComponent#builder()}.
         *
         * When the {@link Consumer} completes, {@link ApplicationComponent.Builder#build()} is called immediately and
         * its result is passed to {@link #applicationComponent(ApplicationComponent)}.
         * 
         * @param applicationComponent
         *        a consumer that will call methods on {@link ApplicationComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationComponent(ApplicationComponent)
         */
        default Builder applicationComponent(Consumer<ApplicationComponent.Builder> applicationComponent) {
            return applicationComponent(ApplicationComponent.builder().applyMutation(applicationComponent).build());
        }

        /**
         * <p>
         * The list of resource ARNs that belong to the component.
         * </p>
         * 
         * @param resourceList
         *        The list of resource ARNs that belong to the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceList(Collection<String> resourceList);

        /**
         * <p>
         * The list of resource ARNs that belong to the component.
         * </p>
         * 
         * @param resourceList
         *        The list of resource ARNs that belong to the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceList(String... resourceList);
    }

    static final class BuilderImpl extends ApplicationInsightsResponse.BuilderImpl implements Builder {
        private ApplicationComponent applicationComponent;

        private List<String> resourceList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeComponentResponse model) {
            super(model);
            applicationComponent(model.applicationComponent);
            resourceList(model.resourceList);
        }

        public final ApplicationComponent.Builder getApplicationComponent() {
            return applicationComponent != null ? applicationComponent.toBuilder() : null;
        }

        @Override
        public final Builder applicationComponent(ApplicationComponent applicationComponent) {
            this.applicationComponent = applicationComponent;
            return this;
        }

        public final void setApplicationComponent(ApplicationComponent.BuilderImpl applicationComponent) {
            this.applicationComponent = applicationComponent != null ? applicationComponent.build() : null;
        }

        public final Collection<String> getResourceList() {
            return resourceList;
        }

        @Override
        public final Builder resourceList(Collection<String> resourceList) {
            this.resourceList = ResourceListCopier.copy(resourceList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceList(String... resourceList) {
            resourceList(Arrays.asList(resourceList));
            return this;
        }

        public final void setResourceList(Collection<String> resourceList) {
            this.resourceList = ResourceListCopier.copy(resourceList);
        }

        @Override
        public DescribeComponentResponse build() {
            return new DescribeComponentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
