/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeComponentConfigurationResponse extends ApplicationInsightsResponse implements
        ToCopyableBuilder<DescribeComponentConfigurationResponse.Builder, DescribeComponentConfigurationResponse> {
    private static final SdkField<Boolean> MONITOR_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(DescribeComponentConfigurationResponse::monitor)).setter(setter(Builder::monitor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Monitor").build()).build();

    private static final SdkField<String> TIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeComponentConfigurationResponse::tierAsString)).setter(setter(Builder::tier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tier").build()).build();

    private static final SdkField<String> COMPONENT_CONFIGURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeComponentConfigurationResponse::componentConfiguration))
            .setter(setter(Builder::componentConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITOR_FIELD, TIER_FIELD,
            COMPONENT_CONFIGURATION_FIELD));

    private final Boolean monitor;

    private final String tier;

    private final String componentConfiguration;

    private DescribeComponentConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.monitor = builder.monitor;
        this.tier = builder.tier;
        this.componentConfiguration = builder.componentConfiguration;
    }

    /**
     * <p>
     * Indicates whether the application component is monitored.
     * </p>
     * 
     * @return Indicates whether the application component is monitored.
     */
    public Boolean monitor() {
        return monitor;
    }

    /**
     * <p>
     * The tier of the application component. Supported tiers include <code>DOT_NET_CORE</code>,
     * <code>DOT_NET_WORKER</code>, <code>DOT_NET_WEB</code>, <code>SQL_SERVER</code>, and <code>DEFAULT</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tier} will return
     * {@link Tier#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tierAsString}.
     * </p>
     * 
     * @return The tier of the application component. Supported tiers include <code>DOT_NET_CORE</code>,
     *         <code>DOT_NET_WORKER</code>, <code>DOT_NET_WEB</code>, <code>SQL_SERVER</code>, and <code>DEFAULT</code>
     * @see Tier
     */
    public Tier tier() {
        return Tier.fromValue(tier);
    }

    /**
     * <p>
     * The tier of the application component. Supported tiers include <code>DOT_NET_CORE</code>,
     * <code>DOT_NET_WORKER</code>, <code>DOT_NET_WEB</code>, <code>SQL_SERVER</code>, and <code>DEFAULT</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tier} will return
     * {@link Tier#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tierAsString}.
     * </p>
     * 
     * @return The tier of the application component. Supported tiers include <code>DOT_NET_CORE</code>,
     *         <code>DOT_NET_WORKER</code>, <code>DOT_NET_WEB</code>, <code>SQL_SERVER</code>, and <code>DEFAULT</code>
     * @see Tier
     */
    public String tierAsString() {
        return tier;
    }

    /**
     * <p>
     * The configuration settings of the component. The value is the escaped JSON of the configuration.
     * </p>
     * 
     * @return The configuration settings of the component. The value is the escaped JSON of the configuration.
     */
    public String componentConfiguration() {
        return componentConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(monitor());
        hashCode = 31 * hashCode + Objects.hashCode(tierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(componentConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeComponentConfigurationResponse)) {
            return false;
        }
        DescribeComponentConfigurationResponse other = (DescribeComponentConfigurationResponse) obj;
        return Objects.equals(monitor(), other.monitor()) && Objects.equals(tierAsString(), other.tierAsString())
                && Objects.equals(componentConfiguration(), other.componentConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeComponentConfigurationResponse").add("Monitor", monitor()).add("Tier", tierAsString())
                .add("ComponentConfiguration", componentConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Monitor":
            return Optional.ofNullable(clazz.cast(monitor()));
        case "Tier":
            return Optional.ofNullable(clazz.cast(tierAsString()));
        case "ComponentConfiguration":
            return Optional.ofNullable(clazz.cast(componentConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeComponentConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeComponentConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationInsightsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeComponentConfigurationResponse> {
        /**
         * <p>
         * Indicates whether the application component is monitored.
         * </p>
         * 
         * @param monitor
         *        Indicates whether the application component is monitored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitor(Boolean monitor);

        /**
         * <p>
         * The tier of the application component. Supported tiers include <code>DOT_NET_CORE</code>,
         * <code>DOT_NET_WORKER</code>, <code>DOT_NET_WEB</code>, <code>SQL_SERVER</code>, and <code>DEFAULT</code>
         * </p>
         * 
         * @param tier
         *        The tier of the application component. Supported tiers include <code>DOT_NET_CORE</code>,
         *        <code>DOT_NET_WORKER</code>, <code>DOT_NET_WEB</code>, <code>SQL_SERVER</code>, and
         *        <code>DEFAULT</code>
         * @see Tier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tier
         */
        Builder tier(String tier);

        /**
         * <p>
         * The tier of the application component. Supported tiers include <code>DOT_NET_CORE</code>,
         * <code>DOT_NET_WORKER</code>, <code>DOT_NET_WEB</code>, <code>SQL_SERVER</code>, and <code>DEFAULT</code>
         * </p>
         * 
         * @param tier
         *        The tier of the application component. Supported tiers include <code>DOT_NET_CORE</code>,
         *        <code>DOT_NET_WORKER</code>, <code>DOT_NET_WEB</code>, <code>SQL_SERVER</code>, and
         *        <code>DEFAULT</code>
         * @see Tier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tier
         */
        Builder tier(Tier tier);

        /**
         * <p>
         * The configuration settings of the component. The value is the escaped JSON of the configuration.
         * </p>
         * 
         * @param componentConfiguration
         *        The configuration settings of the component. The value is the escaped JSON of the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentConfiguration(String componentConfiguration);
    }

    static final class BuilderImpl extends ApplicationInsightsResponse.BuilderImpl implements Builder {
        private Boolean monitor;

        private String tier;

        private String componentConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeComponentConfigurationResponse model) {
            super(model);
            monitor(model.monitor);
            tier(model.tier);
            componentConfiguration(model.componentConfiguration);
        }

        public final Boolean getMonitor() {
            return monitor;
        }

        @Override
        public final Builder monitor(Boolean monitor) {
            this.monitor = monitor;
            return this;
        }

        public final void setMonitor(Boolean monitor) {
            this.monitor = monitor;
        }

        public final String getTier() {
            return tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        @Override
        public final Builder tier(Tier tier) {
            this.tier(tier == null ? null : tier.toString());
            return this;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        public final String getComponentConfiguration() {
            return componentConfiguration;
        }

        @Override
        public final Builder componentConfiguration(String componentConfiguration) {
            this.componentConfiguration = componentConfiguration;
            return this;
        }

        public final void setComponentConfiguration(String componentConfiguration) {
            this.componentConfiguration = componentConfiguration;
        }

        @Override
        public DescribeComponentConfigurationResponse build() {
            return new DescribeComponentConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
