/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeComponentConfigurationRecommendationResponse extends ApplicationInsightsResponse
        implements
        ToCopyableBuilder<DescribeComponentConfigurationRecommendationResponse.Builder, DescribeComponentConfigurationRecommendationResponse> {
    private static final SdkField<String> COMPONENT_CONFIGURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeComponentConfigurationRecommendationResponse::componentConfiguration))
            .setter(setter(Builder::componentConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(COMPONENT_CONFIGURATION_FIELD));

    private final String componentConfiguration;

    private DescribeComponentConfigurationRecommendationResponse(BuilderImpl builder) {
        super(builder);
        this.componentConfiguration = builder.componentConfiguration;
    }

    /**
     * <p>
     * The recommended configuration settings of the component. The value is the escaped JSON of the configuration.
     * </p>
     * 
     * @return The recommended configuration settings of the component. The value is the escaped JSON of the
     *         configuration.
     */
    public String componentConfiguration() {
        return componentConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(componentConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeComponentConfigurationRecommendationResponse)) {
            return false;
        }
        DescribeComponentConfigurationRecommendationResponse other = (DescribeComponentConfigurationRecommendationResponse) obj;
        return Objects.equals(componentConfiguration(), other.componentConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeComponentConfigurationRecommendationResponse")
                .add("ComponentConfiguration", componentConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComponentConfiguration":
            return Optional.ofNullable(clazz.cast(componentConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeComponentConfigurationRecommendationResponse, T> g) {
        return obj -> g.apply((DescribeComponentConfigurationRecommendationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationInsightsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeComponentConfigurationRecommendationResponse> {
        /**
         * <p>
         * The recommended configuration settings of the component. The value is the escaped JSON of the configuration.
         * </p>
         * 
         * @param componentConfiguration
         *        The recommended configuration settings of the component. The value is the escaped JSON of the
         *        configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentConfiguration(String componentConfiguration);
    }

    static final class BuilderImpl extends ApplicationInsightsResponse.BuilderImpl implements Builder {
        private String componentConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeComponentConfigurationRecommendationResponse model) {
            super(model);
            componentConfiguration(model.componentConfiguration);
        }

        public final String getComponentConfiguration() {
            return componentConfiguration;
        }

        @Override
        public final Builder componentConfiguration(String componentConfiguration) {
            this.componentConfiguration = componentConfiguration;
            return this;
        }

        public final void setComponentConfiguration(String componentConfiguration) {
            this.componentConfiguration = componentConfiguration;
        }

        @Override
        public DescribeComponentConfigurationRecommendationResponse build() {
            return new DescribeComponentConfigurationRecommendationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
