/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLogPatternResponse extends ApplicationInsightsResponse implements
        ToCopyableBuilder<CreateLogPatternResponse.Builder, CreateLogPatternResponse> {
    private static final SdkField<LogPattern> LOG_PATTERN_FIELD = SdkField.<LogPattern> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateLogPatternResponse::logPattern)).setter(setter(Builder::logPattern))
            .constructor(LogPattern::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogPattern").build()).build();

    private static final SdkField<String> RESOURCE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateLogPatternResponse::resourceGroupName)).setter(setter(Builder::resourceGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceGroupName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_PATTERN_FIELD,
            RESOURCE_GROUP_NAME_FIELD));

    private final LogPattern logPattern;

    private final String resourceGroupName;

    private CreateLogPatternResponse(BuilderImpl builder) {
        super(builder);
        this.logPattern = builder.logPattern;
        this.resourceGroupName = builder.resourceGroupName;
    }

    /**
     * <p>
     * The successfully created log pattern.
     * </p>
     * 
     * @return The successfully created log pattern.
     */
    public LogPattern logPattern() {
        return logPattern;
    }

    /**
     * <p>
     * The name of the resource group.
     * </p>
     * 
     * @return The name of the resource group.
     */
    public String resourceGroupName() {
        return resourceGroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(logPattern());
        hashCode = 31 * hashCode + Objects.hashCode(resourceGroupName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLogPatternResponse)) {
            return false;
        }
        CreateLogPatternResponse other = (CreateLogPatternResponse) obj;
        return Objects.equals(logPattern(), other.logPattern()) && Objects.equals(resourceGroupName(), other.resourceGroupName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateLogPatternResponse").add("LogPattern", logPattern())
                .add("ResourceGroupName", resourceGroupName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LogPattern":
            return Optional.ofNullable(clazz.cast(logPattern()));
        case "ResourceGroupName":
            return Optional.ofNullable(clazz.cast(resourceGroupName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLogPatternResponse, T> g) {
        return obj -> g.apply((CreateLogPatternResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationInsightsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateLogPatternResponse> {
        /**
         * <p>
         * The successfully created log pattern.
         * </p>
         * 
         * @param logPattern
         *        The successfully created log pattern.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logPattern(LogPattern logPattern);

        /**
         * <p>
         * The successfully created log pattern.
         * </p>
         * This is a convenience that creates an instance of the {@link LogPattern.Builder} avoiding the need to create
         * one manually via {@link LogPattern#builder()}.
         *
         * When the {@link Consumer} completes, {@link LogPattern.Builder#build()} is called immediately and its result
         * is passed to {@link #logPattern(LogPattern)}.
         * 
         * @param logPattern
         *        a consumer that will call methods on {@link LogPattern.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logPattern(LogPattern)
         */
        default Builder logPattern(Consumer<LogPattern.Builder> logPattern) {
            return logPattern(LogPattern.builder().applyMutation(logPattern).build());
        }

        /**
         * <p>
         * The name of the resource group.
         * </p>
         * 
         * @param resourceGroupName
         *        The name of the resource group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceGroupName(String resourceGroupName);
    }

    static final class BuilderImpl extends ApplicationInsightsResponse.BuilderImpl implements Builder {
        private LogPattern logPattern;

        private String resourceGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLogPatternResponse model) {
            super(model);
            logPattern(model.logPattern);
            resourceGroupName(model.resourceGroupName);
        }

        public final LogPattern.Builder getLogPattern() {
            return logPattern != null ? logPattern.toBuilder() : null;
        }

        @Override
        public final Builder logPattern(LogPattern logPattern) {
            this.logPattern = logPattern;
            return this;
        }

        public final void setLogPattern(LogPattern.BuilderImpl logPattern) {
            this.logPattern = logPattern != null ? logPattern.build() : null;
        }

        public final String getResourceGroupName() {
            return resourceGroupName;
        }

        @Override
        public final Builder resourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
            return this;
        }

        public final void setResourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
        }

        @Override
        public CreateLogPatternResponse build() {
            return new CreateLogPatternResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
