/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationinsights.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a standalone resource or similarly grouped resources that the application is made up of.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationComponent implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationComponent.Builder, ApplicationComponent> {
    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ApplicationComponent::componentName)).setter(setter(Builder::componentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentName").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ApplicationComponent::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<String> TIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ApplicationComponent::tierAsString)).setter(setter(Builder::tier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tier").build()).build();

    private static final SdkField<Boolean> MONITOR_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ApplicationComponent::monitor)).setter(setter(Builder::monitor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Monitor").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_NAME_FIELD,
            RESOURCE_TYPE_FIELD, TIER_FIELD, MONITOR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String componentName;

    private final String resourceType;

    private final String tier;

    private final Boolean monitor;

    private ApplicationComponent(BuilderImpl builder) {
        this.componentName = builder.componentName;
        this.resourceType = builder.resourceType;
        this.tier = builder.tier;
        this.monitor = builder.monitor;
    }

    /**
     * <p>
     * The name of the component.
     * </p>
     * 
     * @return The name of the component.
     */
    public String componentName() {
        return componentName;
    }

    /**
     * <p>
     * The resource type. Supported resource types include EC2 instances, Auto Scaling group, Classic ELB, Application
     * ELB, and SQS Queue.
     * </p>
     * 
     * @return The resource type. Supported resource types include EC2 instances, Auto Scaling group, Classic ELB,
     *         Application ELB, and SQS Queue.
     */
    public String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The stack tier of the application component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tier} will return
     * {@link Tier#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tierAsString}.
     * </p>
     * 
     * @return The stack tier of the application component.
     * @see Tier
     */
    public Tier tier() {
        return Tier.fromValue(tier);
    }

    /**
     * <p>
     * The stack tier of the application component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tier} will return
     * {@link Tier#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tierAsString}.
     * </p>
     * 
     * @return The stack tier of the application component.
     * @see Tier
     */
    public String tierAsString() {
        return tier;
    }

    /**
     * <p>
     * Indicates whether the application component is monitored.
     * </p>
     * 
     * @return Indicates whether the application component is monitored.
     */
    public Boolean monitor() {
        return monitor;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(componentName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(tierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(monitor());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationComponent)) {
            return false;
        }
        ApplicationComponent other = (ApplicationComponent) obj;
        return Objects.equals(componentName(), other.componentName()) && Objects.equals(resourceType(), other.resourceType())
                && Objects.equals(tierAsString(), other.tierAsString()) && Objects.equals(monitor(), other.monitor());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ApplicationComponent").add("ComponentName", componentName()).add("ResourceType", resourceType())
                .add("Tier", tierAsString()).add("Monitor", monitor()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComponentName":
            return Optional.ofNullable(clazz.cast(componentName()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "Tier":
            return Optional.ofNullable(clazz.cast(tierAsString()));
        case "Monitor":
            return Optional.ofNullable(clazz.cast(monitor()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationComponent, T> g) {
        return obj -> g.apply((ApplicationComponent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationComponent> {
        /**
         * <p>
         * The name of the component.
         * </p>
         * 
         * @param componentName
         *        The name of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentName(String componentName);

        /**
         * <p>
         * The resource type. Supported resource types include EC2 instances, Auto Scaling group, Classic ELB,
         * Application ELB, and SQS Queue.
         * </p>
         * 
         * @param resourceType
         *        The resource type. Supported resource types include EC2 instances, Auto Scaling group, Classic ELB,
         *        Application ELB, and SQS Queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The stack tier of the application component.
         * </p>
         * 
         * @param tier
         *        The stack tier of the application component.
         * @see Tier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tier
         */
        Builder tier(String tier);

        /**
         * <p>
         * The stack tier of the application component.
         * </p>
         * 
         * @param tier
         *        The stack tier of the application component.
         * @see Tier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tier
         */
        Builder tier(Tier tier);

        /**
         * <p>
         * Indicates whether the application component is monitored.
         * </p>
         * 
         * @param monitor
         *        Indicates whether the application component is monitored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitor(Boolean monitor);
    }

    static final class BuilderImpl implements Builder {
        private String componentName;

        private String resourceType;

        private String tier;

        private Boolean monitor;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationComponent model) {
            componentName(model.componentName);
            resourceType(model.resourceType);
            tier(model.tier);
            monitor(model.monitor);
        }

        public final String getComponentName() {
            return componentName;
        }

        @Override
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getTier() {
            return tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        @Override
        public final Builder tier(Tier tier) {
            this.tier(tier == null ? null : tier.toString());
            return this;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        public final Boolean getMonitor() {
            return monitor;
        }

        @Override
        public final Builder monitor(Boolean monitor) {
            this.monitor = monitor;
            return this;
        }

        public final void setMonitor(Boolean monitor) {
            this.monitor = monitor;
        }

        @Override
        public ApplicationComponent build() {
            return new ApplicationComponent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
