/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationinsights.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes observations related to the problem.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RelatedObservations implements SdkPojo, Serializable,
        ToCopyableBuilder<RelatedObservations.Builder, RelatedObservations> {
    private static final SdkField<List<Observation>> OBSERVATION_LIST_FIELD = SdkField
            .<List<Observation>> builder(MarshallingType.LIST)
            .getter(getter(RelatedObservations::observationList))
            .setter(setter(Builder::observationList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObservationList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Observation> builder(MarshallingType.SDK_POJO)
                                            .constructor(Observation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBSERVATION_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Observation> observationList;

    private RelatedObservations(BuilderImpl builder) {
        this.observationList = builder.observationList;
    }

    /**
     * Returns true if the ObservationList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasObservationList() {
        return observationList != null && !(observationList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of observations related to the problem.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasObservationList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of observations related to the problem.
     */
    public List<Observation> observationList() {
        return observationList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(observationList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelatedObservations)) {
            return false;
        }
        RelatedObservations other = (RelatedObservations) obj;
        return Objects.equals(observationList(), other.observationList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RelatedObservations").add("ObservationList", observationList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ObservationList":
            return Optional.ofNullable(clazz.cast(observationList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RelatedObservations, T> g) {
        return obj -> g.apply((RelatedObservations) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RelatedObservations> {
        /**
         * <p>
         * The list of observations related to the problem.
         * </p>
         * 
         * @param observationList
         *        The list of observations related to the problem.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder observationList(Collection<Observation> observationList);

        /**
         * <p>
         * The list of observations related to the problem.
         * </p>
         * 
         * @param observationList
         *        The list of observations related to the problem.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder observationList(Observation... observationList);

        /**
         * <p>
         * The list of observations related to the problem.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Observation>.Builder} avoiding the need to
         * create one manually via {@link List<Observation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Observation>.Builder#build()} is called immediately and its
         * result is passed to {@link #observationList(List<Observation>)}.
         * 
         * @param observationList
         *        a consumer that will call methods on {@link List<Observation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #observationList(List<Observation>)
         */
        Builder observationList(Consumer<Observation.Builder>... observationList);
    }

    static final class BuilderImpl implements Builder {
        private List<Observation> observationList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RelatedObservations model) {
            observationList(model.observationList);
        }

        public final Collection<Observation.Builder> getObservationList() {
            return observationList != null ? observationList.stream().map(Observation::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder observationList(Collection<Observation> observationList) {
            this.observationList = ObservationListCopier.copy(observationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder observationList(Observation... observationList) {
            observationList(Arrays.asList(observationList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder observationList(Consumer<Observation.Builder>... observationList) {
            observationList(Stream.of(observationList).map(c -> Observation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setObservationList(Collection<Observation.BuilderImpl> observationList) {
            this.observationList = ObservationListCopier.copyFromBuilder(observationList);
        }

        @Override
        public RelatedObservations build() {
            return new RelatedObservations(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
