/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationinsights.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a problem that is detected by correlating observations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Problem implements SdkPojo, Serializable, ToCopyableBuilder<Problem.Builder, Problem> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Problem::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Problem::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<String> INSIGHTS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Problem::insights)).setter(setter(Builder::insights))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Insights").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Problem::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> AFFECTED_RESOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Problem::affectedResource)).setter(setter(Builder::affectedResource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AffectedResource").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Problem::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Problem::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<String> SEVERITY_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Problem::severityLevelAsString)).setter(setter(Builder::severityLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SeverityLevel").build()).build();

    private static final SdkField<String> RESOURCE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Problem::resourceGroupName)).setter(setter(Builder::resourceGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceGroupName").build()).build();

    private static final SdkField<Map<String, String>> FEEDBACK_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(Problem::feedbackAsStrings))
            .setter(setter(Builder::feedbackWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Feedback").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TITLE_FIELD,
            INSIGHTS_FIELD, STATUS_FIELD, AFFECTED_RESOURCE_FIELD, START_TIME_FIELD, END_TIME_FIELD, SEVERITY_LEVEL_FIELD,
            RESOURCE_GROUP_NAME_FIELD, FEEDBACK_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String title;

    private final String insights;

    private final String status;

    private final String affectedResource;

    private final Instant startTime;

    private final Instant endTime;

    private final String severityLevel;

    private final String resourceGroupName;

    private final Map<String, String> feedback;

    private Problem(BuilderImpl builder) {
        this.id = builder.id;
        this.title = builder.title;
        this.insights = builder.insights;
        this.status = builder.status;
        this.affectedResource = builder.affectedResource;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.severityLevel = builder.severityLevel;
        this.resourceGroupName = builder.resourceGroupName;
        this.feedback = builder.feedback;
    }

    /**
     * <p>
     * The ID of the problem.
     * </p>
     * 
     * @return The ID of the problem.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The name of the problem.
     * </p>
     * 
     * @return The name of the problem.
     */
    public String title() {
        return title;
    }

    /**
     * <p>
     * A detailed analysis of the problem using machine learning.
     * </p>
     * 
     * @return A detailed analysis of the problem using machine learning.
     */
    public String insights() {
        return insights;
    }

    /**
     * <p>
     * The status of the problem.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the problem.
     * @see Status
     */
    public Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * The status of the problem.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the problem.
     * @see Status
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The resource affected by the problem.
     * </p>
     * 
     * @return The resource affected by the problem.
     */
    public String affectedResource() {
        return affectedResource;
    }

    /**
     * <p>
     * The time when the problem started, in epoch seconds.
     * </p>
     * 
     * @return The time when the problem started, in epoch seconds.
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The time when the problem ended, in epoch seconds.
     * </p>
     * 
     * @return The time when the problem ended, in epoch seconds.
     */
    public Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * A measure of the level of impact of the problem.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severityLevel}
     * will return {@link SeverityLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #severityLevelAsString}.
     * </p>
     * 
     * @return A measure of the level of impact of the problem.
     * @see SeverityLevel
     */
    public SeverityLevel severityLevel() {
        return SeverityLevel.fromValue(severityLevel);
    }

    /**
     * <p>
     * A measure of the level of impact of the problem.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severityLevel}
     * will return {@link SeverityLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #severityLevelAsString}.
     * </p>
     * 
     * @return A measure of the level of impact of the problem.
     * @see SeverityLevel
     */
    public String severityLevelAsString() {
        return severityLevel;
    }

    /**
     * <p>
     * The name of the resource group affected by the problem.
     * </p>
     * 
     * @return The name of the resource group affected by the problem.
     */
    public String resourceGroupName() {
        return resourceGroupName;
    }

    /**
     * <p>
     * Feedback provided by the user about the problem.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFeedback()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Feedback provided by the user about the problem.
     */
    public Map<FeedbackKey, FeedbackValue> feedback() {
        return FeedbackCopier.copyStringToEnum(feedback);
    }

    /**
     * Returns true if the Feedback property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFeedback() {
        return feedback != null && !(feedback instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Feedback provided by the user about the problem.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFeedback()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Feedback provided by the user about the problem.
     */
    public Map<String, String> feedbackAsStrings() {
        return feedback;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(insights());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(affectedResource());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(severityLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(feedbackAsStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Problem)) {
            return false;
        }
        Problem other = (Problem) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(title(), other.title())
                && Objects.equals(insights(), other.insights()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(affectedResource(), other.affectedResource()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime())
                && Objects.equals(severityLevelAsString(), other.severityLevelAsString())
                && Objects.equals(resourceGroupName(), other.resourceGroupName())
                && Objects.equals(feedbackAsStrings(), other.feedbackAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Problem").add("Id", id()).add("Title", title()).add("Insights", insights())
                .add("Status", statusAsString()).add("AffectedResource", affectedResource()).add("StartTime", startTime())
                .add("EndTime", endTime()).add("SeverityLevel", severityLevelAsString())
                .add("ResourceGroupName", resourceGroupName()).add("Feedback", feedbackAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "Insights":
            return Optional.ofNullable(clazz.cast(insights()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "AffectedResource":
            return Optional.ofNullable(clazz.cast(affectedResource()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "SeverityLevel":
            return Optional.ofNullable(clazz.cast(severityLevelAsString()));
        case "ResourceGroupName":
            return Optional.ofNullable(clazz.cast(resourceGroupName()));
        case "Feedback":
            return Optional.ofNullable(clazz.cast(feedbackAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Problem, T> g) {
        return obj -> g.apply((Problem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Problem> {
        /**
         * <p>
         * The ID of the problem.
         * </p>
         * 
         * @param id
         *        The ID of the problem.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the problem.
         * </p>
         * 
         * @param title
         *        The name of the problem.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * A detailed analysis of the problem using machine learning.
         * </p>
         * 
         * @param insights
         *        A detailed analysis of the problem using machine learning.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insights(String insights);

        /**
         * <p>
         * The status of the problem.
         * </p>
         * 
         * @param status
         *        The status of the problem.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the problem.
         * </p>
         * 
         * @param status
         *        The status of the problem.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);

        /**
         * <p>
         * The resource affected by the problem.
         * </p>
         * 
         * @param affectedResource
         *        The resource affected by the problem.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder affectedResource(String affectedResource);

        /**
         * <p>
         * The time when the problem started, in epoch seconds.
         * </p>
         * 
         * @param startTime
         *        The time when the problem started, in epoch seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The time when the problem ended, in epoch seconds.
         * </p>
         * 
         * @param endTime
         *        The time when the problem ended, in epoch seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * A measure of the level of impact of the problem.
         * </p>
         * 
         * @param severityLevel
         *        A measure of the level of impact of the problem.
         * @see SeverityLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SeverityLevel
         */
        Builder severityLevel(String severityLevel);

        /**
         * <p>
         * A measure of the level of impact of the problem.
         * </p>
         * 
         * @param severityLevel
         *        A measure of the level of impact of the problem.
         * @see SeverityLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SeverityLevel
         */
        Builder severityLevel(SeverityLevel severityLevel);

        /**
         * <p>
         * The name of the resource group affected by the problem.
         * </p>
         * 
         * @param resourceGroupName
         *        The name of the resource group affected by the problem.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceGroupName(String resourceGroupName);

        /**
         * <p>
         * Feedback provided by the user about the problem.
         * </p>
         * 
         * @param feedback
         *        Feedback provided by the user about the problem.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder feedbackWithStrings(Map<String, String> feedback);

        /**
         * <p>
         * Feedback provided by the user about the problem.
         * </p>
         * 
         * @param feedback
         *        Feedback provided by the user about the problem.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder feedback(Map<FeedbackKey, FeedbackValue> feedback);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String title;

        private String insights;

        private String status;

        private String affectedResource;

        private Instant startTime;

        private Instant endTime;

        private String severityLevel;

        private String resourceGroupName;

        private Map<String, String> feedback = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Problem model) {
            id(model.id);
            title(model.title);
            insights(model.insights);
            status(model.status);
            affectedResource(model.affectedResource);
            startTime(model.startTime);
            endTime(model.endTime);
            severityLevel(model.severityLevel);
            resourceGroupName(model.resourceGroupName);
            feedbackWithStrings(model.feedback);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getTitle() {
            return title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final String getInsights() {
            return insights;
        }

        @Override
        public final Builder insights(String insights) {
            this.insights = insights;
            return this;
        }

        public final void setInsights(String insights) {
            this.insights = insights;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getAffectedResource() {
            return affectedResource;
        }

        @Override
        public final Builder affectedResource(String affectedResource) {
            this.affectedResource = affectedResource;
            return this;
        }

        public final void setAffectedResource(String affectedResource) {
            this.affectedResource = affectedResource;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getSeverityLevelAsString() {
            return severityLevel;
        }

        @Override
        public final Builder severityLevel(String severityLevel) {
            this.severityLevel = severityLevel;
            return this;
        }

        @Override
        public final Builder severityLevel(SeverityLevel severityLevel) {
            this.severityLevel(severityLevel == null ? null : severityLevel.toString());
            return this;
        }

        public final void setSeverityLevel(String severityLevel) {
            this.severityLevel = severityLevel;
        }

        public final String getResourceGroupName() {
            return resourceGroupName;
        }

        @Override
        public final Builder resourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
            return this;
        }

        public final void setResourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
        }

        public final Map<String, String> getFeedbackAsStrings() {
            return feedback;
        }

        @Override
        public final Builder feedbackWithStrings(Map<String, String> feedback) {
            this.feedback = FeedbackCopier.copy(feedback);
            return this;
        }

        @Override
        public final Builder feedback(Map<FeedbackKey, FeedbackValue> feedback) {
            this.feedback = FeedbackCopier.copyEnumToString(feedback);
            return this;
        }

        public final void setFeedbackWithStrings(Map<String, String> feedback) {
            this.feedback = FeedbackCopier.copy(feedback);
        }

        @Override
        public Problem build() {
            return new Problem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
