/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationinsights.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an anomaly or error with the application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Observation implements SdkPojo, Serializable, ToCopyableBuilder<Observation.Builder, Observation> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Observation::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Observation::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Observation::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Observation::sourceType)).setter(setter(Builder::sourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()).build();

    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Observation::sourceARN)).setter(setter(Builder::sourceARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceARN").build()).build();

    private static final SdkField<String> LOG_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Observation::logGroup)).setter(setter(Builder::logGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogGroup").build()).build();

    private static final SdkField<Instant> LINE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Observation::lineTime)).setter(setter(Builder::lineTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineTime").build()).build();

    private static final SdkField<String> LOG_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Observation::logText)).setter(setter(Builder::logText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogText").build()).build();

    private static final SdkField<String> LOG_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Observation::logFilterAsString)).setter(setter(Builder::logFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogFilter").build()).build();

    private static final SdkField<String> METRIC_NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Observation::metricNamespace)).setter(setter(Builder::metricNamespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricNamespace").build()).build();

    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Observation::metricName)).setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Observation::unit)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()).build();

    private static final SdkField<Double> VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(Observation::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, START_TIME_FIELD,
            END_TIME_FIELD, SOURCE_TYPE_FIELD, SOURCE_ARN_FIELD, LOG_GROUP_FIELD, LINE_TIME_FIELD, LOG_TEXT_FIELD,
            LOG_FILTER_FIELD, METRIC_NAMESPACE_FIELD, METRIC_NAME_FIELD, UNIT_FIELD, VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final Instant startTime;

    private final Instant endTime;

    private final String sourceType;

    private final String sourceARN;

    private final String logGroup;

    private final Instant lineTime;

    private final String logText;

    private final String logFilter;

    private final String metricNamespace;

    private final String metricName;

    private final String unit;

    private final Double value;

    private Observation(BuilderImpl builder) {
        this.id = builder.id;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.sourceType = builder.sourceType;
        this.sourceARN = builder.sourceARN;
        this.logGroup = builder.logGroup;
        this.lineTime = builder.lineTime;
        this.logText = builder.logText;
        this.logFilter = builder.logFilter;
        this.metricNamespace = builder.metricNamespace;
        this.metricName = builder.metricName;
        this.unit = builder.unit;
        this.value = builder.value;
    }

    /**
     * <p>
     * The ID of the observation type.
     * </p>
     * 
     * @return The ID of the observation type.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The time when the observation was first detected, in epoch seconds.
     * </p>
     * 
     * @return The time when the observation was first detected, in epoch seconds.
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The time when the observation ended, in epoch seconds.
     * </p>
     * 
     * @return The time when the observation ended, in epoch seconds.
     */
    public Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The source type of the observation.
     * </p>
     * 
     * @return The source type of the observation.
     */
    public String sourceType() {
        return sourceType;
    }

    /**
     * <p>
     * The source resource ARN of the observation.
     * </p>
     * 
     * @return The source resource ARN of the observation.
     */
    public String sourceARN() {
        return sourceARN;
    }

    /**
     * <p>
     * The log group name.
     * </p>
     * 
     * @return The log group name.
     */
    public String logGroup() {
        return logGroup;
    }

    /**
     * <p>
     * The timestamp in the CloudWatch Logs that specifies when the matched line occurred.
     * </p>
     * 
     * @return The timestamp in the CloudWatch Logs that specifies when the matched line occurred.
     */
    public Instant lineTime() {
        return lineTime;
    }

    /**
     * <p>
     * The log text of the observation.
     * </p>
     * 
     * @return The log text of the observation.
     */
    public String logText() {
        return logText;
    }

    /**
     * <p>
     * The log filter of the observation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logFilter} will
     * return {@link LogFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logFilterAsString}.
     * </p>
     * 
     * @return The log filter of the observation.
     * @see LogFilter
     */
    public LogFilter logFilter() {
        return LogFilter.fromValue(logFilter);
    }

    /**
     * <p>
     * The log filter of the observation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logFilter} will
     * return {@link LogFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logFilterAsString}.
     * </p>
     * 
     * @return The log filter of the observation.
     * @see LogFilter
     */
    public String logFilterAsString() {
        return logFilter;
    }

    /**
     * <p>
     * The namespace of the observation metric.
     * </p>
     * 
     * @return The namespace of the observation metric.
     */
    public String metricNamespace() {
        return metricNamespace;
    }

    /**
     * <p>
     * The name of the observation metric.
     * </p>
     * 
     * @return The name of the observation metric.
     */
    public String metricName() {
        return metricName;
    }

    /**
     * <p>
     * The unit of the source observation metric.
     * </p>
     * 
     * @return The unit of the source observation metric.
     */
    public String unit() {
        return unit;
    }

    /**
     * <p>
     * The value of the source observation metric.
     * </p>
     * 
     * @return The value of the source observation metric.
     */
    public Double value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(sourceType());
        hashCode = 31 * hashCode + Objects.hashCode(sourceARN());
        hashCode = 31 * hashCode + Objects.hashCode(logGroup());
        hashCode = 31 * hashCode + Objects.hashCode(lineTime());
        hashCode = 31 * hashCode + Objects.hashCode(logText());
        hashCode = 31 * hashCode + Objects.hashCode(logFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(metricNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        hashCode = 31 * hashCode + Objects.hashCode(unit());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Observation)) {
            return false;
        }
        Observation other = (Observation) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(sourceType(), other.sourceType())
                && Objects.equals(sourceARN(), other.sourceARN()) && Objects.equals(logGroup(), other.logGroup())
                && Objects.equals(lineTime(), other.lineTime()) && Objects.equals(logText(), other.logText())
                && Objects.equals(logFilterAsString(), other.logFilterAsString())
                && Objects.equals(metricNamespace(), other.metricNamespace()) && Objects.equals(metricName(), other.metricName())
                && Objects.equals(unit(), other.unit()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Observation").add("Id", id()).add("StartTime", startTime()).add("EndTime", endTime())
                .add("SourceType", sourceType()).add("SourceARN", sourceARN()).add("LogGroup", logGroup())
                .add("LineTime", lineTime()).add("LogText", logText()).add("LogFilter", logFilterAsString())
                .add("MetricNamespace", metricNamespace()).add("MetricName", metricName()).add("Unit", unit())
                .add("Value", value()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "SourceType":
            return Optional.ofNullable(clazz.cast(sourceType()));
        case "SourceARN":
            return Optional.ofNullable(clazz.cast(sourceARN()));
        case "LogGroup":
            return Optional.ofNullable(clazz.cast(logGroup()));
        case "LineTime":
            return Optional.ofNullable(clazz.cast(lineTime()));
        case "LogText":
            return Optional.ofNullable(clazz.cast(logText()));
        case "LogFilter":
            return Optional.ofNullable(clazz.cast(logFilterAsString()));
        case "MetricNamespace":
            return Optional.ofNullable(clazz.cast(metricNamespace()));
        case "MetricName":
            return Optional.ofNullable(clazz.cast(metricName()));
        case "Unit":
            return Optional.ofNullable(clazz.cast(unit()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Observation, T> g) {
        return obj -> g.apply((Observation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Observation> {
        /**
         * <p>
         * The ID of the observation type.
         * </p>
         * 
         * @param id
         *        The ID of the observation type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The time when the observation was first detected, in epoch seconds.
         * </p>
         * 
         * @param startTime
         *        The time when the observation was first detected, in epoch seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The time when the observation ended, in epoch seconds.
         * </p>
         * 
         * @param endTime
         *        The time when the observation ended, in epoch seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The source type of the observation.
         * </p>
         * 
         * @param sourceType
         *        The source type of the observation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceType(String sourceType);

        /**
         * <p>
         * The source resource ARN of the observation.
         * </p>
         * 
         * @param sourceARN
         *        The source resource ARN of the observation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceARN(String sourceARN);

        /**
         * <p>
         * The log group name.
         * </p>
         * 
         * @param logGroup
         *        The log group name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroup(String logGroup);

        /**
         * <p>
         * The timestamp in the CloudWatch Logs that specifies when the matched line occurred.
         * </p>
         * 
         * @param lineTime
         *        The timestamp in the CloudWatch Logs that specifies when the matched line occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineTime(Instant lineTime);

        /**
         * <p>
         * The log text of the observation.
         * </p>
         * 
         * @param logText
         *        The log text of the observation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logText(String logText);

        /**
         * <p>
         * The log filter of the observation.
         * </p>
         * 
         * @param logFilter
         *        The log filter of the observation.
         * @see LogFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogFilter
         */
        Builder logFilter(String logFilter);

        /**
         * <p>
         * The log filter of the observation.
         * </p>
         * 
         * @param logFilter
         *        The log filter of the observation.
         * @see LogFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogFilter
         */
        Builder logFilter(LogFilter logFilter);

        /**
         * <p>
         * The namespace of the observation metric.
         * </p>
         * 
         * @param metricNamespace
         *        The namespace of the observation metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricNamespace(String metricNamespace);

        /**
         * <p>
         * The name of the observation metric.
         * </p>
         * 
         * @param metricName
         *        The name of the observation metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The unit of the source observation metric.
         * </p>
         * 
         * @param unit
         *        The unit of the source observation metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unit(String unit);

        /**
         * <p>
         * The value of the source observation metric.
         * </p>
         * 
         * @param value
         *        The value of the source observation metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Double value);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private Instant startTime;

        private Instant endTime;

        private String sourceType;

        private String sourceARN;

        private String logGroup;

        private Instant lineTime;

        private String logText;

        private String logFilter;

        private String metricNamespace;

        private String metricName;

        private String unit;

        private Double value;

        private BuilderImpl() {
        }

        private BuilderImpl(Observation model) {
            id(model.id);
            startTime(model.startTime);
            endTime(model.endTime);
            sourceType(model.sourceType);
            sourceARN(model.sourceARN);
            logGroup(model.logGroup);
            lineTime(model.lineTime);
            logText(model.logText);
            logFilter(model.logFilter);
            metricNamespace(model.metricNamespace);
            metricName(model.metricName);
            unit(model.unit);
            value(model.value);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getSourceType() {
            return sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public final String getSourceARN() {
            return sourceARN;
        }

        @Override
        public final Builder sourceARN(String sourceARN) {
            this.sourceARN = sourceARN;
            return this;
        }

        public final void setSourceARN(String sourceARN) {
            this.sourceARN = sourceARN;
        }

        public final String getLogGroup() {
            return logGroup;
        }

        @Override
        public final Builder logGroup(String logGroup) {
            this.logGroup = logGroup;
            return this;
        }

        public final void setLogGroup(String logGroup) {
            this.logGroup = logGroup;
        }

        public final Instant getLineTime() {
            return lineTime;
        }

        @Override
        public final Builder lineTime(Instant lineTime) {
            this.lineTime = lineTime;
            return this;
        }

        public final void setLineTime(Instant lineTime) {
            this.lineTime = lineTime;
        }

        public final String getLogText() {
            return logText;
        }

        @Override
        public final Builder logText(String logText) {
            this.logText = logText;
            return this;
        }

        public final void setLogText(String logText) {
            this.logText = logText;
        }

        public final String getLogFilterAsString() {
            return logFilter;
        }

        @Override
        public final Builder logFilter(String logFilter) {
            this.logFilter = logFilter;
            return this;
        }

        @Override
        public final Builder logFilter(LogFilter logFilter) {
            this.logFilter(logFilter == null ? null : logFilter.toString());
            return this;
        }

        public final void setLogFilter(String logFilter) {
            this.logFilter = logFilter;
        }

        public final String getMetricNamespace() {
            return metricNamespace;
        }

        @Override
        public final Builder metricNamespace(String metricNamespace) {
            this.metricNamespace = metricNamespace;
            return this;
        }

        public final void setMetricNamespace(String metricNamespace) {
            this.metricNamespace = metricNamespace;
        }

        public final String getMetricName() {
            return metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final String getUnit() {
            return unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        public final Double getValue() {
            return value;
        }

        @Override
        public final Builder value(Double value) {
            this.value = value;
            return this;
        }

        public final void setValue(Double value) {
            this.value = value;
        }

        @Override
        public Observation build() {
            return new Observation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
