/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLogPatternsResponse extends ApplicationInsightsResponse implements
        ToCopyableBuilder<ListLogPatternsResponse.Builder, ListLogPatternsResponse> {
    private static final SdkField<String> RESOURCE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListLogPatternsResponse::resourceGroupName)).setter(setter(Builder::resourceGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceGroupName").build()).build();

    private static final SdkField<List<LogPattern>> LOG_PATTERNS_FIELD = SdkField
            .<List<LogPattern>> builder(MarshallingType.LIST)
            .getter(getter(ListLogPatternsResponse::logPatterns))
            .setter(setter(Builder::logPatterns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogPatterns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LogPattern> builder(MarshallingType.SDK_POJO)
                                            .constructor(LogPattern::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListLogPatternsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_GROUP_NAME_FIELD,
            LOG_PATTERNS_FIELD, NEXT_TOKEN_FIELD));

    private final String resourceGroupName;

    private final List<LogPattern> logPatterns;

    private final String nextToken;

    private ListLogPatternsResponse(BuilderImpl builder) {
        super(builder);
        this.resourceGroupName = builder.resourceGroupName;
        this.logPatterns = builder.logPatterns;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of the resource group.
     * </p>
     * 
     * @return The name of the resource group.
     */
    public String resourceGroupName() {
        return resourceGroupName;
    }

    /**
     * Returns true if the LogPatterns property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasLogPatterns() {
        return logPatterns != null && !(logPatterns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of log patterns.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLogPatterns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of log patterns.
     */
    public List<LogPattern> logPatterns() {
        return logPatterns;
    }

    /**
     * <p>
     * The token used to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token used to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(logPatterns());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLogPatternsResponse)) {
            return false;
        }
        ListLogPatternsResponse other = (ListLogPatternsResponse) obj;
        return Objects.equals(resourceGroupName(), other.resourceGroupName())
                && Objects.equals(logPatterns(), other.logPatterns()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListLogPatternsResponse").add("ResourceGroupName", resourceGroupName())
                .add("LogPatterns", logPatterns()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceGroupName":
            return Optional.ofNullable(clazz.cast(resourceGroupName()));
        case "LogPatterns":
            return Optional.ofNullable(clazz.cast(logPatterns()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLogPatternsResponse, T> g) {
        return obj -> g.apply((ListLogPatternsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationInsightsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListLogPatternsResponse> {
        /**
         * <p>
         * The name of the resource group.
         * </p>
         * 
         * @param resourceGroupName
         *        The name of the resource group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceGroupName(String resourceGroupName);

        /**
         * <p>
         * The list of log patterns.
         * </p>
         * 
         * @param logPatterns
         *        The list of log patterns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logPatterns(Collection<LogPattern> logPatterns);

        /**
         * <p>
         * The list of log patterns.
         * </p>
         * 
         * @param logPatterns
         *        The list of log patterns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logPatterns(LogPattern... logPatterns);

        /**
         * <p>
         * The list of log patterns.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LogPattern>.Builder} avoiding the need to
         * create one manually via {@link List<LogPattern>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LogPattern>.Builder#build()} is called immediately and its
         * result is passed to {@link #logPatterns(List<LogPattern>)}.
         * 
         * @param logPatterns
         *        a consumer that will call methods on {@link List<LogPattern>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logPatterns(List<LogPattern>)
         */
        Builder logPatterns(Consumer<LogPattern.Builder>... logPatterns);

        /**
         * <p>
         * The token used to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token used to retrieve the next page of results. This value is <code>null</code> when there are no
         *        more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ApplicationInsightsResponse.BuilderImpl implements Builder {
        private String resourceGroupName;

        private List<LogPattern> logPatterns = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLogPatternsResponse model) {
            super(model);
            resourceGroupName(model.resourceGroupName);
            logPatterns(model.logPatterns);
            nextToken(model.nextToken);
        }

        public final String getResourceGroupName() {
            return resourceGroupName;
        }

        @Override
        public final Builder resourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
            return this;
        }

        public final void setResourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
        }

        public final Collection<LogPattern.Builder> getLogPatterns() {
            return logPatterns != null ? logPatterns.stream().map(LogPattern::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder logPatterns(Collection<LogPattern> logPatterns) {
            this.logPatterns = LogPatternListCopier.copy(logPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logPatterns(LogPattern... logPatterns) {
            logPatterns(Arrays.asList(logPatterns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logPatterns(Consumer<LogPattern.Builder>... logPatterns) {
            logPatterns(Stream.of(logPatterns).map(c -> LogPattern.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setLogPatterns(Collection<LogPattern.BuilderImpl> logPatterns) {
            this.logPatterns = LogPatternListCopier.copyFromBuilder(logPatterns);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListLogPatternsResponse build() {
            return new ListLogPatternsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
