/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListConfigurationHistoryResponse extends ApplicationInsightsResponse implements
        ToCopyableBuilder<ListConfigurationHistoryResponse.Builder, ListConfigurationHistoryResponse> {
    private static final SdkField<List<ConfigurationEvent>> EVENT_LIST_FIELD = SdkField
            .<List<ConfigurationEvent>> builder(MarshallingType.LIST)
            .getter(getter(ListConfigurationHistoryResponse::eventList))
            .setter(setter(Builder::eventList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConfigurationEvent> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConfigurationEvent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListConfigurationHistoryResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ConfigurationEvent> eventList;

    private final String nextToken;

    private ListConfigurationHistoryResponse(BuilderImpl builder) {
        super(builder);
        this.eventList = builder.eventList;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the EventList property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasEventList() {
        return eventList != null && !(eventList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of configuration events and their corresponding details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEventList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of configuration events and their corresponding details.
     */
    public List<ConfigurationEvent> eventList() {
        return eventList;
    }

    /**
     * <p>
     * The <code>NextToken</code> value to include in a future <code>ListConfigurationHistory</code> request. When the
     * results of a <code>ListConfigurationHistory</code> request exceed <code>MaxResults</code>, this value can be used
     * to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.
     * </p>
     * 
     * @return The <code>NextToken</code> value to include in a future <code>ListConfigurationHistory</code> request.
     *         When the results of a <code>ListConfigurationHistory</code> request exceed <code>MaxResults</code>, this
     *         value can be used to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(eventList());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConfigurationHistoryResponse)) {
            return false;
        }
        ListConfigurationHistoryResponse other = (ListConfigurationHistoryResponse) obj;
        return Objects.equals(eventList(), other.eventList()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListConfigurationHistoryResponse").add("EventList", eventList()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventList":
            return Optional.ofNullable(clazz.cast(eventList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListConfigurationHistoryResponse, T> g) {
        return obj -> g.apply((ListConfigurationHistoryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationInsightsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListConfigurationHistoryResponse> {
        /**
         * <p>
         * The list of configuration events and their corresponding details.
         * </p>
         * 
         * @param eventList
         *        The list of configuration events and their corresponding details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventList(Collection<ConfigurationEvent> eventList);

        /**
         * <p>
         * The list of configuration events and their corresponding details.
         * </p>
         * 
         * @param eventList
         *        The list of configuration events and their corresponding details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventList(ConfigurationEvent... eventList);

        /**
         * <p>
         * The list of configuration events and their corresponding details.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ConfigurationEvent>.Builder} avoiding the
         * need to create one manually via {@link List<ConfigurationEvent>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConfigurationEvent>.Builder#build()} is called immediately
         * and its result is passed to {@link #eventList(List<ConfigurationEvent>)}.
         * 
         * @param eventList
         *        a consumer that will call methods on {@link List<ConfigurationEvent>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventList(List<ConfigurationEvent>)
         */
        Builder eventList(Consumer<ConfigurationEvent.Builder>... eventList);

        /**
         * <p>
         * The <code>NextToken</code> value to include in a future <code>ListConfigurationHistory</code> request. When
         * the results of a <code>ListConfigurationHistory</code> request exceed <code>MaxResults</code>, this value can
         * be used to retrieve the next page of results. This value is <code>null</code> when there are no more results
         * to return.
         * </p>
         * 
         * @param nextToken
         *        The <code>NextToken</code> value to include in a future <code>ListConfigurationHistory</code> request.
         *        When the results of a <code>ListConfigurationHistory</code> request exceed <code>MaxResults</code>,
         *        this value can be used to retrieve the next page of results. This value is <code>null</code> when
         *        there are no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ApplicationInsightsResponse.BuilderImpl implements Builder {
        private List<ConfigurationEvent> eventList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConfigurationHistoryResponse model) {
            super(model);
            eventList(model.eventList);
            nextToken(model.nextToken);
        }

        public final Collection<ConfigurationEvent.Builder> getEventList() {
            return eventList != null ? eventList.stream().map(ConfigurationEvent::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder eventList(Collection<ConfigurationEvent> eventList) {
            this.eventList = ConfigurationEventListCopier.copy(eventList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventList(ConfigurationEvent... eventList) {
            eventList(Arrays.asList(eventList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventList(Consumer<ConfigurationEvent.Builder>... eventList) {
            eventList(Stream.of(eventList).map(c -> ConfigurationEvent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEventList(Collection<ConfigurationEvent.BuilderImpl> eventList) {
            this.eventList = ConfigurationEventListCopier.copyFromBuilder(eventList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListConfigurationHistoryResponse build() {
            return new ListConfigurationHistoryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
