/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeProblemResponse extends ApplicationInsightsResponse implements
        ToCopyableBuilder<DescribeProblemResponse.Builder, DescribeProblemResponse> {
    private static final SdkField<Problem> PROBLEM_FIELD = SdkField.<Problem> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeProblemResponse::problem)).setter(setter(Builder::problem)).constructor(Problem::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Problem").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROBLEM_FIELD));

    private final Problem problem;

    private DescribeProblemResponse(BuilderImpl builder) {
        super(builder);
        this.problem = builder.problem;
    }

    /**
     * <p>
     * Information about the problem.
     * </p>
     * 
     * @return Information about the problem.
     */
    public Problem problem() {
        return problem;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(problem());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProblemResponse)) {
            return false;
        }
        DescribeProblemResponse other = (DescribeProblemResponse) obj;
        return Objects.equals(problem(), other.problem());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeProblemResponse").add("Problem", problem()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Problem":
            return Optional.ofNullable(clazz.cast(problem()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeProblemResponse, T> g) {
        return obj -> g.apply((DescribeProblemResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationInsightsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeProblemResponse> {
        /**
         * <p>
         * Information about the problem.
         * </p>
         * 
         * @param problem
         *        Information about the problem.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder problem(Problem problem);

        /**
         * <p>
         * Information about the problem.
         * </p>
         * This is a convenience that creates an instance of the {@link Problem.Builder} avoiding the need to create one
         * manually via {@link Problem#builder()}.
         *
         * When the {@link Consumer} completes, {@link Problem.Builder#build()} is called immediately and its result is
         * passed to {@link #problem(Problem)}.
         * 
         * @param problem
         *        a consumer that will call methods on {@link Problem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #problem(Problem)
         */
        default Builder problem(Consumer<Problem.Builder> problem) {
            return problem(Problem.builder().applyMutation(problem).build());
        }
    }

    static final class BuilderImpl extends ApplicationInsightsResponse.BuilderImpl implements Builder {
        private Problem problem;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProblemResponse model) {
            super(model);
            problem(model.problem);
        }

        public final Problem.Builder getProblem() {
            return problem != null ? problem.toBuilder() : null;
        }

        @Override
        public final Builder problem(Problem problem) {
            this.problem = problem;
            return this;
        }

        public final void setProblem(Problem.BuilderImpl problem) {
            this.problem = problem != null ? problem.build() : null;
        }

        @Override
        public DescribeProblemResponse build() {
            return new DescribeProblemResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
