/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.applicationdiscovery.model.AgentNetworkInfo;
import software.amazon.awssdk.services.applicationdiscovery.model.AgentNetworkInfoListCopier;
import software.amazon.awssdk.services.applicationdiscovery.model.AgentStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AgentInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AgentInfo> {
    private static final SdkField<String> AGENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AgentInfo.getter(AgentInfo::agentId)).setter(AgentInfo.setter(Builder::agentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentId").build()}).build();
    private static final SdkField<String> HOST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AgentInfo.getter(AgentInfo::hostName)).setter(AgentInfo.setter(Builder::hostName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostName").build()}).build();
    private static final SdkField<List<AgentNetworkInfo>> AGENT_NETWORK_INFO_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AgentInfo.getter(AgentInfo::agentNetworkInfoList)).setter(AgentInfo.setter(Builder::agentNetworkInfoList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentNetworkInfoList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AgentNetworkInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONNECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AgentInfo.getter(AgentInfo::connectorId)).setter(AgentInfo.setter(Builder::connectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorId").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AgentInfo.getter(AgentInfo::version)).setter(AgentInfo.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<String> HEALTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AgentInfo.getter(AgentInfo::healthAsString)).setter(AgentInfo.setter(Builder::health)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("health").build()}).build();
    private static final SdkField<String> LAST_HEALTH_PING_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AgentInfo.getter(AgentInfo::lastHealthPingTime)).setter(AgentInfo.setter(Builder::lastHealthPingTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastHealthPingTime").build()}).build();
    private static final SdkField<String> COLLECTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AgentInfo.getter(AgentInfo::collectionStatus)).setter(AgentInfo.setter(Builder::collectionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collectionStatus").build()}).build();
    private static final SdkField<String> AGENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AgentInfo.getter(AgentInfo::agentType)).setter(AgentInfo.setter(Builder::agentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentType").build()}).build();
    private static final SdkField<String> REGISTERED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AgentInfo.getter(AgentInfo::registeredTime)).setter(AgentInfo.setter(Builder::registeredTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registeredTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ID_FIELD, HOST_NAME_FIELD, AGENT_NETWORK_INFO_LIST_FIELD, CONNECTOR_ID_FIELD, VERSION_FIELD, HEALTH_FIELD, LAST_HEALTH_PING_TIME_FIELD, COLLECTION_STATUS_FIELD, AGENT_TYPE_FIELD, REGISTERED_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String agentId;
    private final String hostName;
    private final List<AgentNetworkInfo> agentNetworkInfoList;
    private final String connectorId;
    private final String version;
    private final String health;
    private final String lastHealthPingTime;
    private final String collectionStatus;
    private final String agentType;
    private final String registeredTime;

    private AgentInfo(BuilderImpl builder) {
        this.agentId = builder.agentId;
        this.hostName = builder.hostName;
        this.agentNetworkInfoList = builder.agentNetworkInfoList;
        this.connectorId = builder.connectorId;
        this.version = builder.version;
        this.health = builder.health;
        this.lastHealthPingTime = builder.lastHealthPingTime;
        this.collectionStatus = builder.collectionStatus;
        this.agentType = builder.agentType;
        this.registeredTime = builder.registeredTime;
    }

    public String agentId() {
        return this.agentId;
    }

    public String hostName() {
        return this.hostName;
    }

    public List<AgentNetworkInfo> agentNetworkInfoList() {
        return this.agentNetworkInfoList;
    }

    public String connectorId() {
        return this.connectorId;
    }

    public String version() {
        return this.version;
    }

    public AgentStatus health() {
        return AgentStatus.fromValue(this.health);
    }

    public String healthAsString() {
        return this.health;
    }

    public String lastHealthPingTime() {
        return this.lastHealthPingTime;
    }

    public String collectionStatus() {
        return this.collectionStatus;
    }

    public String agentType() {
        return this.agentType;
    }

    public String registeredTime() {
        return this.registeredTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.agentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostName());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentNetworkInfoList());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastHealthPingTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.registeredTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentInfo)) {
            return false;
        }
        AgentInfo other = (AgentInfo)obj;
        return Objects.equals(this.agentId(), other.agentId()) && Objects.equals(this.hostName(), other.hostName()) && Objects.equals(this.agentNetworkInfoList(), other.agentNetworkInfoList()) && Objects.equals(this.connectorId(), other.connectorId()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.healthAsString(), other.healthAsString()) && Objects.equals(this.lastHealthPingTime(), other.lastHealthPingTime()) && Objects.equals(this.collectionStatus(), other.collectionStatus()) && Objects.equals(this.agentType(), other.agentType()) && Objects.equals(this.registeredTime(), other.registeredTime());
    }

    public String toString() {
        return ToString.builder((String)"AgentInfo").add("AgentId", (Object)this.agentId()).add("HostName", (Object)this.hostName()).add("AgentNetworkInfoList", this.agentNetworkInfoList()).add("ConnectorId", (Object)this.connectorId()).add("Version", (Object)this.version()).add("Health", (Object)this.healthAsString()).add("LastHealthPingTime", (Object)this.lastHealthPingTime()).add("CollectionStatus", (Object)this.collectionStatus()).add("AgentType", (Object)this.agentType()).add("RegisteredTime", (Object)this.registeredTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "agentId": {
                return Optional.ofNullable(clazz.cast(this.agentId()));
            }
            case "hostName": {
                return Optional.ofNullable(clazz.cast(this.hostName()));
            }
            case "agentNetworkInfoList": {
                return Optional.ofNullable(clazz.cast(this.agentNetworkInfoList()));
            }
            case "connectorId": {
                return Optional.ofNullable(clazz.cast(this.connectorId()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "health": {
                return Optional.ofNullable(clazz.cast(this.healthAsString()));
            }
            case "lastHealthPingTime": {
                return Optional.ofNullable(clazz.cast(this.lastHealthPingTime()));
            }
            case "collectionStatus": {
                return Optional.ofNullable(clazz.cast(this.collectionStatus()));
            }
            case "agentType": {
                return Optional.ofNullable(clazz.cast(this.agentType()));
            }
            case "registeredTime": {
                return Optional.ofNullable(clazz.cast(this.registeredTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AgentInfo, T> g) {
        return obj -> g.apply((AgentInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String agentId;
        private String hostName;
        private List<AgentNetworkInfo> agentNetworkInfoList = DefaultSdkAutoConstructList.getInstance();
        private String connectorId;
        private String version;
        private String health;
        private String lastHealthPingTime;
        private String collectionStatus;
        private String agentType;
        private String registeredTime;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentInfo model) {
            this.agentId(model.agentId);
            this.hostName(model.hostName);
            this.agentNetworkInfoList(model.agentNetworkInfoList);
            this.connectorId(model.connectorId);
            this.version(model.version);
            this.health(model.health);
            this.lastHealthPingTime(model.lastHealthPingTime);
            this.collectionStatus(model.collectionStatus);
            this.agentType(model.agentType);
            this.registeredTime(model.registeredTime);
        }

        public final String getAgentId() {
            return this.agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        public final String getHostName() {
            return this.hostName;
        }

        @Override
        public final Builder hostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public final void setHostName(String hostName) {
            this.hostName = hostName;
        }

        public final Collection<AgentNetworkInfo.Builder> getAgentNetworkInfoList() {
            return this.agentNetworkInfoList != null ? (Collection)this.agentNetworkInfoList.stream().map(AgentNetworkInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder agentNetworkInfoList(Collection<AgentNetworkInfo> agentNetworkInfoList) {
            this.agentNetworkInfoList = AgentNetworkInfoListCopier.copy(agentNetworkInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentNetworkInfoList(AgentNetworkInfo ... agentNetworkInfoList) {
            this.agentNetworkInfoList(Arrays.asList(agentNetworkInfoList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentNetworkInfoList(Consumer<AgentNetworkInfo.Builder> ... agentNetworkInfoList) {
            this.agentNetworkInfoList(Stream.of(agentNetworkInfoList).map(c -> (AgentNetworkInfo)((AgentNetworkInfo.Builder)AgentNetworkInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAgentNetworkInfoList(Collection<AgentNetworkInfo.BuilderImpl> agentNetworkInfoList) {
            this.agentNetworkInfoList = AgentNetworkInfoListCopier.copyFromBuilder(agentNetworkInfoList);
        }

        public final String getConnectorId() {
            return this.connectorId;
        }

        @Override
        public final Builder connectorId(String connectorId) {
            this.connectorId = connectorId;
            return this;
        }

        public final void setConnectorId(String connectorId) {
            this.connectorId = connectorId;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getHealthAsString() {
            return this.health;
        }

        @Override
        public final Builder health(String health) {
            this.health = health;
            return this;
        }

        @Override
        public final Builder health(AgentStatus health) {
            this.health(health == null ? null : health.toString());
            return this;
        }

        public final void setHealth(String health) {
            this.health = health;
        }

        public final String getLastHealthPingTime() {
            return this.lastHealthPingTime;
        }

        @Override
        public final Builder lastHealthPingTime(String lastHealthPingTime) {
            this.lastHealthPingTime = lastHealthPingTime;
            return this;
        }

        public final void setLastHealthPingTime(String lastHealthPingTime) {
            this.lastHealthPingTime = lastHealthPingTime;
        }

        public final String getCollectionStatus() {
            return this.collectionStatus;
        }

        @Override
        public final Builder collectionStatus(String collectionStatus) {
            this.collectionStatus = collectionStatus;
            return this;
        }

        public final void setCollectionStatus(String collectionStatus) {
            this.collectionStatus = collectionStatus;
        }

        public final String getAgentType() {
            return this.agentType;
        }

        @Override
        public final Builder agentType(String agentType) {
            this.agentType = agentType;
            return this;
        }

        public final void setAgentType(String agentType) {
            this.agentType = agentType;
        }

        public final String getRegisteredTime() {
            return this.registeredTime;
        }

        @Override
        public final Builder registeredTime(String registeredTime) {
            this.registeredTime = registeredTime;
            return this;
        }

        public final void setRegisteredTime(String registeredTime) {
            this.registeredTime = registeredTime;
        }

        public AgentInfo build() {
            return new AgentInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AgentInfo> {
        public Builder agentId(String var1);

        public Builder hostName(String var1);

        public Builder agentNetworkInfoList(Collection<AgentNetworkInfo> var1);

        public Builder agentNetworkInfoList(AgentNetworkInfo ... var1);

        public Builder agentNetworkInfoList(Consumer<AgentNetworkInfo.Builder> ... var1);

        public Builder connectorId(String var1);

        public Builder version(String var1);

        public Builder health(String var1);

        public Builder health(AgentStatus var1);

        public Builder lastHealthPingTime(String var1);

        public Builder collectionStatus(String var1);

        public Builder agentType(String var1);

        public Builder registeredTime(String var1);
    }
}

