/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.applicationdiscovery.model.BatchDeleteImportDataErrorCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeleteImportDataError
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchDeleteImportDataError> {
    private static final SdkField<String> IMPORT_TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BatchDeleteImportDataError.getter(BatchDeleteImportDataError::importTaskId)).setter(BatchDeleteImportDataError.setter(Builder::importTaskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importTaskId").build()}).build();
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BatchDeleteImportDataError.getter(BatchDeleteImportDataError::errorCodeAsString)).setter(BatchDeleteImportDataError.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()}).build();
    private static final SdkField<String> ERROR_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BatchDeleteImportDataError.getter(BatchDeleteImportDataError::errorDescription)).setter(BatchDeleteImportDataError.setter(Builder::errorDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_TASK_ID_FIELD, ERROR_CODE_FIELD, ERROR_DESCRIPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String importTaskId;
    private final String errorCode;
    private final String errorDescription;

    private BatchDeleteImportDataError(BuilderImpl builder) {
        this.importTaskId = builder.importTaskId;
        this.errorCode = builder.errorCode;
        this.errorDescription = builder.errorDescription;
    }

    public String importTaskId() {
        return this.importTaskId;
    }

    public BatchDeleteImportDataErrorCode errorCode() {
        return BatchDeleteImportDataErrorCode.fromValue(this.errorCode);
    }

    public String errorCodeAsString() {
        return this.errorCode;
    }

    public String errorDescription() {
        return this.errorDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.importTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorDescription());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteImportDataError)) {
            return false;
        }
        BatchDeleteImportDataError other = (BatchDeleteImportDataError)obj;
        return Objects.equals(this.importTaskId(), other.importTaskId()) && Objects.equals(this.errorCodeAsString(), other.errorCodeAsString()) && Objects.equals(this.errorDescription(), other.errorDescription());
    }

    public String toString() {
        return ToString.builder((String)"BatchDeleteImportDataError").add("ImportTaskId", (Object)this.importTaskId()).add("ErrorCode", (Object)this.errorCodeAsString()).add("ErrorDescription", (Object)this.errorDescription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "importTaskId": {
                return Optional.ofNullable(clazz.cast(this.importTaskId()));
            }
            case "errorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCodeAsString()));
            }
            case "errorDescription": {
                return Optional.ofNullable(clazz.cast(this.errorDescription()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteImportDataError, T> g) {
        return obj -> g.apply((BatchDeleteImportDataError)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String importTaskId;
        private String errorCode;
        private String errorDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteImportDataError model) {
            this.importTaskId(model.importTaskId);
            this.errorCode(model.errorCode);
            this.errorDescription(model.errorDescription);
        }

        public final String getImportTaskId() {
            return this.importTaskId;
        }

        @Override
        public final Builder importTaskId(String importTaskId) {
            this.importTaskId = importTaskId;
            return this;
        }

        public final void setImportTaskId(String importTaskId) {
            this.importTaskId = importTaskId;
        }

        public final String getErrorCodeAsString() {
            return this.errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(BatchDeleteImportDataErrorCode errorCode) {
            this.errorCode(errorCode.toString());
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getErrorDescription() {
            return this.errorDescription;
        }

        @Override
        public final Builder errorDescription(String errorDescription) {
            this.errorDescription = errorDescription;
            return this;
        }

        public final void setErrorDescription(String errorDescription) {
            this.errorDescription = errorDescription;
        }

        public BatchDeleteImportDataError build() {
            return new BatchDeleteImportDataError(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchDeleteImportDataError> {
        public Builder importTaskId(String var1);

        public Builder errorCode(String var1);

        public Builder errorCode(BatchDeleteImportDataErrorCode var1);

        public Builder errorDescription(String var1);
    }
}

