/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.applicationdiscovery.ApplicationDiscoveryAsyncClient;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeImportTasksRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeImportTasksResponse;

public class DescribeImportTasksPublisher
implements SdkPublisher<DescribeImportTasksResponse> {
    private final ApplicationDiscoveryAsyncClient client;
    private final DescribeImportTasksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeImportTasksPublisher(ApplicationDiscoveryAsyncClient client, DescribeImportTasksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeImportTasksPublisher(ApplicationDiscoveryAsyncClient client, DescribeImportTasksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeImportTasksResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeImportTasksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final DescribeImportTasksPublisher resume(DescribeImportTasksResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeImportTasksPublisher(this.client, (DescribeImportTasksRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeImportTasksPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeImportTasksResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeImportTasksResponseFetcher
    implements AsyncPageFetcher<DescribeImportTasksResponse> {
        private DescribeImportTasksResponseFetcher() {
        }

        public boolean hasNextPage(DescribeImportTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeImportTasksResponse> nextPage(DescribeImportTasksResponse previousPage) {
            if (previousPage == null) {
                return DescribeImportTasksPublisher.this.client.describeImportTasks(DescribeImportTasksPublisher.this.firstRequest);
            }
            return DescribeImportTasksPublisher.this.client.describeImportTasks((DescribeImportTasksRequest)((Object)DescribeImportTasksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

