/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.applicationdiscovery.ApplicationDiscoveryClient;
import software.amazon.awssdk.services.applicationdiscovery.internal.UserAgentUtils;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeExportTasksRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeExportTasksResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.ExportInfo;

public class DescribeExportTasksIterable
implements SdkIterable<DescribeExportTasksResponse> {
    private final ApplicationDiscoveryClient client;
    private final DescribeExportTasksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeExportTasksIterable(ApplicationDiscoveryClient client, DescribeExportTasksRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeExportTasksResponseFetcher();
    }

    public Iterator<DescribeExportTasksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ExportInfo> exportsInfo() {
        Function<DescribeExportTasksResponse, Iterator> getIterator = response -> {
            if (response != null && response.exportsInfo() != null) {
                return response.exportsInfo().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeExportTasksResponseFetcher
    implements SyncPageFetcher<DescribeExportTasksResponse> {
        private DescribeExportTasksResponseFetcher() {
        }

        public boolean hasNextPage(DescribeExportTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeExportTasksResponse nextPage(DescribeExportTasksResponse previousPage) {
            if (previousPage == null) {
                return DescribeExportTasksIterable.this.client.describeExportTasks(DescribeExportTasksIterable.this.firstRequest);
            }
            return DescribeExportTasksIterable.this.client.describeExportTasks((DescribeExportTasksRequest)((Object)DescribeExportTasksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

