/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationdiscovery.model.ApplicationDiscoveryRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.ConfigurationIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListServerNeighborsRequest
extends ApplicationDiscoveryRequest
implements ToCopyableBuilder<Builder, ListServerNeighborsRequest> {
    private static final SdkField<String> CONFIGURATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configurationId").getter(ListServerNeighborsRequest.getter(ListServerNeighborsRequest::configurationId)).setter(ListServerNeighborsRequest.setter(Builder::configurationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationId").build()}).build();
    private static final SdkField<Boolean> PORT_INFORMATION_NEEDED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("portInformationNeeded").getter(ListServerNeighborsRequest.getter(ListServerNeighborsRequest::portInformationNeeded)).setter(ListServerNeighborsRequest.setter(Builder::portInformationNeeded)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portInformationNeeded").build()}).build();
    private static final SdkField<List<String>> NEIGHBOR_CONFIGURATION_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("neighborConfigurationIds").getter(ListServerNeighborsRequest.getter(ListServerNeighborsRequest::neighborConfigurationIds)).setter(ListServerNeighborsRequest.setter(Builder::neighborConfigurationIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("neighborConfigurationIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListServerNeighborsRequest.getter(ListServerNeighborsRequest::maxResults)).setter(ListServerNeighborsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListServerNeighborsRequest.getter(ListServerNeighborsRequest::nextToken)).setter(ListServerNeighborsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_ID_FIELD, PORT_INFORMATION_NEEDED_FIELD, NEIGHBOR_CONFIGURATION_IDS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListServerNeighborsRequest.memberNameToFieldInitializer();
    private final String configurationId;
    private final Boolean portInformationNeeded;
    private final List<String> neighborConfigurationIds;
    private final Integer maxResults;
    private final String nextToken;

    private ListServerNeighborsRequest(BuilderImpl builder) {
        super(builder);
        this.configurationId = builder.configurationId;
        this.portInformationNeeded = builder.portInformationNeeded;
        this.neighborConfigurationIds = builder.neighborConfigurationIds;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String configurationId() {
        return this.configurationId;
    }

    public final Boolean portInformationNeeded() {
        return this.portInformationNeeded;
    }

    public final boolean hasNeighborConfigurationIds() {
        return this.neighborConfigurationIds != null && !(this.neighborConfigurationIds instanceof SdkAutoConstructList);
    }

    public final List<String> neighborConfigurationIds() {
        return this.neighborConfigurationIds;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.portInformationNeeded());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNeighborConfigurationIds() ? this.neighborConfigurationIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServerNeighborsRequest)) {
            return false;
        }
        ListServerNeighborsRequest other = (ListServerNeighborsRequest)((Object)obj);
        return Objects.equals(this.configurationId(), other.configurationId()) && Objects.equals(this.portInformationNeeded(), other.portInformationNeeded()) && this.hasNeighborConfigurationIds() == other.hasNeighborConfigurationIds() && Objects.equals(this.neighborConfigurationIds(), other.neighborConfigurationIds()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListServerNeighborsRequest").add("ConfigurationId", (Object)this.configurationId()).add("PortInformationNeeded", (Object)this.portInformationNeeded()).add("NeighborConfigurationIds", this.hasNeighborConfigurationIds() ? this.neighborConfigurationIds() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "configurationId": {
                return Optional.ofNullable(clazz.cast(this.configurationId()));
            }
            case "portInformationNeeded": {
                return Optional.ofNullable(clazz.cast(this.portInformationNeeded()));
            }
            case "neighborConfigurationIds": {
                return Optional.ofNullable(clazz.cast(this.neighborConfigurationIds()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("configurationId", CONFIGURATION_ID_FIELD);
        map.put("portInformationNeeded", PORT_INFORMATION_NEEDED_FIELD);
        map.put("neighborConfigurationIds", NEIGHBOR_CONFIGURATION_IDS_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListServerNeighborsRequest, T> g) {
        return obj -> g.apply((ListServerNeighborsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationDiscoveryRequest.BuilderImpl
    implements Builder {
        private String configurationId;
        private Boolean portInformationNeeded;
        private List<String> neighborConfigurationIds = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServerNeighborsRequest model) {
            super(model);
            this.configurationId(model.configurationId);
            this.portInformationNeeded(model.portInformationNeeded);
            this.neighborConfigurationIds(model.neighborConfigurationIds);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getConfigurationId() {
            return this.configurationId;
        }

        public final void setConfigurationId(String configurationId) {
            this.configurationId = configurationId;
        }

        @Override
        public final Builder configurationId(String configurationId) {
            this.configurationId = configurationId;
            return this;
        }

        public final Boolean getPortInformationNeeded() {
            return this.portInformationNeeded;
        }

        public final void setPortInformationNeeded(Boolean portInformationNeeded) {
            this.portInformationNeeded = portInformationNeeded;
        }

        @Override
        public final Builder portInformationNeeded(Boolean portInformationNeeded) {
            this.portInformationNeeded = portInformationNeeded;
            return this;
        }

        public final Collection<String> getNeighborConfigurationIds() {
            if (this.neighborConfigurationIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.neighborConfigurationIds;
        }

        public final void setNeighborConfigurationIds(Collection<String> neighborConfigurationIds) {
            this.neighborConfigurationIds = ConfigurationIdListCopier.copy(neighborConfigurationIds);
        }

        @Override
        public final Builder neighborConfigurationIds(Collection<String> neighborConfigurationIds) {
            this.neighborConfigurationIds = ConfigurationIdListCopier.copy(neighborConfigurationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder neighborConfigurationIds(String ... neighborConfigurationIds) {
            this.neighborConfigurationIds(Arrays.asList(neighborConfigurationIds));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListServerNeighborsRequest build() {
            return new ListServerNeighborsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ApplicationDiscoveryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListServerNeighborsRequest> {
        public Builder configurationId(String var1);

        public Builder portInformationNeeded(Boolean var1);

        public Builder neighborConfigurationIds(Collection<String> var1);

        public Builder neighborConfigurationIds(String ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

