/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.applicationdiscovery.ApplicationDiscoveryClient;
import software.amazon.awssdk.services.applicationdiscovery.internal.UserAgentUtils;
import software.amazon.awssdk.services.applicationdiscovery.model.AgentInfo;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeAgentsRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeAgentsResponse;

public class DescribeAgentsIterable
implements SdkIterable<DescribeAgentsResponse> {
    private final ApplicationDiscoveryClient client;
    private final DescribeAgentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeAgentsIterable(ApplicationDiscoveryClient client, DescribeAgentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeAgentsResponseFetcher();
    }

    public Iterator<DescribeAgentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AgentInfo> agentsInfo() {
        Function<DescribeAgentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.agentsInfo() != null) {
                return response.agentsInfo().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeAgentsResponseFetcher
    implements SyncPageFetcher<DescribeAgentsResponse> {
        private DescribeAgentsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAgentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeAgentsResponse nextPage(DescribeAgentsResponse previousPage) {
            if (previousPage == null) {
                return DescribeAgentsIterable.this.client.describeAgents(DescribeAgentsIterable.this.firstRequest);
            }
            return DescribeAgentsIterable.this.client.describeAgents((DescribeAgentsRequest)((Object)DescribeAgentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

