/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationdiscovery.model.ApplicationDiscoveryResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.ExportInfo;
import software.amazon.awssdk.services.applicationdiscovery.model.ExportsInfoCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeExportTasksResponse
extends ApplicationDiscoveryResponse
implements ToCopyableBuilder<Builder, DescribeExportTasksResponse> {
    private static final SdkField<List<ExportInfo>> EXPORTS_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("exportsInfo").getter(DescribeExportTasksResponse.getter(DescribeExportTasksResponse::exportsInfo)).setter(DescribeExportTasksResponse.setter(Builder::exportsInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportsInfo").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExportInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeExportTasksResponse.getter(DescribeExportTasksResponse::nextToken)).setter(DescribeExportTasksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORTS_INFO_FIELD, NEXT_TOKEN_FIELD));
    private final List<ExportInfo> exportsInfo;
    private final String nextToken;

    private DescribeExportTasksResponse(BuilderImpl builder) {
        super(builder);
        this.exportsInfo = builder.exportsInfo;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasExportsInfo() {
        return this.exportsInfo != null && !(this.exportsInfo instanceof SdkAutoConstructList);
    }

    public final List<ExportInfo> exportsInfo() {
        return this.exportsInfo;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExportsInfo() ? this.exportsInfo() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeExportTasksResponse)) {
            return false;
        }
        DescribeExportTasksResponse other = (DescribeExportTasksResponse)((Object)obj);
        return this.hasExportsInfo() == other.hasExportsInfo() && Objects.equals(this.exportsInfo(), other.exportsInfo()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeExportTasksResponse").add("ExportsInfo", this.hasExportsInfo() ? this.exportsInfo() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "exportsInfo": {
                return Optional.ofNullable(clazz.cast(this.exportsInfo()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeExportTasksResponse, T> g) {
        return obj -> g.apply((DescribeExportTasksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationDiscoveryResponse.BuilderImpl
    implements Builder {
        private List<ExportInfo> exportsInfo = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeExportTasksResponse model) {
            super(model);
            this.exportsInfo(model.exportsInfo);
            this.nextToken(model.nextToken);
        }

        public final List<ExportInfo.Builder> getExportsInfo() {
            List<ExportInfo.Builder> result = ExportsInfoCopier.copyToBuilder(this.exportsInfo);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder exportsInfo(Collection<ExportInfo> exportsInfo) {
            this.exportsInfo = ExportsInfoCopier.copy(exportsInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportsInfo(ExportInfo ... exportsInfo) {
            this.exportsInfo(Arrays.asList(exportsInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportsInfo(Consumer<ExportInfo.Builder> ... exportsInfo) {
            this.exportsInfo(Stream.of(exportsInfo).map(c -> (ExportInfo)((ExportInfo.Builder)ExportInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setExportsInfo(Collection<ExportInfo.BuilderImpl> exportsInfo) {
            this.exportsInfo = ExportsInfoCopier.copyFromBuilder(exportsInfo);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeExportTasksResponse build() {
            return new DescribeExportTasksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApplicationDiscoveryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeExportTasksResponse> {
        public Builder exportsInfo(Collection<ExportInfo> var1);

        public Builder exportsInfo(ExportInfo ... var1);

        public Builder exportsInfo(Consumer<ExportInfo.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

