/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartDataCollectionByAgentIdsRequest extends ApplicationDiscoveryRequest implements
        ToCopyableBuilder<StartDataCollectionByAgentIdsRequest.Builder, StartDataCollectionByAgentIdsRequest> {
    private static final SdkField<List<String>> AGENT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(StartDataCollectionByAgentIdsRequest::agentIds))
            .setter(setter(Builder::agentIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_IDS_FIELD));

    private final List<String> agentIds;

    private StartDataCollectionByAgentIdsRequest(BuilderImpl builder) {
        super(builder);
        this.agentIds = builder.agentIds;
    }

    /**
     * Returns true if the AgentIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAgentIds() {
        return agentIds != null && !(agentIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the agents or connectors from which to start collecting data. If you send a request to an
     * agent/connector ID that you do not have permission to contact, according to your AWS account, the service does
     * not throw an exception. Instead, it returns the error in the <i>Description</i> field. If you send a request to
     * multiple agents/connectors and you do not have permission to contact some of those agents/connectors, the system
     * does not throw an exception. Instead, the system shows <code>Failed</code> in the <i>Description</i> field.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAgentIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IDs of the agents or connectors from which to start collecting data. If you send a request to an
     *         agent/connector ID that you do not have permission to contact, according to your AWS account, the service
     *         does not throw an exception. Instead, it returns the error in the <i>Description</i> field. If you send a
     *         request to multiple agents/connectors and you do not have permission to contact some of those
     *         agents/connectors, the system does not throw an exception. Instead, the system shows <code>Failed</code>
     *         in the <i>Description</i> field.
     */
    public List<String> agentIds() {
        return agentIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(agentIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDataCollectionByAgentIdsRequest)) {
            return false;
        }
        StartDataCollectionByAgentIdsRequest other = (StartDataCollectionByAgentIdsRequest) obj;
        return Objects.equals(agentIds(), other.agentIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StartDataCollectionByAgentIdsRequest").add("AgentIds", agentIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentIds":
            return Optional.ofNullable(clazz.cast(agentIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartDataCollectionByAgentIdsRequest, T> g) {
        return obj -> g.apply((StartDataCollectionByAgentIdsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationDiscoveryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartDataCollectionByAgentIdsRequest> {
        /**
         * <p>
         * The IDs of the agents or connectors from which to start collecting data. If you send a request to an
         * agent/connector ID that you do not have permission to contact, according to your AWS account, the service
         * does not throw an exception. Instead, it returns the error in the <i>Description</i> field. If you send a
         * request to multiple agents/connectors and you do not have permission to contact some of those
         * agents/connectors, the system does not throw an exception. Instead, the system shows <code>Failed</code> in
         * the <i>Description</i> field.
         * </p>
         * 
         * @param agentIds
         *        The IDs of the agents or connectors from which to start collecting data. If you send a request to an
         *        agent/connector ID that you do not have permission to contact, according to your AWS account, the
         *        service does not throw an exception. Instead, it returns the error in the <i>Description</i> field. If
         *        you send a request to multiple agents/connectors and you do not have permission to contact some of
         *        those agents/connectors, the system does not throw an exception. Instead, the system shows
         *        <code>Failed</code> in the <i>Description</i> field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentIds(Collection<String> agentIds);

        /**
         * <p>
         * The IDs of the agents or connectors from which to start collecting data. If you send a request to an
         * agent/connector ID that you do not have permission to contact, according to your AWS account, the service
         * does not throw an exception. Instead, it returns the error in the <i>Description</i> field. If you send a
         * request to multiple agents/connectors and you do not have permission to contact some of those
         * agents/connectors, the system does not throw an exception. Instead, the system shows <code>Failed</code> in
         * the <i>Description</i> field.
         * </p>
         * 
         * @param agentIds
         *        The IDs of the agents or connectors from which to start collecting data. If you send a request to an
         *        agent/connector ID that you do not have permission to contact, according to your AWS account, the
         *        service does not throw an exception. Instead, it returns the error in the <i>Description</i> field. If
         *        you send a request to multiple agents/connectors and you do not have permission to contact some of
         *        those agents/connectors, the system does not throw an exception. Instead, the system shows
         *        <code>Failed</code> in the <i>Description</i> field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentIds(String... agentIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApplicationDiscoveryRequest.BuilderImpl implements Builder {
        private List<String> agentIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartDataCollectionByAgentIdsRequest model) {
            super(model);
            agentIds(model.agentIds);
        }

        public final Collection<String> getAgentIds() {
            return agentIds;
        }

        @Override
        public final Builder agentIds(Collection<String> agentIds) {
            this.agentIds = AgentIdsCopier.copy(agentIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentIds(String... agentIds) {
            agentIds(Arrays.asList(agentIds));
            return this;
        }

        public final void setAgentIds(Collection<String> agentIds) {
            this.agentIds = AgentIdsCopier.copy(agentIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartDataCollectionByAgentIdsRequest build() {
            return new StartDataCollectionByAgentIdsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
