/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.applicationdiscovery.model.AssociateConfigurationItemsToApplicationRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.AssociateConfigurationItemsToApplicationResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.BatchDeleteImportDataRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.BatchDeleteImportDataResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.CreateApplicationRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.CreateApplicationResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.CreateTagsRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.CreateTagsResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.DeleteApplicationsRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.DeleteApplicationsResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.DeleteTagsRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.DeleteTagsResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeAgentsRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeAgentsResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeConfigurationsRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeConfigurationsResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeContinuousExportsRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeContinuousExportsResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeExportTasksRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeExportTasksResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeImportTasksRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeImportTasksResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeTagsRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeTagsResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.DisassociateConfigurationItemsFromApplicationRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.DisassociateConfigurationItemsFromApplicationResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.GetDiscoverySummaryRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.GetDiscoverySummaryResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.ListConfigurationsRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.ListConfigurationsResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.ListServerNeighborsRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.ListServerNeighborsResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.StartContinuousExportRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.StartContinuousExportResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.StartDataCollectionByAgentIdsRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.StartDataCollectionByAgentIdsResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.StartExportTaskRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.StartExportTaskResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.StartImportTaskRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.StartImportTaskResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.StopContinuousExportRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.StopContinuousExportResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.StopDataCollectionByAgentIdsRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.StopDataCollectionByAgentIdsResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.UpdateApplicationRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.UpdateApplicationResponse;
import software.amazon.awssdk.services.applicationdiscovery.paginators.DescribeContinuousExportsPublisher;
import software.amazon.awssdk.services.applicationdiscovery.paginators.DescribeImportTasksPublisher;

/**
 * Service client for accessing AWS Application Discovery Service asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <fullname>AWS Application Discovery Service</fullname>
 * <p>
 * AWS Application Discovery Service helps you plan application migration projects. It automatically identifies servers,
 * virtual machines (VMs), and network dependencies in your on-premises data centers. For more information, see the <a
 * href="http://aws.amazon.com/application-discovery/faqs/">AWS Application Discovery Service FAQ</a>. Application
 * Discovery Service offers three ways of performing discovery and collecting data about your on-premises servers:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <b>Agentless discovery</b> is recommended for environments that use VMware vCenter Server. This mode doesn't require
 * you to install an agent on each host. It does not work in non-VMware environments.
 * </p>
 * <ul>
 * <li>
 * <p>
 * Agentless discovery gathers server information regardless of the operating systems, which minimizes the time required
 * for initial on-premises infrastructure assessment.
 * </p>
 * </li>
 * <li>
 * <p>
 * Agentless discovery doesn't collect information about network dependencies, only agent-based discovery collects that
 * information.
 * </p>
 * </li>
 * </ul>
 * </li>
 * </ul>
 * <ul>
 * <li>
 * <p>
 * <b>Agent-based discovery</b> collects a richer set of data than agentless discovery by using the AWS Application
 * Discovery Agent, which you install on one or more hosts in your data center.
 * </p>
 * <ul>
 * <li>
 * <p>
 * The agent captures infrastructure and application information, including an inventory of running processes, system
 * performance information, resource utilization, and network dependencies.
 * </p>
 * </li>
 * <li>
 * <p>
 * The information collected by agents is secured at rest and in transit to the Application Discovery Service database
 * in the cloud.
 * </p>
 * </li>
 * </ul>
 * </li>
 * </ul>
 * <ul>
 * <li>
 * <p>
 * <b>AWS Partner Network (APN) solutions</b> integrate with Application Discovery Service, enabling you to import
 * details of your on-premises environment directly into Migration Hub without using the discovery connector or
 * discovery agent.
 * </p>
 * <ul>
 * <li>
 * <p>
 * Third-party application discovery tools can query AWS Application Discovery Service, and they can write to the
 * Application Discovery Service database using the public API.
 * </p>
 * </li>
 * <li>
 * <p>
 * In this way, you can import data into Migration Hub and view it, so that you can associate applications with servers
 * and track migrations.
 * </p>
 * </li>
 * </ul>
 * </li>
 * </ul>
 * <p>
 * <b>Recommendations</b>
 * </p>
 * <p>
 * We recommend that you use agent-based discovery for non-VMware environments, and whenever you want to collect
 * information about network dependencies. You can run agent-based and agentless discovery simultaneously. Use agentless
 * discovery to complete the initial infrastructure assessment quickly, and then install agents on select hosts to
 * collect additional information.
 * </p>
 * <p>
 * <b>Working With This Guide</b>
 * </p>
 * <p>
 * This API reference provides descriptions, syntax, and usage examples for each of the actions and data types for
 * Application Discovery Service. The topic for each action shows the API request parameters and the response.
 * Alternatively, you can use one of the AWS SDKs to access an API that is tailored to the programming language or
 * platform that you're using. For more information, see <a href="http://aws.amazon.com/tools/#SDKs">AWS SDKs</a>.
 * </p>
 * <note>
 * <ul>
 * <li>
 * <p>
 * Remember that you must set your Migration Hub home region before you call any of these APIs.
 * </p>
 * </li>
 * <li>
 * <p>
 * You must make API calls for write actions (create, notify, associate, disassociate, import, or put) while in your
 * home region, or a <code>HomeRegionNotSetException</code> error is returned.
 * </p>
 * </li>
 * <li>
 * <p>
 * API calls for read actions (list, describe, stop, and delete) are permitted outside of your home region.
 * </p>
 * </li>
 * <li>
 * <p>
 * Although it is unlikely, the Migration Hub home region could change. If you call APIs outside the home region, an
 * <code>InvalidInputException</code> is returned.
 * </p>
 * </li>
 * <li>
 * <p>
 * You must call <code>GetHomeRegion</code> to obtain the latest Migration Hub home region.
 * </p>
 * </li>
 * </ul>
 * </note>
 * <p>
 * This guide is intended for use with the <a
 * href="http://docs.aws.amazon.com/application-discovery/latest/userguide/">AWS Application Discovery Service User
 * Guide</a>.
 * </p>
 * <important>
 * <p>
 * All data is handled according to the <a href="http://aws.amazon.com/privacy/">AWS Privacy Policy</a>. You can operate
 * Application Discovery Service offline to inspect collected data before it is shared with the service.
 * </p>
 * </important>
 */
@Generated("software.amazon.awssdk:codegen")
public interface ApplicationDiscoveryAsyncClient extends SdkClient {
    String SERVICE_NAME = "discovery";

    /**
     * Create a {@link ApplicationDiscoveryAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ApplicationDiscoveryAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ApplicationDiscoveryAsyncClient}.
     */
    static ApplicationDiscoveryAsyncClientBuilder builder() {
        return new DefaultApplicationDiscoveryAsyncClientBuilder();
    }

    /**
     * <p>
     * Associates one or more configuration items with an application.
     * </p>
     *
     * @param associateConfigurationItemsToApplicationRequest
     * @return A Java Future containing the result of the AssociateConfigurationItemsToApplication operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.AssociateConfigurationItemsToApplication
     */
    default CompletableFuture<AssociateConfigurationItemsToApplicationResponse> associateConfigurationItemsToApplication(
            AssociateConfigurationItemsToApplicationRequest associateConfigurationItemsToApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates one or more configuration items with an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AssociateConfigurationItemsToApplicationRequest.Builder} avoiding the need to create one manually via
     * {@link AssociateConfigurationItemsToApplicationRequest#builder()}
     * </p>
     *
     * @param associateConfigurationItemsToApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link AssociateConfigurationItemsToApplicationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AssociateConfigurationItemsToApplication operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.AssociateConfigurationItemsToApplication
     */
    default CompletableFuture<AssociateConfigurationItemsToApplicationResponse> associateConfigurationItemsToApplication(
            Consumer<AssociateConfigurationItemsToApplicationRequest.Builder> associateConfigurationItemsToApplicationRequest) {
        return associateConfigurationItemsToApplication(AssociateConfigurationItemsToApplicationRequest.builder()
                .applyMutation(associateConfigurationItemsToApplicationRequest).build());
    }

    /**
     * <p>
     * Deletes one or more import tasks, each identified by their import ID. Each import task has a number of records
     * that can identify servers or applications.
     * </p>
     * <p>
     * AWS Application Discovery Service has built-in matching logic that will identify when discovered servers match
     * existing entries that you've previously discovered, the information for the already-existing discovered server is
     * updated. When you delete an import task that contains records that were used to match, the information in those
     * matched records that comes from the deleted records will also be deleted.
     * </p>
     *
     * @param batchDeleteImportDataRequest
     * @return A Java Future containing the result of the BatchDeleteImportData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.BatchDeleteImportData
     */
    default CompletableFuture<BatchDeleteImportDataResponse> batchDeleteImportData(
            BatchDeleteImportDataRequest batchDeleteImportDataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes one or more import tasks, each identified by their import ID. Each import task has a number of records
     * that can identify servers or applications.
     * </p>
     * <p>
     * AWS Application Discovery Service has built-in matching logic that will identify when discovered servers match
     * existing entries that you've previously discovered, the information for the already-existing discovered server is
     * updated. When you delete an import task that contains records that were used to match, the information in those
     * matched records that comes from the deleted records will also be deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteImportDataRequest.Builder} avoiding the
     * need to create one manually via {@link BatchDeleteImportDataRequest#builder()}
     * </p>
     *
     * @param batchDeleteImportDataRequest
     *        A {@link Consumer} that will call methods on {@link BatchDeleteImportDataRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchDeleteImportData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.BatchDeleteImportData
     */
    default CompletableFuture<BatchDeleteImportDataResponse> batchDeleteImportData(
            Consumer<BatchDeleteImportDataRequest.Builder> batchDeleteImportDataRequest) {
        return batchDeleteImportData(BatchDeleteImportDataRequest.builder().applyMutation(batchDeleteImportDataRequest).build());
    }

    /**
     * <p>
     * Creates an application with the given name and description.
     * </p>
     *
     * @param createApplicationRequest
     * @return A Java Future containing the result of the CreateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.CreateApplication
     */
    default CompletableFuture<CreateApplicationResponse> createApplication(CreateApplicationRequest createApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an application with the given name and description.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link CreateApplicationRequest#builder()}
     * </p>
     *
     * @param createApplicationRequest
     *        A {@link Consumer} that will call methods on {@link CreateApplicationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.CreateApplication
     */
    default CompletableFuture<CreateApplicationResponse> createApplication(
            Consumer<CreateApplicationRequest.Builder> createApplicationRequest) {
        return createApplication(CreateApplicationRequest.builder().applyMutation(createApplicationRequest).build());
    }

    /**
     * <p>
     * Creates one or more tags for configuration items. Tags are metadata that help you categorize IT assets. This API
     * accepts a list of multiple configuration items.
     * </p>
     *
     * @param createTagsRequest
     * @return A Java Future containing the result of the CreateTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>ResourceNotFoundException The specified configuration ID was not located. Verify the configuration ID
     *         and try again.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.CreateTags
     */
    default CompletableFuture<CreateTagsResponse> createTags(CreateTagsRequest createTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates one or more tags for configuration items. Tags are metadata that help you categorize IT assets. This API
     * accepts a list of multiple configuration items.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTagsRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTagsRequest#builder()}
     * </p>
     *
     * @param createTagsRequest
     *        A {@link Consumer} that will call methods on {@link CreateTagsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>ResourceNotFoundException The specified configuration ID was not located. Verify the configuration ID
     *         and try again.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.CreateTags
     */
    default CompletableFuture<CreateTagsResponse> createTags(Consumer<CreateTagsRequest.Builder> createTagsRequest) {
        return createTags(CreateTagsRequest.builder().applyMutation(createTagsRequest).build());
    }

    /**
     * <p>
     * Deletes a list of applications and their associations with configuration items.
     * </p>
     *
     * @param deleteApplicationsRequest
     * @return A Java Future containing the result of the DeleteApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.DeleteApplications
     */
    default CompletableFuture<DeleteApplicationsResponse> deleteApplications(DeleteApplicationsRequest deleteApplicationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a list of applications and their associations with configuration items.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApplicationsRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteApplicationsRequest#builder()}
     * </p>
     *
     * @param deleteApplicationsRequest
     *        A {@link Consumer} that will call methods on {@link DeleteApplicationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.DeleteApplications
     */
    default CompletableFuture<DeleteApplicationsResponse> deleteApplications(
            Consumer<DeleteApplicationsRequest.Builder> deleteApplicationsRequest) {
        return deleteApplications(DeleteApplicationsRequest.builder().applyMutation(deleteApplicationsRequest).build());
    }

    /**
     * <p>
     * Deletes the association between configuration items and one or more tags. This API accepts a list of multiple
     * configuration items.
     * </p>
     *
     * @param deleteTagsRequest
     * @return A Java Future containing the result of the DeleteTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>ResourceNotFoundException The specified configuration ID was not located. Verify the configuration ID
     *         and try again.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.DeleteTags
     */
    default CompletableFuture<DeleteTagsResponse> deleteTags(DeleteTagsRequest deleteTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the association between configuration items and one or more tags. This API accepts a list of multiple
     * configuration items.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTagsRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTagsRequest#builder()}
     * </p>
     *
     * @param deleteTagsRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTagsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>ResourceNotFoundException The specified configuration ID was not located. Verify the configuration ID
     *         and try again.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.DeleteTags
     */
    default CompletableFuture<DeleteTagsResponse> deleteTags(Consumer<DeleteTagsRequest.Builder> deleteTagsRequest) {
        return deleteTags(DeleteTagsRequest.builder().applyMutation(deleteTagsRequest).build());
    }

    /**
     * <p>
     * Lists agents or connectors as specified by ID or other filters. All agents/connectors associated with your user
     * account can be listed if you call <code>DescribeAgents</code> as is without passing any parameters.
     * </p>
     *
     * @param describeAgentsRequest
     * @return A Java Future containing the result of the DescribeAgents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.DescribeAgents
     */
    default CompletableFuture<DescribeAgentsResponse> describeAgents(DescribeAgentsRequest describeAgentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists agents or connectors as specified by ID or other filters. All agents/connectors associated with your user
     * account can be listed if you call <code>DescribeAgents</code> as is without passing any parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAgentsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeAgentsRequest#builder()}
     * </p>
     *
     * @param describeAgentsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAgentsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeAgents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.DescribeAgents
     */
    default CompletableFuture<DescribeAgentsResponse> describeAgents(Consumer<DescribeAgentsRequest.Builder> describeAgentsRequest) {
        return describeAgents(DescribeAgentsRequest.builder().applyMutation(describeAgentsRequest).build());
    }

    /**
     * <p>
     * Lists agents or connectors as specified by ID or other filters. All agents/connectors associated with your user
     * account can be listed if you call <code>DescribeAgents</code> as is without passing any parameters.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeAgents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.DescribeAgents
     */
    default CompletableFuture<DescribeAgentsResponse> describeAgents() {
        return describeAgents(DescribeAgentsRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves attributes for a list of configuration item IDs.
     * </p>
     * <note>
     * <p>
     * All of the supplied IDs must be for the same asset type from one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * server
     * </p>
     * </li>
     * <li>
     * <p>
     * application
     * </p>
     * </li>
     * <li>
     * <p>
     * process
     * </p>
     * </li>
     * <li>
     * <p>
     * connection
     * </p>
     * </li>
     * </ul>
     * <p>
     * Output fields are specific to the asset type specified. For example, the output for a <i>server</i> configuration
     * item includes a list of attributes about the server, such as host name, operating system, number of network
     * cards, etc.
     * </p>
     * <p>
     * For a complete list of outputs for each asset type, see <a href=
     * "https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#DescribeConfigurations"
     * >Using the DescribeConfigurations Action</a> in the <i>AWS Application Discovery Service User Guide</i>.
     * </p>
     * </note>
     *
     * @param describeConfigurationsRequest
     * @return A Java Future containing the result of the DescribeConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.DescribeConfigurations
     */
    default CompletableFuture<DescribeConfigurationsResponse> describeConfigurations(
            DescribeConfigurationsRequest describeConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves attributes for a list of configuration item IDs.
     * </p>
     * <note>
     * <p>
     * All of the supplied IDs must be for the same asset type from one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * server
     * </p>
     * </li>
     * <li>
     * <p>
     * application
     * </p>
     * </li>
     * <li>
     * <p>
     * process
     * </p>
     * </li>
     * <li>
     * <p>
     * connection
     * </p>
     * </li>
     * </ul>
     * <p>
     * Output fields are specific to the asset type specified. For example, the output for a <i>server</i> configuration
     * item includes a list of attributes about the server, such as host name, operating system, number of network
     * cards, etc.
     * </p>
     * <p>
     * For a complete list of outputs for each asset type, see <a href=
     * "https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#DescribeConfigurations"
     * >Using the DescribeConfigurations Action</a> in the <i>AWS Application Discovery Service User Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConfigurationsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeConfigurationsRequest#builder()}
     * </p>
     *
     * @param describeConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeConfigurationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.DescribeConfigurations
     */
    default CompletableFuture<DescribeConfigurationsResponse> describeConfigurations(
            Consumer<DescribeConfigurationsRequest.Builder> describeConfigurationsRequest) {
        return describeConfigurations(DescribeConfigurationsRequest.builder().applyMutation(describeConfigurationsRequest)
                .build());
    }

    /**
     * <p>
     * Lists exports as specified by ID. All continuous exports associated with your user account can be listed if you
     * call <code>DescribeContinuousExports</code> as is without passing any parameters.
     * </p>
     *
     * @param describeContinuousExportsRequest
     * @return A Java Future containing the result of the DescribeContinuousExports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>OperationNotPermittedException This operation is not permitted.</li>
     *         <li>ResourceNotFoundException The specified configuration ID was not located. Verify the configuration ID
     *         and try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.DescribeContinuousExports
     */
    default CompletableFuture<DescribeContinuousExportsResponse> describeContinuousExports(
            DescribeContinuousExportsRequest describeContinuousExportsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists exports as specified by ID. All continuous exports associated with your user account can be listed if you
     * call <code>DescribeContinuousExports</code> as is without passing any parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeContinuousExportsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeContinuousExportsRequest#builder()}
     * </p>
     *
     * @param describeContinuousExportsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeContinuousExportsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeContinuousExports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>OperationNotPermittedException This operation is not permitted.</li>
     *         <li>ResourceNotFoundException The specified configuration ID was not located. Verify the configuration ID
     *         and try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.DescribeContinuousExports
     */
    default CompletableFuture<DescribeContinuousExportsResponse> describeContinuousExports(
            Consumer<DescribeContinuousExportsRequest.Builder> describeContinuousExportsRequest) {
        return describeContinuousExports(DescribeContinuousExportsRequest.builder()
                .applyMutation(describeContinuousExportsRequest).build());
    }

    /**
     * <p>
     * Lists exports as specified by ID. All continuous exports associated with your user account can be listed if you
     * call <code>DescribeContinuousExports</code> as is without passing any parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeContinuousExports(software.amazon.awssdk.services.applicationdiscovery.model.DescribeContinuousExportsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationdiscovery.paginators.DescribeContinuousExportsPublisher publisher = client.describeContinuousExportsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationdiscovery.paginators.DescribeContinuousExportsPublisher publisher = client.describeContinuousExportsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.applicationdiscovery.model.DescribeContinuousExportsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.applicationdiscovery.model.DescribeContinuousExportsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeContinuousExports(software.amazon.awssdk.services.applicationdiscovery.model.DescribeContinuousExportsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeContinuousExportsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>OperationNotPermittedException This operation is not permitted.</li>
     *         <li>ResourceNotFoundException The specified configuration ID was not located. Verify the configuration ID
     *         and try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.DescribeContinuousExports
     */
    default DescribeContinuousExportsPublisher describeContinuousExportsPaginator(
            DescribeContinuousExportsRequest describeContinuousExportsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists exports as specified by ID. All continuous exports associated with your user account can be listed if you
     * call <code>DescribeContinuousExports</code> as is without passing any parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeContinuousExports(software.amazon.awssdk.services.applicationdiscovery.model.DescribeContinuousExportsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationdiscovery.paginators.DescribeContinuousExportsPublisher publisher = client.describeContinuousExportsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationdiscovery.paginators.DescribeContinuousExportsPublisher publisher = client.describeContinuousExportsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.applicationdiscovery.model.DescribeContinuousExportsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.applicationdiscovery.model.DescribeContinuousExportsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeContinuousExports(software.amazon.awssdk.services.applicationdiscovery.model.DescribeContinuousExportsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeContinuousExportsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeContinuousExportsRequest#builder()}
     * </p>
     *
     * @param describeContinuousExportsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeContinuousExportsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>OperationNotPermittedException This operation is not permitted.</li>
     *         <li>ResourceNotFoundException The specified configuration ID was not located. Verify the configuration ID
     *         and try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.DescribeContinuousExports
     */
    default DescribeContinuousExportsPublisher describeContinuousExportsPaginator(
            Consumer<DescribeContinuousExportsRequest.Builder> describeContinuousExportsRequest) {
        return describeContinuousExportsPaginator(DescribeContinuousExportsRequest.builder()
                .applyMutation(describeContinuousExportsRequest).build());
    }

    /**
     * <p>
     * Retrieve status of one or more export tasks. You can retrieve the status of up to 100 export tasks.
     * </p>
     *
     * @param describeExportTasksRequest
     * @return A Java Future containing the result of the DescribeExportTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.DescribeExportTasks
     */
    default CompletableFuture<DescribeExportTasksResponse> describeExportTasks(
            DescribeExportTasksRequest describeExportTasksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve status of one or more export tasks. You can retrieve the status of up to 100 export tasks.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeExportTasksRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeExportTasksRequest#builder()}
     * </p>
     *
     * @param describeExportTasksRequest
     *        A {@link Consumer} that will call methods on {@link DescribeExportTasksRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeExportTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.DescribeExportTasks
     */
    default CompletableFuture<DescribeExportTasksResponse> describeExportTasks(
            Consumer<DescribeExportTasksRequest.Builder> describeExportTasksRequest) {
        return describeExportTasks(DescribeExportTasksRequest.builder().applyMutation(describeExportTasksRequest).build());
    }

    /**
     * <p>
     * Retrieve status of one or more export tasks. You can retrieve the status of up to 100 export tasks.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeExportTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.DescribeExportTasks
     */
    default CompletableFuture<DescribeExportTasksResponse> describeExportTasks() {
        return describeExportTasks(DescribeExportTasksRequest.builder().build());
    }

    /**
     * <p>
     * Returns an array of import tasks for your account, including status information, times, IDs, the Amazon S3 Object
     * URL for the import file, and more.
     * </p>
     *
     * @param describeImportTasksRequest
     * @return A Java Future containing the result of the DescribeImportTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.DescribeImportTasks
     */
    default CompletableFuture<DescribeImportTasksResponse> describeImportTasks(
            DescribeImportTasksRequest describeImportTasksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of import tasks for your account, including status information, times, IDs, the Amazon S3 Object
     * URL for the import file, and more.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeImportTasksRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeImportTasksRequest#builder()}
     * </p>
     *
     * @param describeImportTasksRequest
     *        A {@link Consumer} that will call methods on {@link DescribeImportTasksRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeImportTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.DescribeImportTasks
     */
    default CompletableFuture<DescribeImportTasksResponse> describeImportTasks(
            Consumer<DescribeImportTasksRequest.Builder> describeImportTasksRequest) {
        return describeImportTasks(DescribeImportTasksRequest.builder().applyMutation(describeImportTasksRequest).build());
    }

    /**
     * <p>
     * Returns an array of import tasks for your account, including status information, times, IDs, the Amazon S3 Object
     * URL for the import file, and more.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeImportTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.DescribeImportTasks
     */
    default CompletableFuture<DescribeImportTasksResponse> describeImportTasks() {
        return describeImportTasks(DescribeImportTasksRequest.builder().build());
    }

    /**
     * <p>
     * Returns an array of import tasks for your account, including status information, times, IDs, the Amazon S3 Object
     * URL for the import file, and more.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeImportTasks(software.amazon.awssdk.services.applicationdiscovery.model.DescribeImportTasksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationdiscovery.paginators.DescribeImportTasksPublisher publisher = client.describeImportTasksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationdiscovery.paginators.DescribeImportTasksPublisher publisher = client.describeImportTasksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.applicationdiscovery.model.DescribeImportTasksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.applicationdiscovery.model.DescribeImportTasksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeImportTasks(software.amazon.awssdk.services.applicationdiscovery.model.DescribeImportTasksRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.DescribeImportTasks
     */
    default DescribeImportTasksPublisher describeImportTasksPaginator() {
        return describeImportTasksPaginator(DescribeImportTasksRequest.builder().build());
    }

    /**
     * <p>
     * Returns an array of import tasks for your account, including status information, times, IDs, the Amazon S3 Object
     * URL for the import file, and more.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeImportTasks(software.amazon.awssdk.services.applicationdiscovery.model.DescribeImportTasksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationdiscovery.paginators.DescribeImportTasksPublisher publisher = client.describeImportTasksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationdiscovery.paginators.DescribeImportTasksPublisher publisher = client.describeImportTasksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.applicationdiscovery.model.DescribeImportTasksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.applicationdiscovery.model.DescribeImportTasksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeImportTasks(software.amazon.awssdk.services.applicationdiscovery.model.DescribeImportTasksRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeImportTasksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.DescribeImportTasks
     */
    default DescribeImportTasksPublisher describeImportTasksPaginator(DescribeImportTasksRequest describeImportTasksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of import tasks for your account, including status information, times, IDs, the Amazon S3 Object
     * URL for the import file, and more.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeImportTasks(software.amazon.awssdk.services.applicationdiscovery.model.DescribeImportTasksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationdiscovery.paginators.DescribeImportTasksPublisher publisher = client.describeImportTasksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationdiscovery.paginators.DescribeImportTasksPublisher publisher = client.describeImportTasksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.applicationdiscovery.model.DescribeImportTasksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.applicationdiscovery.model.DescribeImportTasksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeImportTasks(software.amazon.awssdk.services.applicationdiscovery.model.DescribeImportTasksRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeImportTasksRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeImportTasksRequest#builder()}
     * </p>
     *
     * @param describeImportTasksRequest
     *        A {@link Consumer} that will call methods on {@link DescribeImportTasksRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.DescribeImportTasks
     */
    default DescribeImportTasksPublisher describeImportTasksPaginator(
            Consumer<DescribeImportTasksRequest.Builder> describeImportTasksRequest) {
        return describeImportTasksPaginator(DescribeImportTasksRequest.builder().applyMutation(describeImportTasksRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list of configuration items that have tags as specified by the key-value pairs, name and value,
     * passed to the optional parameter <code>filters</code>.
     * </p>
     * <p>
     * There are three valid tag filter names:
     * </p>
     * <ul>
     * <li>
     * <p>
     * tagKey
     * </p>
     * </li>
     * <li>
     * <p>
     * tagValue
     * </p>
     * </li>
     * <li>
     * <p>
     * configurationId
     * </p>
     * </li>
     * </ul>
     * <p>
     * Also, all configuration items associated with your user account that have tags can be listed if you call
     * <code>DescribeTags</code> as is without passing any parameters.
     * </p>
     *
     * @param describeTagsRequest
     * @return A Java Future containing the result of the DescribeTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>ResourceNotFoundException The specified configuration ID was not located. Verify the configuration ID
     *         and try again.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.DescribeTags
     */
    default CompletableFuture<DescribeTagsResponse> describeTags(DescribeTagsRequest describeTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of configuration items that have tags as specified by the key-value pairs, name and value,
     * passed to the optional parameter <code>filters</code>.
     * </p>
     * <p>
     * There are three valid tag filter names:
     * </p>
     * <ul>
     * <li>
     * <p>
     * tagKey
     * </p>
     * </li>
     * <li>
     * <p>
     * tagValue
     * </p>
     * </li>
     * <li>
     * <p>
     * configurationId
     * </p>
     * </li>
     * </ul>
     * <p>
     * Also, all configuration items associated with your user account that have tags can be listed if you call
     * <code>DescribeTags</code> as is without passing any parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTagsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeTagsRequest#builder()}
     * </p>
     *
     * @param describeTagsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTagsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>ResourceNotFoundException The specified configuration ID was not located. Verify the configuration ID
     *         and try again.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.DescribeTags
     */
    default CompletableFuture<DescribeTagsResponse> describeTags(Consumer<DescribeTagsRequest.Builder> describeTagsRequest) {
        return describeTags(DescribeTagsRequest.builder().applyMutation(describeTagsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of configuration items that have tags as specified by the key-value pairs, name and value,
     * passed to the optional parameter <code>filters</code>.
     * </p>
     * <p>
     * There are three valid tag filter names:
     * </p>
     * <ul>
     * <li>
     * <p>
     * tagKey
     * </p>
     * </li>
     * <li>
     * <p>
     * tagValue
     * </p>
     * </li>
     * <li>
     * <p>
     * configurationId
     * </p>
     * </li>
     * </ul>
     * <p>
     * Also, all configuration items associated with your user account that have tags can be listed if you call
     * <code>DescribeTags</code> as is without passing any parameters.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>ResourceNotFoundException The specified configuration ID was not located. Verify the configuration ID
     *         and try again.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.DescribeTags
     */
    default CompletableFuture<DescribeTagsResponse> describeTags() {
        return describeTags(DescribeTagsRequest.builder().build());
    }

    /**
     * <p>
     * Disassociates one or more configuration items from an application.
     * </p>
     *
     * @param disassociateConfigurationItemsFromApplicationRequest
     * @return A Java Future containing the result of the DisassociateConfigurationItemsFromApplication operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.DisassociateConfigurationItemsFromApplication
     */
    default CompletableFuture<DisassociateConfigurationItemsFromApplicationResponse> disassociateConfigurationItemsFromApplication(
            DisassociateConfigurationItemsFromApplicationRequest disassociateConfigurationItemsFromApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates one or more configuration items from an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateConfigurationItemsFromApplicationRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateConfigurationItemsFromApplicationRequest#builder()}
     * </p>
     *
     * @param disassociateConfigurationItemsFromApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DisassociateConfigurationItemsFromApplicationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DisassociateConfigurationItemsFromApplication operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.DisassociateConfigurationItemsFromApplication
     */
    default CompletableFuture<DisassociateConfigurationItemsFromApplicationResponse> disassociateConfigurationItemsFromApplication(
            Consumer<DisassociateConfigurationItemsFromApplicationRequest.Builder> disassociateConfigurationItemsFromApplicationRequest) {
        return disassociateConfigurationItemsFromApplication(DisassociateConfigurationItemsFromApplicationRequest.builder()
                .applyMutation(disassociateConfigurationItemsFromApplicationRequest).build());
    }

    /**
     * <p>
     * Retrieves a short summary of discovered assets.
     * </p>
     * <p>
     * This API operation takes no request parameters and is called as is at the command prompt as shown in the example.
     * </p>
     *
     * @param getDiscoverySummaryRequest
     * @return A Java Future containing the result of the GetDiscoverySummary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.GetDiscoverySummary
     */
    default CompletableFuture<GetDiscoverySummaryResponse> getDiscoverySummary(
            GetDiscoverySummaryRequest getDiscoverySummaryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a short summary of discovered assets.
     * </p>
     * <p>
     * This API operation takes no request parameters and is called as is at the command prompt as shown in the example.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDiscoverySummaryRequest.Builder} avoiding the
     * need to create one manually via {@link GetDiscoverySummaryRequest#builder()}
     * </p>
     *
     * @param getDiscoverySummaryRequest
     *        A {@link Consumer} that will call methods on {@link GetDiscoverySummaryRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetDiscoverySummary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.GetDiscoverySummary
     */
    default CompletableFuture<GetDiscoverySummaryResponse> getDiscoverySummary(
            Consumer<GetDiscoverySummaryRequest.Builder> getDiscoverySummaryRequest) {
        return getDiscoverySummary(GetDiscoverySummaryRequest.builder().applyMutation(getDiscoverySummaryRequest).build());
    }

    /**
     * <p>
     * Retrieves a short summary of discovered assets.
     * </p>
     * <p>
     * This API operation takes no request parameters and is called as is at the command prompt as shown in the example.
     * </p>
     *
     * @return A Java Future containing the result of the GetDiscoverySummary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.GetDiscoverySummary
     */
    default CompletableFuture<GetDiscoverySummaryResponse> getDiscoverySummary() {
        return getDiscoverySummary(GetDiscoverySummaryRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves a list of configuration items as specified by the value passed to the required parameter
     * <code>configurationType</code>. Optional filtering may be applied to refine search results.
     * </p>
     *
     * @param listConfigurationsRequest
     * @return A Java Future containing the result of the ListConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>ResourceNotFoundException The specified configuration ID was not located. Verify the configuration ID
     *         and try again.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.ListConfigurations
     */
    default CompletableFuture<ListConfigurationsResponse> listConfigurations(ListConfigurationsRequest listConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of configuration items as specified by the value passed to the required parameter
     * <code>configurationType</code>. Optional filtering may be applied to refine search results.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfigurationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListConfigurationsRequest#builder()}
     * </p>
     *
     * @param listConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link ListConfigurationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>ResourceNotFoundException The specified configuration ID was not located. Verify the configuration ID
     *         and try again.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.ListConfigurations
     */
    default CompletableFuture<ListConfigurationsResponse> listConfigurations(
            Consumer<ListConfigurationsRequest.Builder> listConfigurationsRequest) {
        return listConfigurations(ListConfigurationsRequest.builder().applyMutation(listConfigurationsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of servers that are one network hop away from a specified server.
     * </p>
     *
     * @param listServerNeighborsRequest
     * @return A Java Future containing the result of the ListServerNeighbors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.ListServerNeighbors
     */
    default CompletableFuture<ListServerNeighborsResponse> listServerNeighbors(
            ListServerNeighborsRequest listServerNeighborsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of servers that are one network hop away from a specified server.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServerNeighborsRequest.Builder} avoiding the
     * need to create one manually via {@link ListServerNeighborsRequest#builder()}
     * </p>
     *
     * @param listServerNeighborsRequest
     *        A {@link Consumer} that will call methods on {@link ListServerNeighborsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListServerNeighbors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.ListServerNeighbors
     */
    default CompletableFuture<ListServerNeighborsResponse> listServerNeighbors(
            Consumer<ListServerNeighborsRequest.Builder> listServerNeighborsRequest) {
        return listServerNeighbors(ListServerNeighborsRequest.builder().applyMutation(listServerNeighborsRequest).build());
    }

    /**
     * <p>
     * Start the continuous flow of agent's discovered data into Amazon Athena.
     * </p>
     *
     * @param startContinuousExportRequest
     * @return A Java Future containing the result of the StartContinuousExport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictErrorException</li>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>OperationNotPermittedException This operation is not permitted.</li>
     *         <li>ResourceInUseException This issue occurs when the same <code>clientRequestToken</code> is used with
     *         the <code>StartImportTask</code> action, but with different parameters. For example, you use the same
     *         request token but have two different import URLs, you can encounter this issue. If the import tasks are
     *         meant to be different, use a different <code>clientRequestToken</code>, and try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.StartContinuousExport
     */
    default CompletableFuture<StartContinuousExportResponse> startContinuousExport(
            StartContinuousExportRequest startContinuousExportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Start the continuous flow of agent's discovered data into Amazon Athena.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartContinuousExportRequest.Builder} avoiding the
     * need to create one manually via {@link StartContinuousExportRequest#builder()}
     * </p>
     *
     * @param startContinuousExportRequest
     *        A {@link Consumer} that will call methods on {@link StartContinuousExportRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartContinuousExport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictErrorException</li>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>OperationNotPermittedException This operation is not permitted.</li>
     *         <li>ResourceInUseException This issue occurs when the same <code>clientRequestToken</code> is used with
     *         the <code>StartImportTask</code> action, but with different parameters. For example, you use the same
     *         request token but have two different import URLs, you can encounter this issue. If the import tasks are
     *         meant to be different, use a different <code>clientRequestToken</code>, and try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.StartContinuousExport
     */
    default CompletableFuture<StartContinuousExportResponse> startContinuousExport(
            Consumer<StartContinuousExportRequest.Builder> startContinuousExportRequest) {
        return startContinuousExport(StartContinuousExportRequest.builder().applyMutation(startContinuousExportRequest).build());
    }

    /**
     * <p>
     * Instructs the specified agents or connectors to start collecting data.
     * </p>
     *
     * @param startDataCollectionByAgentIdsRequest
     * @return A Java Future containing the result of the StartDataCollectionByAgentIds operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.StartDataCollectionByAgentIds
     */
    default CompletableFuture<StartDataCollectionByAgentIdsResponse> startDataCollectionByAgentIds(
            StartDataCollectionByAgentIdsRequest startDataCollectionByAgentIdsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Instructs the specified agents or connectors to start collecting data.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartDataCollectionByAgentIdsRequest.Builder}
     * avoiding the need to create one manually via {@link StartDataCollectionByAgentIdsRequest#builder()}
     * </p>
     *
     * @param startDataCollectionByAgentIdsRequest
     *        A {@link Consumer} that will call methods on {@link StartDataCollectionByAgentIdsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the StartDataCollectionByAgentIds operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.StartDataCollectionByAgentIds
     */
    default CompletableFuture<StartDataCollectionByAgentIdsResponse> startDataCollectionByAgentIds(
            Consumer<StartDataCollectionByAgentIdsRequest.Builder> startDataCollectionByAgentIdsRequest) {
        return startDataCollectionByAgentIds(StartDataCollectionByAgentIdsRequest.builder()
                .applyMutation(startDataCollectionByAgentIdsRequest).build());
    }

    /**
     * <p>
     * Begins the export of discovered data to an S3 bucket.
     * </p>
     * <p>
     * If you specify <code>agentIds</code> in a filter, the task exports up to 72 hours of detailed data collected by
     * the identified Application Discovery Agent, including network, process, and performance details. A time range for
     * exported agent data may be set by using <code>startTime</code> and <code>endTime</code>. Export of detailed agent
     * data is limited to five concurrently running exports.
     * </p>
     * <p>
     * If you do not include an <code>agentIds</code> filter, summary data is exported that includes both AWS Agentless
     * Discovery Connector data and summary data from AWS Discovery Agents. Export of summary data is limited to two
     * exports per day.
     * </p>
     *
     * @param startExportTaskRequest
     * @return A Java Future containing the result of the StartExportTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>OperationNotPermittedException This operation is not permitted.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.StartExportTask
     */
    default CompletableFuture<StartExportTaskResponse> startExportTask(StartExportTaskRequest startExportTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Begins the export of discovered data to an S3 bucket.
     * </p>
     * <p>
     * If you specify <code>agentIds</code> in a filter, the task exports up to 72 hours of detailed data collected by
     * the identified Application Discovery Agent, including network, process, and performance details. A time range for
     * exported agent data may be set by using <code>startTime</code> and <code>endTime</code>. Export of detailed agent
     * data is limited to five concurrently running exports.
     * </p>
     * <p>
     * If you do not include an <code>agentIds</code> filter, summary data is exported that includes both AWS Agentless
     * Discovery Connector data and summary data from AWS Discovery Agents. Export of summary data is limited to two
     * exports per day.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartExportTaskRequest.Builder} avoiding the need
     * to create one manually via {@link StartExportTaskRequest#builder()}
     * </p>
     *
     * @param startExportTaskRequest
     *        A {@link Consumer} that will call methods on {@link StartExportTaskRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartExportTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>OperationNotPermittedException This operation is not permitted.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.StartExportTask
     */
    default CompletableFuture<StartExportTaskResponse> startExportTask(
            Consumer<StartExportTaskRequest.Builder> startExportTaskRequest) {
        return startExportTask(StartExportTaskRequest.builder().applyMutation(startExportTaskRequest).build());
    }

    /**
     * <p>
     * Begins the export of discovered data to an S3 bucket.
     * </p>
     * <p>
     * If you specify <code>agentIds</code> in a filter, the task exports up to 72 hours of detailed data collected by
     * the identified Application Discovery Agent, including network, process, and performance details. A time range for
     * exported agent data may be set by using <code>startTime</code> and <code>endTime</code>. Export of detailed agent
     * data is limited to five concurrently running exports.
     * </p>
     * <p>
     * If you do not include an <code>agentIds</code> filter, summary data is exported that includes both AWS Agentless
     * Discovery Connector data and summary data from AWS Discovery Agents. Export of summary data is limited to two
     * exports per day.
     * </p>
     *
     * @return A Java Future containing the result of the StartExportTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>OperationNotPermittedException This operation is not permitted.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.StartExportTask
     */
    default CompletableFuture<StartExportTaskResponse> startExportTask() {
        return startExportTask(StartExportTaskRequest.builder().build());
    }

    /**
     * <p>
     * Starts an import task, which allows you to import details of your on-premises environment directly into AWS
     * Migration Hub without having to use the Application Discovery Service (ADS) tools such as the Discovery Connector
     * or Discovery Agent. This gives you the option to perform migration assessment and planning directly from your
     * imported data, including the ability to group your devices as applications and track their migration status.
     * </p>
     * <p>
     * To start an import request, do this:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Download the specially formatted comma separated value (CSV) import template, which you can find here: <a
     * href="https://s3-us-west-2.amazonaws.com/templates-7cffcf56-bd96-4b1c-b45b-a5b42f282e46/import_template.csv"
     * >https://s3-us-west-2.amazonaws.com/templates-7cffcf56-bd96-4b1c-b45b-a5b42f282e46/import_template.csv</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Fill out the template with your server and application data.
     * </p>
     * </li>
     * <li>
     * <p>
     * Upload your import file to an Amazon S3 bucket, and make a note of it's Object URL. Your import file must be in
     * the CSV format.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the console or the <code>StartImportTask</code> command with the AWS CLI or one of the AWS SDKs to import the
     * records from your file.
     * </p>
     * </li>
     * </ol>
     * <p>
     * For more information, including step-by-step procedures, see <a
     * href="https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-import.html">Migration Hub
     * Import</a> in the <i>AWS Application Discovery Service User Guide</i>.
     * </p>
     * <note>
     * <p>
     * There are limits to the number of import tasks you can create (and delete) in an AWS account. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/application-discovery/latest/userguide/ads_service_limits.html">AWS Application
     * Discovery Service Limits</a> in the <i>AWS Application Discovery Service User Guide</i>.
     * </p>
     * </note>
     *
     * @param startImportTaskRequest
     * @return A Java Future containing the result of the StartImportTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException This issue occurs when the same <code>clientRequestToken</code> is used with
     *         the <code>StartImportTask</code> action, but with different parameters. For example, you use the same
     *         request token but have two different import URLs, you can encounter this issue. If the import tasks are
     *         meant to be different, use a different <code>clientRequestToken</code>, and try again.</li>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.StartImportTask
     */
    default CompletableFuture<StartImportTaskResponse> startImportTask(StartImportTaskRequest startImportTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an import task, which allows you to import details of your on-premises environment directly into AWS
     * Migration Hub without having to use the Application Discovery Service (ADS) tools such as the Discovery Connector
     * or Discovery Agent. This gives you the option to perform migration assessment and planning directly from your
     * imported data, including the ability to group your devices as applications and track their migration status.
     * </p>
     * <p>
     * To start an import request, do this:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Download the specially formatted comma separated value (CSV) import template, which you can find here: <a
     * href="https://s3-us-west-2.amazonaws.com/templates-7cffcf56-bd96-4b1c-b45b-a5b42f282e46/import_template.csv"
     * >https://s3-us-west-2.amazonaws.com/templates-7cffcf56-bd96-4b1c-b45b-a5b42f282e46/import_template.csv</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Fill out the template with your server and application data.
     * </p>
     * </li>
     * <li>
     * <p>
     * Upload your import file to an Amazon S3 bucket, and make a note of it's Object URL. Your import file must be in
     * the CSV format.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the console or the <code>StartImportTask</code> command with the AWS CLI or one of the AWS SDKs to import the
     * records from your file.
     * </p>
     * </li>
     * </ol>
     * <p>
     * For more information, including step-by-step procedures, see <a
     * href="https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-import.html">Migration Hub
     * Import</a> in the <i>AWS Application Discovery Service User Guide</i>.
     * </p>
     * <note>
     * <p>
     * There are limits to the number of import tasks you can create (and delete) in an AWS account. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/application-discovery/latest/userguide/ads_service_limits.html">AWS Application
     * Discovery Service Limits</a> in the <i>AWS Application Discovery Service User Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartImportTaskRequest.Builder} avoiding the need
     * to create one manually via {@link StartImportTaskRequest#builder()}
     * </p>
     *
     * @param startImportTaskRequest
     *        A {@link Consumer} that will call methods on {@link StartImportTaskRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartImportTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException This issue occurs when the same <code>clientRequestToken</code> is used with
     *         the <code>StartImportTask</code> action, but with different parameters. For example, you use the same
     *         request token but have two different import URLs, you can encounter this issue. If the import tasks are
     *         meant to be different, use a different <code>clientRequestToken</code>, and try again.</li>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.StartImportTask
     */
    default CompletableFuture<StartImportTaskResponse> startImportTask(
            Consumer<StartImportTaskRequest.Builder> startImportTaskRequest) {
        return startImportTask(StartImportTaskRequest.builder().applyMutation(startImportTaskRequest).build());
    }

    /**
     * <p>
     * Stop the continuous flow of agent's discovered data into Amazon Athena.
     * </p>
     *
     * @param stopContinuousExportRequest
     * @return A Java Future containing the result of the StopContinuousExport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>OperationNotPermittedException This operation is not permitted.</li>
     *         <li>ResourceNotFoundException The specified configuration ID was not located. Verify the configuration ID
     *         and try again.</li>
     *         <li>ResourceInUseException This issue occurs when the same <code>clientRequestToken</code> is used with
     *         the <code>StartImportTask</code> action, but with different parameters. For example, you use the same
     *         request token but have two different import URLs, you can encounter this issue. If the import tasks are
     *         meant to be different, use a different <code>clientRequestToken</code>, and try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.StopContinuousExport
     */
    default CompletableFuture<StopContinuousExportResponse> stopContinuousExport(
            StopContinuousExportRequest stopContinuousExportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stop the continuous flow of agent's discovered data into Amazon Athena.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopContinuousExportRequest.Builder} avoiding the
     * need to create one manually via {@link StopContinuousExportRequest#builder()}
     * </p>
     *
     * @param stopContinuousExportRequest
     *        A {@link Consumer} that will call methods on {@link StopContinuousExportRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StopContinuousExport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>OperationNotPermittedException This operation is not permitted.</li>
     *         <li>ResourceNotFoundException The specified configuration ID was not located. Verify the configuration ID
     *         and try again.</li>
     *         <li>ResourceInUseException This issue occurs when the same <code>clientRequestToken</code> is used with
     *         the <code>StartImportTask</code> action, but with different parameters. For example, you use the same
     *         request token but have two different import URLs, you can encounter this issue. If the import tasks are
     *         meant to be different, use a different <code>clientRequestToken</code>, and try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.StopContinuousExport
     */
    default CompletableFuture<StopContinuousExportResponse> stopContinuousExport(
            Consumer<StopContinuousExportRequest.Builder> stopContinuousExportRequest) {
        return stopContinuousExport(StopContinuousExportRequest.builder().applyMutation(stopContinuousExportRequest).build());
    }

    /**
     * <p>
     * Instructs the specified agents or connectors to stop collecting data.
     * </p>
     *
     * @param stopDataCollectionByAgentIdsRequest
     * @return A Java Future containing the result of the StopDataCollectionByAgentIds operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.StopDataCollectionByAgentIds
     */
    default CompletableFuture<StopDataCollectionByAgentIdsResponse> stopDataCollectionByAgentIds(
            StopDataCollectionByAgentIdsRequest stopDataCollectionByAgentIdsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Instructs the specified agents or connectors to stop collecting data.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopDataCollectionByAgentIdsRequest.Builder}
     * avoiding the need to create one manually via {@link StopDataCollectionByAgentIdsRequest#builder()}
     * </p>
     *
     * @param stopDataCollectionByAgentIdsRequest
     *        A {@link Consumer} that will call methods on {@link StopDataCollectionByAgentIdsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the StopDataCollectionByAgentIds operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.StopDataCollectionByAgentIds
     */
    default CompletableFuture<StopDataCollectionByAgentIdsResponse> stopDataCollectionByAgentIds(
            Consumer<StopDataCollectionByAgentIdsRequest.Builder> stopDataCollectionByAgentIdsRequest) {
        return stopDataCollectionByAgentIds(StopDataCollectionByAgentIdsRequest.builder()
                .applyMutation(stopDataCollectionByAgentIdsRequest).build());
    }

    /**
     * <p>
     * Updates metadata about an application.
     * </p>
     *
     * @param updateApplicationRequest
     * @return A Java Future containing the result of the UpdateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.UpdateApplication
     */
    default CompletableFuture<UpdateApplicationResponse> updateApplication(UpdateApplicationRequest updateApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates metadata about an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateApplicationRequest#builder()}
     * </p>
     *
     * @param updateApplicationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateApplicationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthorizationErrorException The AWS user account does not have permission to perform the action.
     *         Check the IAM policy associated with this account.</li>
     *         <li>InvalidParameterException One or more parameters are not valid. Verify the parameters and try again.</li>
     *         <li>InvalidParameterValueException The value of one or more parameters are either invalid or out of
     *         range. Verify the parameter values and try again.</li>
     *         <li>ServerInternalErrorException The server experienced an internal error. Try again.</li>
     *         <li>HomeRegionNotSetException The home region is not set. Set the home region to continue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationDiscoveryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationDiscoveryAsyncClient.UpdateApplication
     */
    default CompletableFuture<UpdateApplicationResponse> updateApplication(
            Consumer<UpdateApplicationRequest.Builder> updateApplicationRequest) {
        return updateApplication(UpdateApplicationRequest.builder().applyMutation(updateApplicationRequest).build());
    }
}
