/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.applicationdiscovery.model.NeighborConnectionDetail;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class NeighborConnectionDetailMarshaller {
    private static final MarshallingInfo<String> SOURCESERVERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sourceServerId").isBinary(false).build();
    private static final MarshallingInfo<String> DESTINATIONSERVERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("destinationServerId").isBinary(false).build();
    private static final MarshallingInfo<Integer> DESTINATIONPORT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("destinationPort").isBinary(false).build();
    private static final MarshallingInfo<String> TRANSPORTPROTOCOL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("transportProtocol").isBinary(false).build();
    private static final MarshallingInfo<Long> CONNECTIONSCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("connectionsCount").isBinary(false).build();
    private static final NeighborConnectionDetailMarshaller INSTANCE = new NeighborConnectionDetailMarshaller();

    private NeighborConnectionDetailMarshaller() {
    }

    public static NeighborConnectionDetailMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(NeighborConnectionDetail neighborConnectionDetail, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)neighborConnectionDetail, (String)"neighborConnectionDetail");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)neighborConnectionDetail.sourceServerId(), SOURCESERVERID_BINDING);
            protocolMarshaller.marshall((Object)neighborConnectionDetail.destinationServerId(), DESTINATIONSERVERID_BINDING);
            protocolMarshaller.marshall((Object)neighborConnectionDetail.destinationPort(), DESTINATIONPORT_BINDING);
            protocolMarshaller.marshall((Object)neighborConnectionDetail.transportProtocol(), TRANSPORTPROTOCOL_BINDING);
            protocolMarshaller.marshall((Object)neighborConnectionDetail.connectionsCount(), CONNECTIONSCOUNT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

