/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.applicationdiscovery.model.ConfigurationTag;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ConfigurationTagMarshaller {
    private static final MarshallingInfo<String> CONFIGURATIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("configurationType").isBinary(false).build();
    private static final MarshallingInfo<String> CONFIGURATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("configurationId").isBinary(false).build();
    private static final MarshallingInfo<String> KEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("key").isBinary(false).build();
    private static final MarshallingInfo<String> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("value").isBinary(false).build();
    private static final MarshallingInfo<Instant> TIMEOFCREATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timeOfCreation").isBinary(false).build();
    private static final ConfigurationTagMarshaller INSTANCE = new ConfigurationTagMarshaller();

    private ConfigurationTagMarshaller() {
    }

    public static ConfigurationTagMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ConfigurationTag configurationTag, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)configurationTag, (String)"configurationTag");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)configurationTag.configurationTypeAsString(), CONFIGURATIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)configurationTag.configurationId(), CONFIGURATIONID_BINDING);
            protocolMarshaller.marshall((Object)configurationTag.key(), KEY_BINDING);
            protocolMarshaller.marshall((Object)configurationTag.value(), VALUE_BINDING);
            protocolMarshaller.marshall((Object)configurationTag.timeOfCreation(), TIMEOFCREATION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

