/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.applicationdiscovery.model.AgentNetworkInfo;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AgentNetworkInfoMarshaller {
    private static final MarshallingInfo<String> IPADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ipAddress").isBinary(false).build();
    private static final MarshallingInfo<String> MACADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("macAddress").isBinary(false).build();
    private static final AgentNetworkInfoMarshaller INSTANCE = new AgentNetworkInfoMarshaller();

    private AgentNetworkInfoMarshaller() {
    }

    public static AgentNetworkInfoMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AgentNetworkInfo agentNetworkInfo, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)agentNetworkInfo, (String)"agentNetworkInfo");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)agentNetworkInfo.ipAddress(), IPADDRESS_BINDING);
            protocolMarshaller.marshall((Object)agentNetworkInfo.macAddress(), MACADDRESS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

