/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.applicationdiscovery.model.AgentInfo;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AgentInfoMarshaller {
    private static final MarshallingInfo<String> AGENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("agentId").isBinary(false).build();
    private static final MarshallingInfo<String> HOSTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hostName").isBinary(false).build();
    private static final MarshallingInfo<List> AGENTNETWORKINFOLIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("agentNetworkInfoList").isBinary(false).build();
    private static final MarshallingInfo<String> CONNECTORID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("connectorId").isBinary(false).build();
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("version").isBinary(false).build();
    private static final MarshallingInfo<String> HEALTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("health").isBinary(false).build();
    private static final MarshallingInfo<String> LASTHEALTHPINGTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastHealthPingTime").isBinary(false).build();
    private static final MarshallingInfo<String> COLLECTIONSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("collectionStatus").isBinary(false).build();
    private static final MarshallingInfo<String> AGENTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("agentType").isBinary(false).build();
    private static final MarshallingInfo<String> REGISTEREDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("registeredTime").isBinary(false).build();
    private static final AgentInfoMarshaller INSTANCE = new AgentInfoMarshaller();

    private AgentInfoMarshaller() {
    }

    public static AgentInfoMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AgentInfo agentInfo, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)agentInfo, (String)"agentInfo");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)agentInfo.agentId(), AGENTID_BINDING);
            protocolMarshaller.marshall((Object)agentInfo.hostName(), HOSTNAME_BINDING);
            protocolMarshaller.marshall(agentInfo.agentNetworkInfoList(), AGENTNETWORKINFOLIST_BINDING);
            protocolMarshaller.marshall((Object)agentInfo.connectorId(), CONNECTORID_BINDING);
            protocolMarshaller.marshall((Object)agentInfo.version(), VERSION_BINDING);
            protocolMarshaller.marshall((Object)agentInfo.healthAsString(), HEALTH_BINDING);
            protocolMarshaller.marshall((Object)agentInfo.lastHealthPingTime(), LASTHEALTHPINGTIME_BINDING);
            protocolMarshaller.marshall((Object)agentInfo.collectionStatus(), COLLECTIONSTATUS_BINDING);
            protocolMarshaller.marshall((Object)agentInfo.agentType(), AGENTTYPE_BINDING);
            protocolMarshaller.marshall((Object)agentInfo.registeredTime(), REGISTEREDTIME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

