/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.applicationdiscovery.model.AgentConfigurationStatus;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AgentConfigurationStatusMarshaller {
    private static final MarshallingInfo<String> AGENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("agentId").isBinary(false).build();
    private static final MarshallingInfo<Boolean> OPERATIONSUCCEEDED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("operationSucceeded").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final AgentConfigurationStatusMarshaller INSTANCE = new AgentConfigurationStatusMarshaller();

    private AgentConfigurationStatusMarshaller() {
    }

    public static AgentConfigurationStatusMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AgentConfigurationStatus agentConfigurationStatus, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)agentConfigurationStatus, (String)"agentConfigurationStatus");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)agentConfigurationStatus.agentId(), AGENTID_BINDING);
            protocolMarshaller.marshall((Object)agentConfigurationStatus.operationSucceeded(), OPERATIONSUCCEEDED_BINDING);
            protocolMarshaller.marshall((Object)agentConfigurationStatus.description(), DESCRIPTION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

