/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.applicationdiscovery.transform.NeighborConnectionDetailMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NeighborConnectionDetail
implements StructuredPojo,
ToCopyableBuilder<Builder, NeighborConnectionDetail> {
    private final String sourceServerId;
    private final String destinationServerId;
    private final Integer destinationPort;
    private final String transportProtocol;
    private final Long connectionsCount;

    private NeighborConnectionDetail(BuilderImpl builder) {
        this.sourceServerId = builder.sourceServerId;
        this.destinationServerId = builder.destinationServerId;
        this.destinationPort = builder.destinationPort;
        this.transportProtocol = builder.transportProtocol;
        this.connectionsCount = builder.connectionsCount;
    }

    public String sourceServerId() {
        return this.sourceServerId;
    }

    public String destinationServerId() {
        return this.destinationServerId;
    }

    public Integer destinationPort() {
        return this.destinationPort;
    }

    public String transportProtocol() {
        return this.transportProtocol;
    }

    public Long connectionsCount() {
        return this.connectionsCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceServerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationServerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.transportProtocol());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionsCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NeighborConnectionDetail)) {
            return false;
        }
        NeighborConnectionDetail other = (NeighborConnectionDetail)obj;
        return Objects.equals(this.sourceServerId(), other.sourceServerId()) && Objects.equals(this.destinationServerId(), other.destinationServerId()) && Objects.equals(this.destinationPort(), other.destinationPort()) && Objects.equals(this.transportProtocol(), other.transportProtocol()) && Objects.equals(this.connectionsCount(), other.connectionsCount());
    }

    public String toString() {
        return ToString.builder((String)"NeighborConnectionDetail").add("SourceServerId", (Object)this.sourceServerId()).add("DestinationServerId", (Object)this.destinationServerId()).add("DestinationPort", (Object)this.destinationPort()).add("TransportProtocol", (Object)this.transportProtocol()).add("ConnectionsCount", (Object)this.connectionsCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sourceServerId": {
                return Optional.ofNullable(clazz.cast(this.sourceServerId()));
            }
            case "destinationServerId": {
                return Optional.ofNullable(clazz.cast(this.destinationServerId()));
            }
            case "destinationPort": {
                return Optional.ofNullable(clazz.cast(this.destinationPort()));
            }
            case "transportProtocol": {
                return Optional.ofNullable(clazz.cast(this.transportProtocol()));
            }
            case "connectionsCount": {
                return Optional.ofNullable(clazz.cast(this.connectionsCount()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NeighborConnectionDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceServerId;
        private String destinationServerId;
        private Integer destinationPort;
        private String transportProtocol;
        private Long connectionsCount;

        private BuilderImpl() {
        }

        private BuilderImpl(NeighborConnectionDetail model) {
            this.sourceServerId(model.sourceServerId);
            this.destinationServerId(model.destinationServerId);
            this.destinationPort(model.destinationPort);
            this.transportProtocol(model.transportProtocol);
            this.connectionsCount(model.connectionsCount);
        }

        public final String getSourceServerId() {
            return this.sourceServerId;
        }

        @Override
        public final Builder sourceServerId(String sourceServerId) {
            this.sourceServerId = sourceServerId;
            return this;
        }

        public final void setSourceServerId(String sourceServerId) {
            this.sourceServerId = sourceServerId;
        }

        public final String getDestinationServerId() {
            return this.destinationServerId;
        }

        @Override
        public final Builder destinationServerId(String destinationServerId) {
            this.destinationServerId = destinationServerId;
            return this;
        }

        public final void setDestinationServerId(String destinationServerId) {
            this.destinationServerId = destinationServerId;
        }

        public final Integer getDestinationPort() {
            return this.destinationPort;
        }

        @Override
        public final Builder destinationPort(Integer destinationPort) {
            this.destinationPort = destinationPort;
            return this;
        }

        public final void setDestinationPort(Integer destinationPort) {
            this.destinationPort = destinationPort;
        }

        public final String getTransportProtocol() {
            return this.transportProtocol;
        }

        @Override
        public final Builder transportProtocol(String transportProtocol) {
            this.transportProtocol = transportProtocol;
            return this;
        }

        public final void setTransportProtocol(String transportProtocol) {
            this.transportProtocol = transportProtocol;
        }

        public final Long getConnectionsCount() {
            return this.connectionsCount;
        }

        @Override
        public final Builder connectionsCount(Long connectionsCount) {
            this.connectionsCount = connectionsCount;
            return this;
        }

        public final void setConnectionsCount(Long connectionsCount) {
            this.connectionsCount = connectionsCount;
        }

        public NeighborConnectionDetail build() {
            return new NeighborConnectionDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NeighborConnectionDetail> {
        public Builder sourceServerId(String var1);

        public Builder destinationServerId(String var1);

        public Builder destinationPort(Integer var1);

        public Builder transportProtocol(String var1);

        public Builder connectionsCount(Long var1);
    }
}

