/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.applicationdiscovery.model.ApplicationDiscoveryRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.ConfigurationItemType;
import software.amazon.awssdk.services.applicationdiscovery.model.Filter;
import software.amazon.awssdk.services.applicationdiscovery.model.FiltersCopier;
import software.amazon.awssdk.services.applicationdiscovery.model.OrderByElement;
import software.amazon.awssdk.services.applicationdiscovery.model.OrderByListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListConfigurationsRequest
extends ApplicationDiscoveryRequest
implements ToCopyableBuilder<Builder, ListConfigurationsRequest> {
    private final String configurationType;
    private final List<Filter> filters;
    private final Integer maxResults;
    private final String nextToken;
    private final List<OrderByElement> orderBy;

    private ListConfigurationsRequest(BuilderImpl builder) {
        super(builder);
        this.configurationType = builder.configurationType;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.orderBy = builder.orderBy;
    }

    public ConfigurationItemType configurationType() {
        return ConfigurationItemType.fromValue(this.configurationType);
    }

    public String configurationTypeAsString() {
        return this.configurationType;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<OrderByElement> orderBy() {
        return this.orderBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.orderBy());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConfigurationsRequest)) {
            return false;
        }
        ListConfigurationsRequest other = (ListConfigurationsRequest)((Object)obj);
        return Objects.equals(this.configurationTypeAsString(), other.configurationTypeAsString()) && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.orderBy(), other.orderBy());
    }

    public String toString() {
        return ToString.builder((String)"ListConfigurationsRequest").add("ConfigurationType", (Object)this.configurationTypeAsString()).add("Filters", this.filters()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("OrderBy", this.orderBy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "configurationType": {
                return Optional.ofNullable(clazz.cast(this.configurationTypeAsString()));
            }
            case "filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "orderBy": {
                return Optional.ofNullable(clazz.cast(this.orderBy()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ApplicationDiscoveryRequest.BuilderImpl
    implements Builder {
        private String configurationType;
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;
        private List<OrderByElement> orderBy = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListConfigurationsRequest model) {
            super(model);
            this.configurationType(model.configurationType);
            this.filters(model.filters);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.orderBy(model.orderBy);
        }

        public final String getConfigurationType() {
            return this.configurationType;
        }

        @Override
        public final Builder configurationType(String configurationType) {
            this.configurationType = configurationType;
            return this;
        }

        @Override
        public final Builder configurationType(ConfigurationItemType configurationType) {
            this.configurationType(configurationType.toString());
            return this;
        }

        public final void setConfigurationType(String configurationType) {
            this.configurationType = configurationType;
        }

        public final Collection<Filter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FiltersCopier.copyFromBuilder(filters);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<OrderByElement.Builder> getOrderBy() {
            return this.orderBy != null ? (Collection)this.orderBy.stream().map(OrderByElement::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder orderBy(Collection<OrderByElement> orderBy) {
            this.orderBy = OrderByListCopier.copy(orderBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderBy(OrderByElement ... orderBy) {
            this.orderBy(Arrays.asList(orderBy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderBy(Consumer<OrderByElement.Builder> ... orderBy) {
            this.orderBy(Stream.of(orderBy).map(c -> (OrderByElement)((OrderByElement.Builder)OrderByElement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOrderBy(Collection<OrderByElement.BuilderImpl> orderBy) {
            this.orderBy = OrderByListCopier.copyFromBuilder(orderBy);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListConfigurationsRequest build() {
            return new ListConfigurationsRequest(this);
        }
    }

    public static interface Builder
    extends ApplicationDiscoveryRequest.Builder,
    CopyableBuilder<Builder, ListConfigurationsRequest> {
        public Builder configurationType(String var1);

        public Builder configurationType(ConfigurationItemType var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder orderBy(Collection<OrderByElement> var1);

        public Builder orderBy(OrderByElement ... var1);

        public Builder orderBy(Consumer<OrderByElement.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

