/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.model;

import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.applicationdiscovery.model.ContinuousExportStatus;
import software.amazon.awssdk.services.applicationdiscovery.model.DataSource;
import software.amazon.awssdk.services.applicationdiscovery.model.SchemaStorageConfigCopier;
import software.amazon.awssdk.services.applicationdiscovery.transform.ContinuousExportDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContinuousExportDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, ContinuousExportDescription> {
    private final String exportId;
    private final String status;
    private final String statusDetail;
    private final String s3Bucket;
    private final Instant startTime;
    private final Instant stopTime;
    private final String dataSource;
    private final Map<String, String> schemaStorageConfig;

    private ContinuousExportDescription(BuilderImpl builder) {
        this.exportId = builder.exportId;
        this.status = builder.status;
        this.statusDetail = builder.statusDetail;
        this.s3Bucket = builder.s3Bucket;
        this.startTime = builder.startTime;
        this.stopTime = builder.stopTime;
        this.dataSource = builder.dataSource;
        this.schemaStorageConfig = builder.schemaStorageConfig;
    }

    public String exportId() {
        return this.exportId;
    }

    public ContinuousExportStatus status() {
        return ContinuousExportStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String statusDetail() {
        return this.statusDetail;
    }

    public String s3Bucket() {
        return this.s3Bucket;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant stopTime() {
        return this.stopTime;
    }

    public DataSource dataSource() {
        return DataSource.fromValue(this.dataSource);
    }

    public String dataSourceAsString() {
        return this.dataSource;
    }

    public Map<String, String> schemaStorageConfig() {
        return this.schemaStorageConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.exportId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.stopTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaStorageConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContinuousExportDescription)) {
            return false;
        }
        ContinuousExportDescription other = (ContinuousExportDescription)obj;
        return Objects.equals(this.exportId(), other.exportId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusDetail(), other.statusDetail()) && Objects.equals(this.s3Bucket(), other.s3Bucket()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.stopTime(), other.stopTime()) && Objects.equals(this.dataSourceAsString(), other.dataSourceAsString()) && Objects.equals(this.schemaStorageConfig(), other.schemaStorageConfig());
    }

    public String toString() {
        return ToString.builder((String)"ContinuousExportDescription").add("ExportId", (Object)this.exportId()).add("Status", (Object)this.statusAsString()).add("StatusDetail", (Object)this.statusDetail()).add("S3Bucket", (Object)this.s3Bucket()).add("StartTime", (Object)this.startTime()).add("StopTime", (Object)this.stopTime()).add("DataSource", (Object)this.dataSourceAsString()).add("SchemaStorageConfig", this.schemaStorageConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "exportId": {
                return Optional.ofNullable(clazz.cast(this.exportId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusDetail": {
                return Optional.ofNullable(clazz.cast(this.statusDetail()));
            }
            case "s3Bucket": {
                return Optional.ofNullable(clazz.cast(this.s3Bucket()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "stopTime": {
                return Optional.ofNullable(clazz.cast(this.stopTime()));
            }
            case "dataSource": {
                return Optional.ofNullable(clazz.cast(this.dataSourceAsString()));
            }
            case "schemaStorageConfig": {
                return Optional.ofNullable(clazz.cast(this.schemaStorageConfig()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ContinuousExportDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String exportId;
        private String status;
        private String statusDetail;
        private String s3Bucket;
        private Instant startTime;
        private Instant stopTime;
        private String dataSource;
        private Map<String, String> schemaStorageConfig = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ContinuousExportDescription model) {
            this.exportId(model.exportId);
            this.status(model.status);
            this.statusDetail(model.statusDetail);
            this.s3Bucket(model.s3Bucket);
            this.startTime(model.startTime);
            this.stopTime(model.stopTime);
            this.dataSource(model.dataSource);
            this.schemaStorageConfig(model.schemaStorageConfig);
        }

        public final String getExportId() {
            return this.exportId;
        }

        @Override
        public final Builder exportId(String exportId) {
            this.exportId = exportId;
            return this;
        }

        public final void setExportId(String exportId) {
            this.exportId = exportId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ContinuousExportStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusDetail() {
            return this.statusDetail;
        }

        @Override
        public final Builder statusDetail(String statusDetail) {
            this.statusDetail = statusDetail;
            return this;
        }

        public final void setStatusDetail(String statusDetail) {
            this.statusDetail = statusDetail;
        }

        public final String getS3Bucket() {
            return this.s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getStopTime() {
            return this.stopTime;
        }

        @Override
        public final Builder stopTime(Instant stopTime) {
            this.stopTime = stopTime;
            return this;
        }

        public final void setStopTime(Instant stopTime) {
            this.stopTime = stopTime;
        }

        public final String getDataSource() {
            return this.dataSource;
        }

        @Override
        public final Builder dataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        @Override
        public final Builder dataSource(DataSource dataSource) {
            this.dataSource(dataSource.toString());
            return this;
        }

        public final void setDataSource(String dataSource) {
            this.dataSource = dataSource;
        }

        public final Map<String, String> getSchemaStorageConfig() {
            return this.schemaStorageConfig;
        }

        @Override
        public final Builder schemaStorageConfig(Map<String, String> schemaStorageConfig) {
            this.schemaStorageConfig = SchemaStorageConfigCopier.copy(schemaStorageConfig);
            return this;
        }

        public final void setSchemaStorageConfig(Map<String, String> schemaStorageConfig) {
            this.schemaStorageConfig = SchemaStorageConfigCopier.copy(schemaStorageConfig);
        }

        public ContinuousExportDescription build() {
            return new ContinuousExportDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ContinuousExportDescription> {
        public Builder exportId(String var1);

        public Builder status(String var1);

        public Builder status(ContinuousExportStatus var1);

        public Builder statusDetail(String var1);

        public Builder s3Bucket(String var1);

        public Builder startTime(Instant var1);

        public Builder stopTime(Instant var1);

        public Builder dataSource(String var1);

        public Builder dataSource(DataSource var1);

        public Builder schemaStorageConfig(Map<String, String> var1);
    }
}

