/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.applicationdiscovery.transform.AgentConfigurationStatusMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AgentConfigurationStatus
implements StructuredPojo,
ToCopyableBuilder<Builder, AgentConfigurationStatus> {
    private final String agentId;
    private final Boolean operationSucceeded;
    private final String description;

    private AgentConfigurationStatus(BuilderImpl builder) {
        this.agentId = builder.agentId;
        this.operationSucceeded = builder.operationSucceeded;
        this.description = builder.description;
    }

    public String agentId() {
        return this.agentId;
    }

    public Boolean operationSucceeded() {
        return this.operationSucceeded;
    }

    public String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.agentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationSucceeded());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentConfigurationStatus)) {
            return false;
        }
        AgentConfigurationStatus other = (AgentConfigurationStatus)obj;
        return Objects.equals(this.agentId(), other.agentId()) && Objects.equals(this.operationSucceeded(), other.operationSucceeded()) && Objects.equals(this.description(), other.description());
    }

    public String toString() {
        return ToString.builder((String)"AgentConfigurationStatus").add("AgentId", (Object)this.agentId()).add("OperationSucceeded", (Object)this.operationSucceeded()).add("Description", (Object)this.description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "agentId": {
                return Optional.ofNullable(clazz.cast(this.agentId()));
            }
            case "operationSucceeded": {
                return Optional.ofNullable(clazz.cast(this.operationSucceeded()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AgentConfigurationStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String agentId;
        private Boolean operationSucceeded;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentConfigurationStatus model) {
            this.agentId(model.agentId);
            this.operationSucceeded(model.operationSucceeded);
            this.description(model.description);
        }

        public final String getAgentId() {
            return this.agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        public final Boolean getOperationSucceeded() {
            return this.operationSucceeded;
        }

        @Override
        public final Builder operationSucceeded(Boolean operationSucceeded) {
            this.operationSucceeded = operationSucceeded;
            return this;
        }

        public final void setOperationSucceeded(Boolean operationSucceeded) {
            this.operationSucceeded = operationSucceeded;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public AgentConfigurationStatus build() {
            return new AgentConfigurationStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AgentConfigurationStatus> {
        public Builder agentId(String var1);

        public Builder operationSucceeded(Boolean var1);

        public Builder description(String var1);
    }
}

