/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationautoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a CloudWatch alarm associated with a scaling policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Alarm implements SdkPojo, Serializable, ToCopyableBuilder<Alarm.Builder, Alarm> {
    private static final SdkField<String> ALARM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Alarm::alarmName)).setter(setter(Builder::alarmName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmName").build()).build();

    private static final SdkField<String> ALARM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Alarm::alarmARN)).setter(setter(Builder::alarmARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmARN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARM_NAME_FIELD,
            ALARM_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String alarmName;

    private final String alarmARN;

    private Alarm(BuilderImpl builder) {
        this.alarmName = builder.alarmName;
        this.alarmARN = builder.alarmARN;
    }

    /**
     * <p>
     * The name of the alarm.
     * </p>
     * 
     * @return The name of the alarm.
     */
    public String alarmName() {
        return alarmName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the alarm.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the alarm.
     */
    public String alarmARN() {
        return alarmARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(alarmName());
        hashCode = 31 * hashCode + Objects.hashCode(alarmARN());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Alarm)) {
            return false;
        }
        Alarm other = (Alarm) obj;
        return Objects.equals(alarmName(), other.alarmName()) && Objects.equals(alarmARN(), other.alarmARN());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Alarm").add("AlarmName", alarmName()).add("AlarmARN", alarmARN()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AlarmName":
            return Optional.ofNullable(clazz.cast(alarmName()));
        case "AlarmARN":
            return Optional.ofNullable(clazz.cast(alarmARN()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Alarm, T> g) {
        return obj -> g.apply((Alarm) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Alarm> {
        /**
         * <p>
         * The name of the alarm.
         * </p>
         * 
         * @param alarmName
         *        The name of the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmName(String alarmName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the alarm.
         * </p>
         * 
         * @param alarmARN
         *        The Amazon Resource Name (ARN) of the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmARN(String alarmARN);
    }

    static final class BuilderImpl implements Builder {
        private String alarmName;

        private String alarmARN;

        private BuilderImpl() {
        }

        private BuilderImpl(Alarm model) {
            alarmName(model.alarmName);
            alarmARN(model.alarmARN);
        }

        public final String getAlarmName() {
            return alarmName;
        }

        @Override
        public final Builder alarmName(String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        public final void setAlarmName(String alarmName) {
            this.alarmName = alarmName;
        }

        public final String getAlarmARN() {
            return alarmARN;
        }

        @Override
        public final Builder alarmARN(String alarmARN) {
            this.alarmARN = alarmARN;
            return this;
        }

        public final void setAlarmARN(String alarmARN) {
            this.alarmARN = alarmARN;
        }

        @Override
        public Alarm build() {
            return new Alarm(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
