/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationautoscaling;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.applicationautoscaling.model.DeleteScalingPolicyRequest;
import software.amazon.awssdk.services.applicationautoscaling.model.DeleteScalingPolicyResponse;
import software.amazon.awssdk.services.applicationautoscaling.model.DeleteScheduledActionRequest;
import software.amazon.awssdk.services.applicationautoscaling.model.DeleteScheduledActionResponse;
import software.amazon.awssdk.services.applicationautoscaling.model.DeregisterScalableTargetRequest;
import software.amazon.awssdk.services.applicationautoscaling.model.DeregisterScalableTargetResponse;
import software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalableTargetsRequest;
import software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalableTargetsResponse;
import software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingActivitiesRequest;
import software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingActivitiesResponse;
import software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingPoliciesRequest;
import software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingPoliciesResponse;
import software.amazon.awssdk.services.applicationautoscaling.model.DescribeScheduledActionsRequest;
import software.amazon.awssdk.services.applicationautoscaling.model.DescribeScheduledActionsResponse;
import software.amazon.awssdk.services.applicationautoscaling.model.PutScalingPolicyRequest;
import software.amazon.awssdk.services.applicationautoscaling.model.PutScalingPolicyResponse;
import software.amazon.awssdk.services.applicationautoscaling.model.PutScheduledActionRequest;
import software.amazon.awssdk.services.applicationautoscaling.model.PutScheduledActionResponse;
import software.amazon.awssdk.services.applicationautoscaling.model.RegisterScalableTargetRequest;
import software.amazon.awssdk.services.applicationautoscaling.model.RegisterScalableTargetResponse;
import software.amazon.awssdk.services.applicationautoscaling.paginators.DescribeScalableTargetsPublisher;
import software.amazon.awssdk.services.applicationautoscaling.paginators.DescribeScalingActivitiesPublisher;
import software.amazon.awssdk.services.applicationautoscaling.paginators.DescribeScalingPoliciesPublisher;
import software.amazon.awssdk.services.applicationautoscaling.paginators.DescribeScheduledActionsPublisher;

/**
 * Service client for accessing Application Auto Scaling asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * With Application Auto Scaling, you can configure automatic scaling for the following resources:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Amazon ECS services
 * </p>
 * </li>
 * <li>
 * <p>
 * Amazon EC2 Spot Fleet requests
 * </p>
 * </li>
 * <li>
 * <p>
 * Amazon EMR clusters
 * </p>
 * </li>
 * <li>
 * <p>
 * Amazon AppStream 2.0 fleets
 * </p>
 * </li>
 * <li>
 * <p>
 * Amazon DynamoDB tables and global secondary indexes throughput capacity
 * </p>
 * </li>
 * <li>
 * <p>
 * Amazon Aurora Replicas
 * </p>
 * </li>
 * <li>
 * <p>
 * Amazon SageMaker endpoint variants
 * </p>
 * </li>
 * <li>
 * <p>
 * Custom resources provided by your own applications or services
 * </p>
 * </li>
 * <li>
 * <p>
 * Amazon Comprehend document classification endpoints
 * </p>
 * </li>
 * <li>
 * <p>
 * AWS Lambda function provisioned concurrency
 * </p>
 * </li>
 * </ul>
 * <p>
 * <b>API Summary</b>
 * </p>
 * <p>
 * The Application Auto Scaling service API includes three key sets of actions:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Register and manage scalable targets - Register AWS or custom resources as scalable targets (a resource that
 * Application Auto Scaling can scale), set minimum and maximum capacity limits, and retrieve information on existing
 * scalable targets.
 * </p>
 * </li>
 * <li>
 * <p>
 * Configure and manage automatic scaling - Define scaling policies to dynamically scale your resources in response to
 * CloudWatch alarms, schedule one-time or recurring scaling actions, and retrieve your recent scaling activity history.
 * </p>
 * </li>
 * <li>
 * <p>
 * Suspend and resume scaling - Temporarily suspend and later resume automatic scaling by calling the
 * <a>RegisterScalableTarget</a> action for any Application Auto Scaling scalable target. You can suspend and resume,
 * individually or in combination, scale-out activities triggered by a scaling policy, scale-in activities triggered by
 * a scaling policy, and scheduled scaling.
 * </p>
 * </li>
 * </ul>
 * <p>
 * To learn more about Application Auto Scaling, including information about granting IAM users required permissions for
 * Application Auto Scaling actions, see the <a
 * href="https://docs.aws.amazon.com/autoscaling/application/userguide/what-is-application-auto-scaling.html"
 * >Application Auto Scaling User Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface ApplicationAutoScalingAsyncClient extends SdkClient {
    String SERVICE_NAME = "application-autoscaling";

    /**
     * Create a {@link ApplicationAutoScalingAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ApplicationAutoScalingAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ApplicationAutoScalingAsyncClient}.
     */
    static ApplicationAutoScalingAsyncClientBuilder builder() {
        return new DefaultApplicationAutoScalingAsyncClientBuilder();
    }

    /**
     * <p>
     * Deletes the specified scaling policy for an Application Auto Scaling scalable target.
     * </p>
     * <p>
     * Deleting a step scaling policy deletes the underlying alarm action, but does not delete the CloudWatch alarm
     * associated with the scaling policy, even if it no longer has an associated action.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html#delete-step-scaling-policy"
     * >Delete a Step Scaling Policy</a> and <a href=
     * "https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html#delete-target-tracking-policy"
     * >Delete a Target Tracking Scaling Policy</a> in the <i>Application Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * To create a scaling policy or update an existing one, see <a>PutScalingPolicy</a>.
     * </p>
     *
     * @param deleteScalingPolicyRequest
     * @return A Java Future containing the result of the DeleteScalingPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception was thrown for a validation issue. Review the available parameters
     *         for the API request.</li>
     *         <li>ObjectNotFoundException The specified object could not be found. For any operation that depends on
     *         the existence of a scalable target, this exception is thrown if the scalable target with the specified
     *         service namespace, resource ID, and scalable dimension does not exist. For any operation that deletes or
     *         deregisters a resource, this exception is thrown if the resource cannot be found.</li>
     *         <li>ConcurrentUpdateException Concurrent updates caused an exception, for example, if you request an
     *         update to an Application Auto Scaling resource that already has a pending update.</li>
     *         <li>InternalServiceException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationAutoScalingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationAutoScalingAsyncClient.DeleteScalingPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DeleteScalingPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteScalingPolicyResponse> deleteScalingPolicy(
            DeleteScalingPolicyRequest deleteScalingPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified scaling policy for an Application Auto Scaling scalable target.
     * </p>
     * <p>
     * Deleting a step scaling policy deletes the underlying alarm action, but does not delete the CloudWatch alarm
     * associated with the scaling policy, even if it no longer has an associated action.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html#delete-step-scaling-policy"
     * >Delete a Step Scaling Policy</a> and <a href=
     * "https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html#delete-target-tracking-policy"
     * >Delete a Target Tracking Scaling Policy</a> in the <i>Application Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * To create a scaling policy or update an existing one, see <a>PutScalingPolicy</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteScalingPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteScalingPolicyRequest#builder()}
     * </p>
     *
     * @param deleteScalingPolicyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteScalingPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteScalingPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception was thrown for a validation issue. Review the available parameters
     *         for the API request.</li>
     *         <li>ObjectNotFoundException The specified object could not be found. For any operation that depends on
     *         the existence of a scalable target, this exception is thrown if the scalable target with the specified
     *         service namespace, resource ID, and scalable dimension does not exist. For any operation that deletes or
     *         deregisters a resource, this exception is thrown if the resource cannot be found.</li>
     *         <li>ConcurrentUpdateException Concurrent updates caused an exception, for example, if you request an
     *         update to an Application Auto Scaling resource that already has a pending update.</li>
     *         <li>InternalServiceException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationAutoScalingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationAutoScalingAsyncClient.DeleteScalingPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DeleteScalingPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteScalingPolicyResponse> deleteScalingPolicy(
            Consumer<DeleteScalingPolicyRequest.Builder> deleteScalingPolicyRequest) {
        return deleteScalingPolicy(DeleteScalingPolicyRequest.builder().applyMutation(deleteScalingPolicyRequest).build());
    }

    /**
     * <p>
     * Deletes the specified scheduled action for an Application Auto Scaling scalable target.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-scheduled-scaling.html#delete-scheduled-action"
     * >Delete a Scheduled Action</a> in the <i>Application Auto Scaling User Guide</i>.
     * </p>
     *
     * @param deleteScheduledActionRequest
     * @return A Java Future containing the result of the DeleteScheduledAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception was thrown for a validation issue. Review the available parameters
     *         for the API request.</li>
     *         <li>ObjectNotFoundException The specified object could not be found. For any operation that depends on
     *         the existence of a scalable target, this exception is thrown if the scalable target with the specified
     *         service namespace, resource ID, and scalable dimension does not exist. For any operation that deletes or
     *         deregisters a resource, this exception is thrown if the resource cannot be found.</li>
     *         <li>ConcurrentUpdateException Concurrent updates caused an exception, for example, if you request an
     *         update to an Application Auto Scaling resource that already has a pending update.</li>
     *         <li>InternalServiceException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationAutoScalingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationAutoScalingAsyncClient.DeleteScheduledAction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DeleteScheduledAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteScheduledActionResponse> deleteScheduledAction(
            DeleteScheduledActionRequest deleteScheduledActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified scheduled action for an Application Auto Scaling scalable target.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-scheduled-scaling.html#delete-scheduled-action"
     * >Delete a Scheduled Action</a> in the <i>Application Auto Scaling User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteScheduledActionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteScheduledActionRequest#builder()}
     * </p>
     *
     * @param deleteScheduledActionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteScheduledActionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteScheduledAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception was thrown for a validation issue. Review the available parameters
     *         for the API request.</li>
     *         <li>ObjectNotFoundException The specified object could not be found. For any operation that depends on
     *         the existence of a scalable target, this exception is thrown if the scalable target with the specified
     *         service namespace, resource ID, and scalable dimension does not exist. For any operation that deletes or
     *         deregisters a resource, this exception is thrown if the resource cannot be found.</li>
     *         <li>ConcurrentUpdateException Concurrent updates caused an exception, for example, if you request an
     *         update to an Application Auto Scaling resource that already has a pending update.</li>
     *         <li>InternalServiceException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationAutoScalingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationAutoScalingAsyncClient.DeleteScheduledAction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DeleteScheduledAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteScheduledActionResponse> deleteScheduledAction(
            Consumer<DeleteScheduledActionRequest.Builder> deleteScheduledActionRequest) {
        return deleteScheduledAction(DeleteScheduledActionRequest.builder().applyMutation(deleteScheduledActionRequest).build());
    }

    /**
     * <p>
     * Deregisters an Application Auto Scaling scalable target.
     * </p>
     * <p>
     * Deregistering a scalable target deletes the scaling policies that are associated with it.
     * </p>
     * <p>
     * To create a scalable target or update an existing one, see <a>RegisterScalableTarget</a>.
     * </p>
     *
     * @param deregisterScalableTargetRequest
     * @return A Java Future containing the result of the DeregisterScalableTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception was thrown for a validation issue. Review the available parameters
     *         for the API request.</li>
     *         <li>ObjectNotFoundException The specified object could not be found. For any operation that depends on
     *         the existence of a scalable target, this exception is thrown if the scalable target with the specified
     *         service namespace, resource ID, and scalable dimension does not exist. For any operation that deletes or
     *         deregisters a resource, this exception is thrown if the resource cannot be found.</li>
     *         <li>ConcurrentUpdateException Concurrent updates caused an exception, for example, if you request an
     *         update to an Application Auto Scaling resource that already has a pending update.</li>
     *         <li>InternalServiceException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationAutoScalingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationAutoScalingAsyncClient.DeregisterScalableTarget
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DeregisterScalableTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterScalableTargetResponse> deregisterScalableTarget(
            DeregisterScalableTargetRequest deregisterScalableTargetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deregisters an Application Auto Scaling scalable target.
     * </p>
     * <p>
     * Deregistering a scalable target deletes the scaling policies that are associated with it.
     * </p>
     * <p>
     * To create a scalable target or update an existing one, see <a>RegisterScalableTarget</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterScalableTargetRequest.Builder} avoiding
     * the need to create one manually via {@link DeregisterScalableTargetRequest#builder()}
     * </p>
     *
     * @param deregisterScalableTargetRequest
     *        A {@link Consumer} that will call methods on {@link DeregisterScalableTargetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeregisterScalableTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception was thrown for a validation issue. Review the available parameters
     *         for the API request.</li>
     *         <li>ObjectNotFoundException The specified object could not be found. For any operation that depends on
     *         the existence of a scalable target, this exception is thrown if the scalable target with the specified
     *         service namespace, resource ID, and scalable dimension does not exist. For any operation that deletes or
     *         deregisters a resource, this exception is thrown if the resource cannot be found.</li>
     *         <li>ConcurrentUpdateException Concurrent updates caused an exception, for example, if you request an
     *         update to an Application Auto Scaling resource that already has a pending update.</li>
     *         <li>InternalServiceException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationAutoScalingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationAutoScalingAsyncClient.DeregisterScalableTarget
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DeregisterScalableTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterScalableTargetResponse> deregisterScalableTarget(
            Consumer<DeregisterScalableTargetRequest.Builder> deregisterScalableTargetRequest) {
        return deregisterScalableTarget(DeregisterScalableTargetRequest.builder().applyMutation(deregisterScalableTargetRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about the scalable targets in the specified namespace.
     * </p>
     * <p>
     * You can filter the results using <code>ResourceIds</code> and <code>ScalableDimension</code>.
     * </p>
     * <p>
     * To create a scalable target or update an existing one, see <a>RegisterScalableTarget</a>. If you are no longer
     * using a scalable target, you can deregister it using <a>DeregisterScalableTarget</a>.
     * </p>
     *
     * @param describeScalableTargetsRequest
     * @return A Java Future containing the result of the DescribeScalableTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception was thrown for a validation issue. Review the available parameters
     *         for the API request.</li>
     *         <li>InvalidNextTokenException The next token supplied was invalid.</li>
     *         <li>ConcurrentUpdateException Concurrent updates caused an exception, for example, if you request an
     *         update to an Application Auto Scaling resource that already has a pending update.</li>
     *         <li>InternalServiceException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationAutoScalingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationAutoScalingAsyncClient.DescribeScalableTargets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DescribeScalableTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeScalableTargetsResponse> describeScalableTargets(
            DescribeScalableTargetsRequest describeScalableTargetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the scalable targets in the specified namespace.
     * </p>
     * <p>
     * You can filter the results using <code>ResourceIds</code> and <code>ScalableDimension</code>.
     * </p>
     * <p>
     * To create a scalable target or update an existing one, see <a>RegisterScalableTarget</a>. If you are no longer
     * using a scalable target, you can deregister it using <a>DeregisterScalableTarget</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeScalableTargetsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeScalableTargetsRequest#builder()}
     * </p>
     *
     * @param describeScalableTargetsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeScalableTargetsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeScalableTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception was thrown for a validation issue. Review the available parameters
     *         for the API request.</li>
     *         <li>InvalidNextTokenException The next token supplied was invalid.</li>
     *         <li>ConcurrentUpdateException Concurrent updates caused an exception, for example, if you request an
     *         update to an Application Auto Scaling resource that already has a pending update.</li>
     *         <li>InternalServiceException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationAutoScalingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationAutoScalingAsyncClient.DescribeScalableTargets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DescribeScalableTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeScalableTargetsResponse> describeScalableTargets(
            Consumer<DescribeScalableTargetsRequest.Builder> describeScalableTargetsRequest) {
        return describeScalableTargets(DescribeScalableTargetsRequest.builder().applyMutation(describeScalableTargetsRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about the scalable targets in the specified namespace.
     * </p>
     * <p>
     * You can filter the results using <code>ResourceIds</code> and <code>ScalableDimension</code>.
     * </p>
     * <p>
     * To create a scalable target or update an existing one, see <a>RegisterScalableTarget</a>. If you are no longer
     * using a scalable target, you can deregister it using <a>DeregisterScalableTarget</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeScalableTargets(software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalableTargetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationautoscaling.paginators.DescribeScalableTargetsPublisher publisher = client.describeScalableTargetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationautoscaling.paginators.DescribeScalableTargetsPublisher publisher = client.describeScalableTargetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalableTargetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalableTargetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeScalableTargets(software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalableTargetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeScalableTargetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception was thrown for a validation issue. Review the available parameters
     *         for the API request.</li>
     *         <li>InvalidNextTokenException The next token supplied was invalid.</li>
     *         <li>ConcurrentUpdateException Concurrent updates caused an exception, for example, if you request an
     *         update to an Application Auto Scaling resource that already has a pending update.</li>
     *         <li>InternalServiceException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationAutoScalingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationAutoScalingAsyncClient.DescribeScalableTargets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DescribeScalableTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeScalableTargetsPublisher describeScalableTargetsPaginator(
            DescribeScalableTargetsRequest describeScalableTargetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the scalable targets in the specified namespace.
     * </p>
     * <p>
     * You can filter the results using <code>ResourceIds</code> and <code>ScalableDimension</code>.
     * </p>
     * <p>
     * To create a scalable target or update an existing one, see <a>RegisterScalableTarget</a>. If you are no longer
     * using a scalable target, you can deregister it using <a>DeregisterScalableTarget</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeScalableTargets(software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalableTargetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationautoscaling.paginators.DescribeScalableTargetsPublisher publisher = client.describeScalableTargetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationautoscaling.paginators.DescribeScalableTargetsPublisher publisher = client.describeScalableTargetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalableTargetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalableTargetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeScalableTargets(software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalableTargetsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeScalableTargetsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeScalableTargetsRequest#builder()}
     * </p>
     *
     * @param describeScalableTargetsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeScalableTargetsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception was thrown for a validation issue. Review the available parameters
     *         for the API request.</li>
     *         <li>InvalidNextTokenException The next token supplied was invalid.</li>
     *         <li>ConcurrentUpdateException Concurrent updates caused an exception, for example, if you request an
     *         update to an Application Auto Scaling resource that already has a pending update.</li>
     *         <li>InternalServiceException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationAutoScalingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationAutoScalingAsyncClient.DescribeScalableTargets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DescribeScalableTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeScalableTargetsPublisher describeScalableTargetsPaginator(
            Consumer<DescribeScalableTargetsRequest.Builder> describeScalableTargetsRequest) {
        return describeScalableTargetsPaginator(DescribeScalableTargetsRequest.builder()
                .applyMutation(describeScalableTargetsRequest).build());
    }

    /**
     * <p>
     * Provides descriptive information about the scaling activities in the specified namespace from the previous six
     * weeks.
     * </p>
     * <p>
     * You can filter the results using <code>ResourceId</code> and <code>ScalableDimension</code>.
     * </p>
     * <p>
     * Scaling activities are triggered by CloudWatch alarms that are associated with scaling policies. To view the
     * scaling policies for a service namespace, see <a>DescribeScalingPolicies</a>. To create a scaling policy or
     * update an existing one, see <a>PutScalingPolicy</a>.
     * </p>
     *
     * @param describeScalingActivitiesRequest
     * @return A Java Future containing the result of the DescribeScalingActivities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception was thrown for a validation issue. Review the available parameters
     *         for the API request.</li>
     *         <li>InvalidNextTokenException The next token supplied was invalid.</li>
     *         <li>ConcurrentUpdateException Concurrent updates caused an exception, for example, if you request an
     *         update to an Application Auto Scaling resource that already has a pending update.</li>
     *         <li>InternalServiceException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationAutoScalingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationAutoScalingAsyncClient.DescribeScalingActivities
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DescribeScalingActivities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeScalingActivitiesResponse> describeScalingActivities(
            DescribeScalingActivitiesRequest describeScalingActivitiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides descriptive information about the scaling activities in the specified namespace from the previous six
     * weeks.
     * </p>
     * <p>
     * You can filter the results using <code>ResourceId</code> and <code>ScalableDimension</code>.
     * </p>
     * <p>
     * Scaling activities are triggered by CloudWatch alarms that are associated with scaling policies. To view the
     * scaling policies for a service namespace, see <a>DescribeScalingPolicies</a>. To create a scaling policy or
     * update an existing one, see <a>PutScalingPolicy</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeScalingActivitiesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeScalingActivitiesRequest#builder()}
     * </p>
     *
     * @param describeScalingActivitiesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeScalingActivitiesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeScalingActivities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception was thrown for a validation issue. Review the available parameters
     *         for the API request.</li>
     *         <li>InvalidNextTokenException The next token supplied was invalid.</li>
     *         <li>ConcurrentUpdateException Concurrent updates caused an exception, for example, if you request an
     *         update to an Application Auto Scaling resource that already has a pending update.</li>
     *         <li>InternalServiceException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationAutoScalingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationAutoScalingAsyncClient.DescribeScalingActivities
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DescribeScalingActivities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeScalingActivitiesResponse> describeScalingActivities(
            Consumer<DescribeScalingActivitiesRequest.Builder> describeScalingActivitiesRequest) {
        return describeScalingActivities(DescribeScalingActivitiesRequest.builder()
                .applyMutation(describeScalingActivitiesRequest).build());
    }

    /**
     * <p>
     * Provides descriptive information about the scaling activities in the specified namespace from the previous six
     * weeks.
     * </p>
     * <p>
     * You can filter the results using <code>ResourceId</code> and <code>ScalableDimension</code>.
     * </p>
     * <p>
     * Scaling activities are triggered by CloudWatch alarms that are associated with scaling policies. To view the
     * scaling policies for a service namespace, see <a>DescribeScalingPolicies</a>. To create a scaling policy or
     * update an existing one, see <a>PutScalingPolicy</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeScalingActivities(software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingActivitiesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationautoscaling.paginators.DescribeScalingActivitiesPublisher publisher = client.describeScalingActivitiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationautoscaling.paginators.DescribeScalingActivitiesPublisher publisher = client.describeScalingActivitiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingActivitiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingActivitiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeScalingActivities(software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingActivitiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeScalingActivitiesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception was thrown for a validation issue. Review the available parameters
     *         for the API request.</li>
     *         <li>InvalidNextTokenException The next token supplied was invalid.</li>
     *         <li>ConcurrentUpdateException Concurrent updates caused an exception, for example, if you request an
     *         update to an Application Auto Scaling resource that already has a pending update.</li>
     *         <li>InternalServiceException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationAutoScalingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationAutoScalingAsyncClient.DescribeScalingActivities
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DescribeScalingActivities"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeScalingActivitiesPublisher describeScalingActivitiesPaginator(
            DescribeScalingActivitiesRequest describeScalingActivitiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides descriptive information about the scaling activities in the specified namespace from the previous six
     * weeks.
     * </p>
     * <p>
     * You can filter the results using <code>ResourceId</code> and <code>ScalableDimension</code>.
     * </p>
     * <p>
     * Scaling activities are triggered by CloudWatch alarms that are associated with scaling policies. To view the
     * scaling policies for a service namespace, see <a>DescribeScalingPolicies</a>. To create a scaling policy or
     * update an existing one, see <a>PutScalingPolicy</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeScalingActivities(software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingActivitiesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationautoscaling.paginators.DescribeScalingActivitiesPublisher publisher = client.describeScalingActivitiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationautoscaling.paginators.DescribeScalingActivitiesPublisher publisher = client.describeScalingActivitiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingActivitiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingActivitiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeScalingActivities(software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingActivitiesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeScalingActivitiesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeScalingActivitiesRequest#builder()}
     * </p>
     *
     * @param describeScalingActivitiesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeScalingActivitiesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception was thrown for a validation issue. Review the available parameters
     *         for the API request.</li>
     *         <li>InvalidNextTokenException The next token supplied was invalid.</li>
     *         <li>ConcurrentUpdateException Concurrent updates caused an exception, for example, if you request an
     *         update to an Application Auto Scaling resource that already has a pending update.</li>
     *         <li>InternalServiceException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationAutoScalingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationAutoScalingAsyncClient.DescribeScalingActivities
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DescribeScalingActivities"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeScalingActivitiesPublisher describeScalingActivitiesPaginator(
            Consumer<DescribeScalingActivitiesRequest.Builder> describeScalingActivitiesRequest) {
        return describeScalingActivitiesPaginator(DescribeScalingActivitiesRequest.builder()
                .applyMutation(describeScalingActivitiesRequest).build());
    }

    /**
     * <p>
     * Describes the Application Auto Scaling scaling policies for the specified service namespace.
     * </p>
     * <p>
     * You can filter the results using <code>ResourceId</code>, <code>ScalableDimension</code>, and
     * <code>PolicyNames</code>.
     * </p>
     * <p>
     * To create a scaling policy or update an existing one, see <a>PutScalingPolicy</a>. If you are no longer using a
     * scaling policy, you can delete it using <a>DeleteScalingPolicy</a>.
     * </p>
     *
     * @param describeScalingPoliciesRequest
     * @return A Java Future containing the result of the DescribeScalingPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception was thrown for a validation issue. Review the available parameters
     *         for the API request.</li>
     *         <li>FailedResourceAccessException Failed access to resources caused an exception. This exception is
     *         thrown when Application Auto Scaling is unable to retrieve the alarms associated with a scaling policy
     *         due to a client error, for example, if the role ARN specified for a scalable target does not have
     *         permission to call the CloudWatch <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeAlarms.html"
     *         >DescribeAlarms</a> on your behalf.</li>
     *         <li>InvalidNextTokenException The next token supplied was invalid.</li>
     *         <li>ConcurrentUpdateException Concurrent updates caused an exception, for example, if you request an
     *         update to an Application Auto Scaling resource that already has a pending update.</li>
     *         <li>InternalServiceException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationAutoScalingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationAutoScalingAsyncClient.DescribeScalingPolicies
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DescribeScalingPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeScalingPoliciesResponse> describeScalingPolicies(
            DescribeScalingPoliciesRequest describeScalingPoliciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the Application Auto Scaling scaling policies for the specified service namespace.
     * </p>
     * <p>
     * You can filter the results using <code>ResourceId</code>, <code>ScalableDimension</code>, and
     * <code>PolicyNames</code>.
     * </p>
     * <p>
     * To create a scaling policy or update an existing one, see <a>PutScalingPolicy</a>. If you are no longer using a
     * scaling policy, you can delete it using <a>DeleteScalingPolicy</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeScalingPoliciesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeScalingPoliciesRequest#builder()}
     * </p>
     *
     * @param describeScalingPoliciesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeScalingPoliciesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeScalingPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception was thrown for a validation issue. Review the available parameters
     *         for the API request.</li>
     *         <li>FailedResourceAccessException Failed access to resources caused an exception. This exception is
     *         thrown when Application Auto Scaling is unable to retrieve the alarms associated with a scaling policy
     *         due to a client error, for example, if the role ARN specified for a scalable target does not have
     *         permission to call the CloudWatch <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeAlarms.html"
     *         >DescribeAlarms</a> on your behalf.</li>
     *         <li>InvalidNextTokenException The next token supplied was invalid.</li>
     *         <li>ConcurrentUpdateException Concurrent updates caused an exception, for example, if you request an
     *         update to an Application Auto Scaling resource that already has a pending update.</li>
     *         <li>InternalServiceException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationAutoScalingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationAutoScalingAsyncClient.DescribeScalingPolicies
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DescribeScalingPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeScalingPoliciesResponse> describeScalingPolicies(
            Consumer<DescribeScalingPoliciesRequest.Builder> describeScalingPoliciesRequest) {
        return describeScalingPolicies(DescribeScalingPoliciesRequest.builder().applyMutation(describeScalingPoliciesRequest)
                .build());
    }

    /**
     * <p>
     * Describes the Application Auto Scaling scaling policies for the specified service namespace.
     * </p>
     * <p>
     * You can filter the results using <code>ResourceId</code>, <code>ScalableDimension</code>, and
     * <code>PolicyNames</code>.
     * </p>
     * <p>
     * To create a scaling policy or update an existing one, see <a>PutScalingPolicy</a>. If you are no longer using a
     * scaling policy, you can delete it using <a>DeleteScalingPolicy</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeScalingPolicies(software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingPoliciesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationautoscaling.paginators.DescribeScalingPoliciesPublisher publisher = client.describeScalingPoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationautoscaling.paginators.DescribeScalingPoliciesPublisher publisher = client.describeScalingPoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingPoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingPoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeScalingPolicies(software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingPoliciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeScalingPoliciesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception was thrown for a validation issue. Review the available parameters
     *         for the API request.</li>
     *         <li>FailedResourceAccessException Failed access to resources caused an exception. This exception is
     *         thrown when Application Auto Scaling is unable to retrieve the alarms associated with a scaling policy
     *         due to a client error, for example, if the role ARN specified for a scalable target does not have
     *         permission to call the CloudWatch <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeAlarms.html"
     *         >DescribeAlarms</a> on your behalf.</li>
     *         <li>InvalidNextTokenException The next token supplied was invalid.</li>
     *         <li>ConcurrentUpdateException Concurrent updates caused an exception, for example, if you request an
     *         update to an Application Auto Scaling resource that already has a pending update.</li>
     *         <li>InternalServiceException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationAutoScalingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationAutoScalingAsyncClient.DescribeScalingPolicies
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DescribeScalingPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeScalingPoliciesPublisher describeScalingPoliciesPaginator(
            DescribeScalingPoliciesRequest describeScalingPoliciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the Application Auto Scaling scaling policies for the specified service namespace.
     * </p>
     * <p>
     * You can filter the results using <code>ResourceId</code>, <code>ScalableDimension</code>, and
     * <code>PolicyNames</code>.
     * </p>
     * <p>
     * To create a scaling policy or update an existing one, see <a>PutScalingPolicy</a>. If you are no longer using a
     * scaling policy, you can delete it using <a>DeleteScalingPolicy</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeScalingPolicies(software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingPoliciesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationautoscaling.paginators.DescribeScalingPoliciesPublisher publisher = client.describeScalingPoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationautoscaling.paginators.DescribeScalingPoliciesPublisher publisher = client.describeScalingPoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingPoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingPoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeScalingPolicies(software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingPoliciesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeScalingPoliciesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeScalingPoliciesRequest#builder()}
     * </p>
     *
     * @param describeScalingPoliciesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeScalingPoliciesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception was thrown for a validation issue. Review the available parameters
     *         for the API request.</li>
     *         <li>FailedResourceAccessException Failed access to resources caused an exception. This exception is
     *         thrown when Application Auto Scaling is unable to retrieve the alarms associated with a scaling policy
     *         due to a client error, for example, if the role ARN specified for a scalable target does not have
     *         permission to call the CloudWatch <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeAlarms.html"
     *         >DescribeAlarms</a> on your behalf.</li>
     *         <li>InvalidNextTokenException The next token supplied was invalid.</li>
     *         <li>ConcurrentUpdateException Concurrent updates caused an exception, for example, if you request an
     *         update to an Application Auto Scaling resource that already has a pending update.</li>
     *         <li>InternalServiceException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationAutoScalingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationAutoScalingAsyncClient.DescribeScalingPolicies
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DescribeScalingPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeScalingPoliciesPublisher describeScalingPoliciesPaginator(
            Consumer<DescribeScalingPoliciesRequest.Builder> describeScalingPoliciesRequest) {
        return describeScalingPoliciesPaginator(DescribeScalingPoliciesRequest.builder()
                .applyMutation(describeScalingPoliciesRequest).build());
    }

    /**
     * <p>
     * Describes the Application Auto Scaling scheduled actions for the specified service namespace.
     * </p>
     * <p>
     * You can filter the results using the <code>ResourceId</code>, <code>ScalableDimension</code>, and
     * <code>ScheduledActionNames</code> parameters.
     * </p>
     * <p>
     * To create a scheduled action or update an existing one, see <a>PutScheduledAction</a>. If you are no longer using
     * a scheduled action, you can delete it using <a>DeleteScheduledAction</a>.
     * </p>
     *
     * @param describeScheduledActionsRequest
     * @return A Java Future containing the result of the DescribeScheduledActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception was thrown for a validation issue. Review the available parameters
     *         for the API request.</li>
     *         <li>InvalidNextTokenException The next token supplied was invalid.</li>
     *         <li>ConcurrentUpdateException Concurrent updates caused an exception, for example, if you request an
     *         update to an Application Auto Scaling resource that already has a pending update.</li>
     *         <li>InternalServiceException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationAutoScalingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationAutoScalingAsyncClient.DescribeScheduledActions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DescribeScheduledActions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeScheduledActionsResponse> describeScheduledActions(
            DescribeScheduledActionsRequest describeScheduledActionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the Application Auto Scaling scheduled actions for the specified service namespace.
     * </p>
     * <p>
     * You can filter the results using the <code>ResourceId</code>, <code>ScalableDimension</code>, and
     * <code>ScheduledActionNames</code> parameters.
     * </p>
     * <p>
     * To create a scheduled action or update an existing one, see <a>PutScheduledAction</a>. If you are no longer using
     * a scheduled action, you can delete it using <a>DeleteScheduledAction</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeScheduledActionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeScheduledActionsRequest#builder()}
     * </p>
     *
     * @param describeScheduledActionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeScheduledActionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeScheduledActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception was thrown for a validation issue. Review the available parameters
     *         for the API request.</li>
     *         <li>InvalidNextTokenException The next token supplied was invalid.</li>
     *         <li>ConcurrentUpdateException Concurrent updates caused an exception, for example, if you request an
     *         update to an Application Auto Scaling resource that already has a pending update.</li>
     *         <li>InternalServiceException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationAutoScalingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationAutoScalingAsyncClient.DescribeScheduledActions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DescribeScheduledActions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeScheduledActionsResponse> describeScheduledActions(
            Consumer<DescribeScheduledActionsRequest.Builder> describeScheduledActionsRequest) {
        return describeScheduledActions(DescribeScheduledActionsRequest.builder().applyMutation(describeScheduledActionsRequest)
                .build());
    }

    /**
     * <p>
     * Describes the Application Auto Scaling scheduled actions for the specified service namespace.
     * </p>
     * <p>
     * You can filter the results using the <code>ResourceId</code>, <code>ScalableDimension</code>, and
     * <code>ScheduledActionNames</code> parameters.
     * </p>
     * <p>
     * To create a scheduled action or update an existing one, see <a>PutScheduledAction</a>. If you are no longer using
     * a scheduled action, you can delete it using <a>DeleteScheduledAction</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeScheduledActions(software.amazon.awssdk.services.applicationautoscaling.model.DescribeScheduledActionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationautoscaling.paginators.DescribeScheduledActionsPublisher publisher = client.describeScheduledActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationautoscaling.paginators.DescribeScheduledActionsPublisher publisher = client.describeScheduledActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.applicationautoscaling.model.DescribeScheduledActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.applicationautoscaling.model.DescribeScheduledActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeScheduledActions(software.amazon.awssdk.services.applicationautoscaling.model.DescribeScheduledActionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeScheduledActionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception was thrown for a validation issue. Review the available parameters
     *         for the API request.</li>
     *         <li>InvalidNextTokenException The next token supplied was invalid.</li>
     *         <li>ConcurrentUpdateException Concurrent updates caused an exception, for example, if you request an
     *         update to an Application Auto Scaling resource that already has a pending update.</li>
     *         <li>InternalServiceException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationAutoScalingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationAutoScalingAsyncClient.DescribeScheduledActions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DescribeScheduledActions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeScheduledActionsPublisher describeScheduledActionsPaginator(
            DescribeScheduledActionsRequest describeScheduledActionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the Application Auto Scaling scheduled actions for the specified service namespace.
     * </p>
     * <p>
     * You can filter the results using the <code>ResourceId</code>, <code>ScalableDimension</code>, and
     * <code>ScheduledActionNames</code> parameters.
     * </p>
     * <p>
     * To create a scheduled action or update an existing one, see <a>PutScheduledAction</a>. If you are no longer using
     * a scheduled action, you can delete it using <a>DeleteScheduledAction</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeScheduledActions(software.amazon.awssdk.services.applicationautoscaling.model.DescribeScheduledActionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationautoscaling.paginators.DescribeScheduledActionsPublisher publisher = client.describeScheduledActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationautoscaling.paginators.DescribeScheduledActionsPublisher publisher = client.describeScheduledActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.applicationautoscaling.model.DescribeScheduledActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.applicationautoscaling.model.DescribeScheduledActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeScheduledActions(software.amazon.awssdk.services.applicationautoscaling.model.DescribeScheduledActionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeScheduledActionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeScheduledActionsRequest#builder()}
     * </p>
     *
     * @param describeScheduledActionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeScheduledActionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception was thrown for a validation issue. Review the available parameters
     *         for the API request.</li>
     *         <li>InvalidNextTokenException The next token supplied was invalid.</li>
     *         <li>ConcurrentUpdateException Concurrent updates caused an exception, for example, if you request an
     *         update to an Application Auto Scaling resource that already has a pending update.</li>
     *         <li>InternalServiceException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationAutoScalingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationAutoScalingAsyncClient.DescribeScheduledActions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/DescribeScheduledActions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeScheduledActionsPublisher describeScheduledActionsPaginator(
            Consumer<DescribeScheduledActionsRequest.Builder> describeScheduledActionsRequest) {
        return describeScheduledActionsPaginator(DescribeScheduledActionsRequest.builder()
                .applyMutation(describeScheduledActionsRequest).build());
    }

    /**
     * <p>
     * Creates or updates a policy for an Application Auto Scaling scalable target.
     * </p>
     * <p>
     * Each scalable target is identified by a service namespace, resource ID, and scalable dimension. A scaling policy
     * applies to the scalable target identified by those three attributes. You cannot create a scaling policy until you
     * have registered the resource as a scalable target using <a>RegisterScalableTarget</a>.
     * </p>
     * <p>
     * To update a policy, specify its policy name and the parameters that you want to change. Any parameters that you
     * don't specify are not changed by this update request.
     * </p>
     * <p>
     * You can view the scaling policies for a service namespace using <a>DescribeScalingPolicies</a>. If you are no
     * longer using a scaling policy, you can delete it using <a>DeleteScalingPolicy</a>.
     * </p>
     * <p>
     * Multiple scaling policies can be in force at the same time for the same scalable target. You can have one or more
     * target tracking scaling policies, one or more step scaling policies, or both. However, there is a chance that
     * multiple policies could conflict, instructing the scalable target to scale out or in at the same time.
     * Application Auto Scaling gives precedence to the policy that provides the largest capacity for both scale out and
     * scale in. For example, if one policy increases capacity by 3, another policy increases capacity by 200 percent,
     * and the current capacity is 10, Application Auto Scaling uses the policy with the highest calculated capacity
     * (200% of 10 = 20) and scales out to 30.
     * </p>
     * <p>
     * Learn more about how to work with scaling policies in the <a
     * href="https://docs.aws.amazon.com/autoscaling/application/userguide/what-is-application-auto-scaling.html"
     * >Application Auto Scaling User Guide</a>.
     * </p>
     *
     * @param putScalingPolicyRequest
     * @return A Java Future containing the result of the PutScalingPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception was thrown for a validation issue. Review the available parameters
     *         for the API request.</li>
     *         <li>LimitExceededException A per-account resource limit is exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/ApplicationAutoScaling/latest/userguide/application-auto-scaling-limits.html"
     *         >Application Auto Scaling Limits</a>.</li>
     *         <li>ObjectNotFoundException The specified object could not be found. For any operation that depends on
     *         the existence of a scalable target, this exception is thrown if the scalable target with the specified
     *         service namespace, resource ID, and scalable dimension does not exist. For any operation that deletes or
     *         deregisters a resource, this exception is thrown if the resource cannot be found.</li>
     *         <li>ConcurrentUpdateException Concurrent updates caused an exception, for example, if you request an
     *         update to an Application Auto Scaling resource that already has a pending update.</li>
     *         <li>FailedResourceAccessException Failed access to resources caused an exception. This exception is
     *         thrown when Application Auto Scaling is unable to retrieve the alarms associated with a scaling policy
     *         due to a client error, for example, if the role ARN specified for a scalable target does not have
     *         permission to call the CloudWatch <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeAlarms.html"
     *         >DescribeAlarms</a> on your behalf.</li>
     *         <li>InternalServiceException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationAutoScalingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationAutoScalingAsyncClient.PutScalingPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/PutScalingPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutScalingPolicyResponse> putScalingPolicy(PutScalingPolicyRequest putScalingPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates a policy for an Application Auto Scaling scalable target.
     * </p>
     * <p>
     * Each scalable target is identified by a service namespace, resource ID, and scalable dimension. A scaling policy
     * applies to the scalable target identified by those three attributes. You cannot create a scaling policy until you
     * have registered the resource as a scalable target using <a>RegisterScalableTarget</a>.
     * </p>
     * <p>
     * To update a policy, specify its policy name and the parameters that you want to change. Any parameters that you
     * don't specify are not changed by this update request.
     * </p>
     * <p>
     * You can view the scaling policies for a service namespace using <a>DescribeScalingPolicies</a>. If you are no
     * longer using a scaling policy, you can delete it using <a>DeleteScalingPolicy</a>.
     * </p>
     * <p>
     * Multiple scaling policies can be in force at the same time for the same scalable target. You can have one or more
     * target tracking scaling policies, one or more step scaling policies, or both. However, there is a chance that
     * multiple policies could conflict, instructing the scalable target to scale out or in at the same time.
     * Application Auto Scaling gives precedence to the policy that provides the largest capacity for both scale out and
     * scale in. For example, if one policy increases capacity by 3, another policy increases capacity by 200 percent,
     * and the current capacity is 10, Application Auto Scaling uses the policy with the highest calculated capacity
     * (200% of 10 = 20) and scales out to 30.
     * </p>
     * <p>
     * Learn more about how to work with scaling policies in the <a
     * href="https://docs.aws.amazon.com/autoscaling/application/userguide/what-is-application-auto-scaling.html"
     * >Application Auto Scaling User Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutScalingPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link PutScalingPolicyRequest#builder()}
     * </p>
     *
     * @param putScalingPolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutScalingPolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutScalingPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception was thrown for a validation issue. Review the available parameters
     *         for the API request.</li>
     *         <li>LimitExceededException A per-account resource limit is exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/ApplicationAutoScaling/latest/userguide/application-auto-scaling-limits.html"
     *         >Application Auto Scaling Limits</a>.</li>
     *         <li>ObjectNotFoundException The specified object could not be found. For any operation that depends on
     *         the existence of a scalable target, this exception is thrown if the scalable target with the specified
     *         service namespace, resource ID, and scalable dimension does not exist. For any operation that deletes or
     *         deregisters a resource, this exception is thrown if the resource cannot be found.</li>
     *         <li>ConcurrentUpdateException Concurrent updates caused an exception, for example, if you request an
     *         update to an Application Auto Scaling resource that already has a pending update.</li>
     *         <li>FailedResourceAccessException Failed access to resources caused an exception. This exception is
     *         thrown when Application Auto Scaling is unable to retrieve the alarms associated with a scaling policy
     *         due to a client error, for example, if the role ARN specified for a scalable target does not have
     *         permission to call the CloudWatch <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeAlarms.html"
     *         >DescribeAlarms</a> on your behalf.</li>
     *         <li>InternalServiceException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationAutoScalingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationAutoScalingAsyncClient.PutScalingPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/PutScalingPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutScalingPolicyResponse> putScalingPolicy(
            Consumer<PutScalingPolicyRequest.Builder> putScalingPolicyRequest) {
        return putScalingPolicy(PutScalingPolicyRequest.builder().applyMutation(putScalingPolicyRequest).build());
    }

    /**
     * <p>
     * Creates or updates a scheduled action for an Application Auto Scaling scalable target.
     * </p>
     * <p>
     * Each scalable target is identified by a service namespace, resource ID, and scalable dimension. A scheduled
     * action applies to the scalable target identified by those three attributes. You cannot create a scheduled action
     * until you have registered the resource as a scalable target using <a>RegisterScalableTarget</a>.
     * </p>
     * <p>
     * To update an action, specify its name and the parameters that you want to change. If you don't specify start and
     * end times, the old values are deleted. Any other parameters that you don't specify are not changed by this update
     * request.
     * </p>
     * <p>
     * You can view the scheduled actions using <a>DescribeScheduledActions</a>. If you are no longer using a scheduled
     * action, you can delete it using <a>DeleteScheduledAction</a>.
     * </p>
     * <p>
     * Learn more about how to work with scheduled actions in the <a
     * href="https://docs.aws.amazon.com/autoscaling/application/userguide/what-is-application-auto-scaling.html"
     * >Application Auto Scaling User Guide</a>.
     * </p>
     *
     * @param putScheduledActionRequest
     * @return A Java Future containing the result of the PutScheduledAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception was thrown for a validation issue. Review the available parameters
     *         for the API request.</li>
     *         <li>LimitExceededException A per-account resource limit is exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/ApplicationAutoScaling/latest/userguide/application-auto-scaling-limits.html"
     *         >Application Auto Scaling Limits</a>.</li>
     *         <li>ObjectNotFoundException The specified object could not be found. For any operation that depends on
     *         the existence of a scalable target, this exception is thrown if the scalable target with the specified
     *         service namespace, resource ID, and scalable dimension does not exist. For any operation that deletes or
     *         deregisters a resource, this exception is thrown if the resource cannot be found.</li>
     *         <li>ConcurrentUpdateException Concurrent updates caused an exception, for example, if you request an
     *         update to an Application Auto Scaling resource that already has a pending update.</li>
     *         <li>InternalServiceException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationAutoScalingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationAutoScalingAsyncClient.PutScheduledAction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/PutScheduledAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutScheduledActionResponse> putScheduledAction(PutScheduledActionRequest putScheduledActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates a scheduled action for an Application Auto Scaling scalable target.
     * </p>
     * <p>
     * Each scalable target is identified by a service namespace, resource ID, and scalable dimension. A scheduled
     * action applies to the scalable target identified by those three attributes. You cannot create a scheduled action
     * until you have registered the resource as a scalable target using <a>RegisterScalableTarget</a>.
     * </p>
     * <p>
     * To update an action, specify its name and the parameters that you want to change. If you don't specify start and
     * end times, the old values are deleted. Any other parameters that you don't specify are not changed by this update
     * request.
     * </p>
     * <p>
     * You can view the scheduled actions using <a>DescribeScheduledActions</a>. If you are no longer using a scheduled
     * action, you can delete it using <a>DeleteScheduledAction</a>.
     * </p>
     * <p>
     * Learn more about how to work with scheduled actions in the <a
     * href="https://docs.aws.amazon.com/autoscaling/application/userguide/what-is-application-auto-scaling.html"
     * >Application Auto Scaling User Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutScheduledActionRequest.Builder} avoiding the
     * need to create one manually via {@link PutScheduledActionRequest#builder()}
     * </p>
     *
     * @param putScheduledActionRequest
     *        A {@link Consumer} that will call methods on {@link PutScheduledActionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutScheduledAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception was thrown for a validation issue. Review the available parameters
     *         for the API request.</li>
     *         <li>LimitExceededException A per-account resource limit is exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/ApplicationAutoScaling/latest/userguide/application-auto-scaling-limits.html"
     *         >Application Auto Scaling Limits</a>.</li>
     *         <li>ObjectNotFoundException The specified object could not be found. For any operation that depends on
     *         the existence of a scalable target, this exception is thrown if the scalable target with the specified
     *         service namespace, resource ID, and scalable dimension does not exist. For any operation that deletes or
     *         deregisters a resource, this exception is thrown if the resource cannot be found.</li>
     *         <li>ConcurrentUpdateException Concurrent updates caused an exception, for example, if you request an
     *         update to an Application Auto Scaling resource that already has a pending update.</li>
     *         <li>InternalServiceException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationAutoScalingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationAutoScalingAsyncClient.PutScheduledAction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/PutScheduledAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutScheduledActionResponse> putScheduledAction(
            Consumer<PutScheduledActionRequest.Builder> putScheduledActionRequest) {
        return putScheduledAction(PutScheduledActionRequest.builder().applyMutation(putScheduledActionRequest).build());
    }

    /**
     * <p>
     * Registers or updates a scalable target. A scalable target is a resource that Application Auto Scaling can scale
     * out and scale in. Scalable targets are uniquely identified by the combination of resource ID, scalable dimension,
     * and namespace.
     * </p>
     * <p>
     * When you register a new scalable target, you must specify values for minimum and maximum capacity. Application
     * Auto Scaling will not scale capacity to values that are outside of this range.
     * </p>
     * <p>
     * To update a scalable target, specify the parameter that you want to change as well as the following parameters
     * that identify the scalable target: resource ID, scalable dimension, and namespace. Any parameters that you don't
     * specify are not changed by this update request.
     * </p>
     * <p>
     * After you register a scalable target, you do not need to register it again to use other Application Auto Scaling
     * operations. To see which resources have been registered, use <a>DescribeScalableTargets</a>. You can also view
     * the scaling policies for a service namespace by using <a>DescribeScalableTargets</a>.
     * </p>
     * <p>
     * If you no longer need a scalable target, you can deregister it by using <a>DeregisterScalableTarget</a>.
     * </p>
     *
     * @param registerScalableTargetRequest
     * @return A Java Future containing the result of the RegisterScalableTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception was thrown for a validation issue. Review the available parameters
     *         for the API request.</li>
     *         <li>LimitExceededException A per-account resource limit is exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/ApplicationAutoScaling/latest/userguide/application-auto-scaling-limits.html"
     *         >Application Auto Scaling Limits</a>.</li>
     *         <li>ConcurrentUpdateException Concurrent updates caused an exception, for example, if you request an
     *         update to an Application Auto Scaling resource that already has a pending update.</li>
     *         <li>InternalServiceException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationAutoScalingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationAutoScalingAsyncClient.RegisterScalableTarget
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/RegisterScalableTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterScalableTargetResponse> registerScalableTarget(
            RegisterScalableTargetRequest registerScalableTargetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers or updates a scalable target. A scalable target is a resource that Application Auto Scaling can scale
     * out and scale in. Scalable targets are uniquely identified by the combination of resource ID, scalable dimension,
     * and namespace.
     * </p>
     * <p>
     * When you register a new scalable target, you must specify values for minimum and maximum capacity. Application
     * Auto Scaling will not scale capacity to values that are outside of this range.
     * </p>
     * <p>
     * To update a scalable target, specify the parameter that you want to change as well as the following parameters
     * that identify the scalable target: resource ID, scalable dimension, and namespace. Any parameters that you don't
     * specify are not changed by this update request.
     * </p>
     * <p>
     * After you register a scalable target, you do not need to register it again to use other Application Auto Scaling
     * operations. To see which resources have been registered, use <a>DescribeScalableTargets</a>. You can also view
     * the scaling policies for a service namespace by using <a>DescribeScalableTargets</a>.
     * </p>
     * <p>
     * If you no longer need a scalable target, you can deregister it by using <a>DeregisterScalableTarget</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterScalableTargetRequest.Builder} avoiding the
     * need to create one manually via {@link RegisterScalableTargetRequest#builder()}
     * </p>
     *
     * @param registerScalableTargetRequest
     *        A {@link Consumer} that will call methods on {@link RegisterScalableTargetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RegisterScalableTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception was thrown for a validation issue. Review the available parameters
     *         for the API request.</li>
     *         <li>LimitExceededException A per-account resource limit is exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/ApplicationAutoScaling/latest/userguide/application-auto-scaling-limits.html"
     *         >Application Auto Scaling Limits</a>.</li>
     *         <li>ConcurrentUpdateException Concurrent updates caused an exception, for example, if you request an
     *         update to an Application Auto Scaling resource that already has a pending update.</li>
     *         <li>InternalServiceException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationAutoScalingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationAutoScalingAsyncClient.RegisterScalableTarget
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/RegisterScalableTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterScalableTargetResponse> registerScalableTarget(
            Consumer<RegisterScalableTargetRequest.Builder> registerScalableTargetRequest) {
        return registerScalableTarget(RegisterScalableTargetRequest.builder().applyMutation(registerScalableTargetRequest)
                .build());
    }
}
