/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appintegrations.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appintegrations.AppIntegrationsClient;
import software.amazon.awssdk.services.appintegrations.internal.UserAgentUtils;
import software.amazon.awssdk.services.appintegrations.model.DataIntegrationSummary;
import software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationsRequest;
import software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationsResponse;

public class ListDataIntegrationsIterable
implements SdkIterable<ListDataIntegrationsResponse> {
    private final AppIntegrationsClient client;
    private final ListDataIntegrationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDataIntegrationsIterable(AppIntegrationsClient client, ListDataIntegrationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDataIntegrationsResponseFetcher();
    }

    public Iterator<ListDataIntegrationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DataIntegrationSummary> dataIntegrations() {
        Function<ListDataIntegrationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dataIntegrations() != null) {
                return response.dataIntegrations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDataIntegrationsResponseFetcher
    implements SyncPageFetcher<ListDataIntegrationsResponse> {
        private ListDataIntegrationsResponseFetcher() {
        }

        public boolean hasNextPage(ListDataIntegrationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDataIntegrationsResponse nextPage(ListDataIntegrationsResponse previousPage) {
            if (previousPage == null) {
                return ListDataIntegrationsIterable.this.client.listDataIntegrations(ListDataIntegrationsIterable.this.firstRequest);
            }
            return ListDataIntegrationsIterable.this.client.listDataIntegrations((ListDataIntegrationsRequest)((Object)ListDataIntegrationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

