/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appintegrations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appintegrations.model.AppIntegrationsRequest;
import software.amazon.awssdk.services.appintegrations.model.ScheduleConfiguration;
import software.amazon.awssdk.services.appintegrations.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDataIntegrationRequest
extends AppIntegrationsRequest
implements ToCopyableBuilder<Builder, CreateDataIntegrationRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateDataIntegrationRequest.getter(CreateDataIntegrationRequest::name)).setter(CreateDataIntegrationRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateDataIntegrationRequest.getter(CreateDataIntegrationRequest::description)).setter(CreateDataIntegrationRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> KMS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKey").getter(CreateDataIntegrationRequest.getter(CreateDataIntegrationRequest::kmsKey)).setter(CreateDataIntegrationRequest.setter(Builder::kmsKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKey").build()}).build();
    private static final SdkField<String> SOURCE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceURI").getter(CreateDataIntegrationRequest.getter(CreateDataIntegrationRequest::sourceURI)).setter(CreateDataIntegrationRequest.setter(Builder::sourceURI)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceURI").build()}).build();
    private static final SdkField<ScheduleConfiguration> SCHEDULE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScheduleConfig").getter(CreateDataIntegrationRequest.getter(CreateDataIntegrationRequest::scheduleConfig)).setter(CreateDataIntegrationRequest.setter(Builder::scheduleConfig)).constructor(ScheduleConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleConfig").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateDataIntegrationRequest.getter(CreateDataIntegrationRequest::tags)).setter(CreateDataIntegrationRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateDataIntegrationRequest.getter(CreateDataIntegrationRequest::clientToken)).setter(CreateDataIntegrationRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, KMS_KEY_FIELD, SOURCE_URI_FIELD, SCHEDULE_CONFIG_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD));
    private final String name;
    private final String description;
    private final String kmsKey;
    private final String sourceURI;
    private final ScheduleConfiguration scheduleConfig;
    private final Map<String, String> tags;
    private final String clientToken;

    private CreateDataIntegrationRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.kmsKey = builder.kmsKey;
        this.sourceURI = builder.sourceURI;
        this.scheduleConfig = builder.scheduleConfig;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String kmsKey() {
        return this.kmsKey;
    }

    public final String sourceURI() {
        return this.sourceURI;
    }

    public final ScheduleConfiguration scheduleConfig() {
        return this.scheduleConfig;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceURI());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataIntegrationRequest)) {
            return false;
        }
        CreateDataIntegrationRequest other = (CreateDataIntegrationRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.kmsKey(), other.kmsKey()) && Objects.equals(this.sourceURI(), other.sourceURI()) && Objects.equals(this.scheduleConfig(), other.scheduleConfig()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDataIntegrationRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("KmsKey", (Object)this.kmsKey()).add("SourceURI", (Object)this.sourceURI()).add("ScheduleConfig", (Object)this.scheduleConfig()).add("Tags", this.hasTags() ? this.tags() : null).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "KmsKey": {
                return Optional.ofNullable(clazz.cast(this.kmsKey()));
            }
            case "SourceURI": {
                return Optional.ofNullable(clazz.cast(this.sourceURI()));
            }
            case "ScheduleConfig": {
                return Optional.ofNullable(clazz.cast(this.scheduleConfig()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDataIntegrationRequest, T> g) {
        return obj -> g.apply((CreateDataIntegrationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppIntegrationsRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String kmsKey;
        private String sourceURI;
        private ScheduleConfiguration scheduleConfig;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataIntegrationRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.kmsKey(model.kmsKey);
            this.sourceURI(model.sourceURI);
            this.scheduleConfig(model.scheduleConfig);
            this.tags(model.tags);
            this.clientToken(model.clientToken);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getKmsKey() {
            return this.kmsKey;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final String getSourceURI() {
            return this.sourceURI;
        }

        public final void setSourceURI(String sourceURI) {
            this.sourceURI = sourceURI;
        }

        @Override
        public final Builder sourceURI(String sourceURI) {
            this.sourceURI = sourceURI;
            return this;
        }

        public final ScheduleConfiguration.Builder getScheduleConfig() {
            return this.scheduleConfig != null ? this.scheduleConfig.toBuilder() : null;
        }

        public final void setScheduleConfig(ScheduleConfiguration.BuilderImpl scheduleConfig) {
            this.scheduleConfig = scheduleConfig != null ? scheduleConfig.build() : null;
        }

        @Override
        public final Builder scheduleConfig(ScheduleConfiguration scheduleConfig) {
            this.scheduleConfig = scheduleConfig;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataIntegrationRequest build() {
            return new CreateDataIntegrationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppIntegrationsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDataIntegrationRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder kmsKey(String var1);

        public Builder sourceURI(String var1);

        public Builder scheduleConfig(ScheduleConfiguration var1);

        default public Builder scheduleConfig(Consumer<ScheduleConfiguration.Builder> scheduleConfig) {
            return this.scheduleConfig((ScheduleConfiguration)((ScheduleConfiguration.Builder)ScheduleConfiguration.builder().applyMutation(scheduleConfig)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

